/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RefundProcessor {
    private Ticket ticket;
    private double totalTransactionTaxAmount = 0.0;

    public RefundProcessor(Ticket ticket) {
        this.ticket = ticket;
    }

    public void doRefund(List<PosTransaction> selectedTransactions, boolean forceCashRefund) throws Exception {
        this.doRefund(selectedTransactions, forceCashRefund, false);
    }

    private void doRefund(List<PosTransaction> selectedTransactions, boolean forceCashRefund, boolean refundUsingGiftCard) throws Exception {
        double refundAmount;
        double refundableAmount = this.getRefundableAmount();
        String giftCardNo = null;
        if (refundUsingGiftCard) {
            GlobalInputDialog inputDialog = new GlobalInputDialog();
            inputDialog.setCaption("Enter gift card number ");
            inputDialog.open();
            if (inputDialog.isCanceled()) {
                return;
            }
            giftCardNo = inputDialog.getInput();
            if (giftCardNo == null) {
                return;
            }
        }
        if ((refundAmount = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", refundableAmount)) < 0.0) {
            return;
        }
        if (refundAmount == 0.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount must be greater than zero.");
            return;
        }
        double refundedTransactionAmount = this.getRefundedAmount(selectedTransactions);
        double paidAmount = NumberUtil.roundToTwoDigit(this.ticket.getPaidAmount()) - refundedTransactionAmount;
        if (refundAmount > refundableAmount || refundAmount > NumberUtil.roundToTwoDigit(this.getTotalTransactionAmount(selectedTransactions) - refundedTransactionAmount)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than selected transaction amount.");
            return;
        }
        if (refundAmount > (paidAmount = NumberUtil.roundToTwoDigit(paidAmount))) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than paid amount.");
            return;
        }
        Double refundTaxAmount = NumberUtil.roundToTwoDigit(this.totalTransactionTaxAmount * refundAmount / this.ticket.getPaidAmount());
        double refundedAmount = PosTransactionService.getInstance().refundTicket(this.ticket, refundAmount, refundTaxAmount, Application.getCurrentUser(), selectedTransactions, forceCashRefund, giftCardNo);
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + refundedAmount);
    }

    private double getTotalTransactionAmount(List<PosTransaction> selectedTransactions) {
        double refundAmount = 0.0;
        for (PosTransaction transaction : selectedTransactions) {
            if (transaction.isVoided().booleanValue()) continue;
            refundAmount += transaction.getAmount().doubleValue();
        }
        return refundAmount;
    }

    private double getRefundableAmount() {
        double refundableAmount = 0.0;
        if (this.ticket.getDueAmount() >= 0.0) {
            return 0.0;
        }
        refundableAmount = Math.abs(this.ticket.getDueAmount());
        return NumberUtil.roundToTwoDigit(refundableAmount);
    }

    private double getRefundedAmount(List<PosTransaction> selectedTransactions) {
        double refundedAmountForTransaction = 0.0;
        for (PosTransaction posTransaction : selectedTransactions) {
            String refundedAmountText;
            if (posTransaction.isVoided().booleanValue() || !StringUtils.isNotEmpty((String)(refundedAmountText = posTransaction.getProperty("REFUNDED_AMOUNT")))) continue;
            try {
                refundedAmountForTransaction += Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {}
        }
        return NumberUtil.roundToTwoDigit(refundedAmountForTransaction);
    }
}

