/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.InginicoPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.RefundDialog;
import com.floreantpos.ui.dialog.TicketDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TicketItemDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ConfirmPayDialog;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.GratuityInputDialog;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentProcessWaitDialog;
import com.floreantpos.ui.views.payment.PaymentReferenceEntryDialog;
import com.floreantpos.ui.views.payment.PosPaymentWaitDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import java.awt.HeadlessException;
import java.awt.Window;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class SettleTicketProcessor
implements CardInputListener {
    public static PosPaymentWaitDialog waitDialog = new PosPaymentWaitDialog();
    private Vector<PaymentListener> paymentListeners = new Vector(3);
    private Ticket ticket;
    private double tenderAmount;
    private PaymentType paymentType;
    private User currentUser;
    private RefreshableView refreshableView;

    public SettleTicketProcessor(User currentUser, RefreshableView refreshableView) {
        this.currentUser = currentUser;
        this.refreshableView = refreshableView;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public double getTenderAmount() {
        return this.tenderAmount;
    }

    public void setTenderAmount(double tenderAmount) {
        this.tenderAmount = tenderAmount;
    }

    public void addPaymentListener(PaymentListener paymentListener) {
        this.paymentListeners.add(paymentListener);
    }

    public void removePaymentListener(PaymentListener paymentListener) {
        this.paymentListeners.remove(paymentListener);
    }

    public void doSettle(PaymentType paymentType, double tenderAmount) throws Exception {
        this.tenderAmount = tenderAmount;
        if (this.ticket == null) {
            return;
        }
        if (!POSUtil.checkDrawerAssignment()) {
            return;
        }
        this.paymentType = paymentType;
        PosTransaction transaction = null;
        switch (paymentType) {
            case CASH: {
                if (!this.confirmPayment()) {
                    return;
                }
                DrawerUtil.kickDrawer();
                transaction = this.doPayByCash(paymentType);
                break;
            }
            case CUSTOM_PAYMENT: {
                CustomPaymentSelectionDialog customPaymentDialog = new CustomPaymentSelectionDialog();
                customPaymentDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                customPaymentDialog.pack();
                customPaymentDialog.open();
                if (customPaymentDialog.isCanceled()) {
                    return;
                }
                if (!this.confirmPayment()) {
                    return;
                }
                transaction = paymentType.createTransaction();
                CustomPaymentTransaction customPaymentTransaction = (CustomPaymentTransaction)transaction;
                customPaymentTransaction.setCustomPaymentFieldName(customPaymentDialog.getPaymentFieldName());
                customPaymentTransaction.setCustomPaymentName(customPaymentDialog.getPaymentName());
                customPaymentTransaction.setCustomPaymentRef(customPaymentDialog.getPaymentRef());
                this.doPayByCustomPayment(customPaymentTransaction);
                break;
            }
            case CREDIT_CARD: 
            case DEBIT_CARD: {
                this.doPayByCard(tenderAmount);
                break;
            }
            case GIFT_CERTIFICATE: {
                this.doPayByGiftCard(tenderAmount);
                break;
            }
            case MEMBER_ACCOUNT: {
                if (!this.confirmPayment()) {
                    return;
                }
                CustomerAccountTransaction customerAccountTransaction = (CustomerAccountTransaction)paymentType.createTransaction();
                customerAccountTransaction.setTicket(this.ticket);
                customerAccountTransaction.setCaptured(true);
                this.setTransactionAmounts(customerAccountTransaction);
                customerAccountTransaction.setCustomerId(this.ticket.getCustomerId());
                this.settleTicket(customerAccountTransaction);
                break;
            }
        }
    }

    public PosTransaction doPayByCash(PaymentType paymentType) {
        PosTransaction transaction = paymentType.createTransaction();
        transaction.setTicket(this.ticket);
        transaction.setCaptured(true);
        this.setTransactionAmounts(transaction);
        this.settleTicket(transaction);
        return transaction;
    }

    public void payByCustomPayment(CustomPayment customPayment, double tenderAmount) {
        this.tenderAmount = tenderAmount;
        CustomPaymentTransaction transaction = new CustomPaymentTransaction();
        transaction.setCustomPaymentFieldName(customPayment.getRefNumberFieldName());
        transaction.setCustomPaymentName(customPayment.getName());
        if (customPayment.isRequiredRefNumber().booleanValue() && StringUtils.isEmpty((String)transaction.getCustomPaymentRef())) {
            PaymentReferenceEntryDialog dialog = new PaymentReferenceEntryDialog(customPayment);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            transaction.setCustomPaymentRef(dialog.getPaymentRef());
        }
        this.doPayByCustomPayment(transaction);
    }

    public void doPayByCustomPayment(CustomPaymentTransaction transaction) {
        transaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
        transaction.setTicket(this.ticket);
        transaction.setCaptured(true);
        this.setTransactionAmounts(transaction);
        this.settleTicket(transaction);
    }

    private void doPayByGiftCard(double tenderedAmount) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException("Gift card payment gateway is not configured.");
            }
            SwipeCardDialog swipeGiftCardDialog = new SwipeCardDialog(this, this.paymentType);
            swipeGiftCardDialog.setAuthorizationEntryVisible(false);
            swipeGiftCardDialog.pack();
            swipeGiftCardDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private boolean confirmPayment() {
        if (!TerminalConfig.isUseSettlementPrompt()) {
            return true;
        }
        ConfirmPayDialog confirmPayDialog = new ConfirmPayDialog();
        confirmPayDialog.setAmount(this.tenderAmount);
        confirmPayDialog.open();
        return !confirmPayDialog.isCanceled();
    }

    public void doSettleBarTabTicket(Ticket ticket, User currentUser) {
        try {
            String msg = "Do you want to settle ticket?";
            int option1 = POSMessageDialog.showYesNoQuestionDialog(null, msg, Messages.getString("NewBarTabAction.4"));
            if (option1 != 0) {
                return;
            }
            for (PosTransaction barTabTransaction : ticket.getTransactions()) {
                barTabTransaction.setAmount(ticket.getDueAmount());
                barTabTransaction.setTenderAmount(ticket.getDueAmount());
                barTabTransaction.setAuthorizable(true);
                this.settleTicket(barTabTransaction);
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void settleTicket(PosTransaction transaction) {
        this.settleTicket(transaction, null);
    }

    public void settleTicket(PosTransaction transaction, PostPaymentProcessor postPaymentProcessor) {
        try {
            this.validateGratuity(transaction);
            double dueAmount = this.ticket.getDueAmount();
            PosTransactionService transactionService = PosTransactionService.getInstance();
            if (postPaymentProcessor == null) {
                transactionService.settleTicket(this.ticket, transaction, this.currentUser);
            } else {
                transactionService.settleTicket(this.ticket, transaction, this.currentUser, postPaymentProcessor);
            }
            this.doAfterSettleTask(transaction, dueAmount, true);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (UnknownHostException e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void doAfterSettleTask(PosTransaction transaction, double dueAmount, boolean printTicket) throws HeadlessException {
        if (printTicket) {
            SettleTicketProcessor.printTicket(this.ticket, transaction);
        }
        SettleTicketProcessor.showTransactionCompleteMsg(dueAmount, transaction.getTenderAmount(), this.ticket, transaction);
        if (NumberUtil.isZero(this.ticket.getDueAmount())) {
            this.doInformListenerPaymentDone();
        } else {
            this.setTicket(this.ticket);
            this.doInformListenerPaymentUpdate();
        }
        NotificationServiceUtils.pulishTicket(this.ticket.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) {
        Window focusedWindow = POSUtil.getFocusedWindow();
        PaymentProcessWaitDialog waitDialog = new PaymentProcessWaitDialog(focusedWindow);
        try {
            waitDialog.setVisible(true);
            switch (selectedPaymentType) {
                case GIFT_CERTIFICATE: {
                    this.giftCardInputted(inputter, selectedPaymentType, cardType);
                    return;
                }
                case CREDIT_CARD: 
                case DEBIT_CARD: {
                    this.creditCardInputted(inputter, selectedPaymentType, cardType);
                    return;
                }
            }
            return;
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(focusedWindow, this.refreshableView);
            return;
        }
        catch (PosException e) {
            POSMessageDialog.showError(focusedWindow, e.getMessage(), e);
            return;
        }
        catch (Exception e) {
            POSMessageDialog.showError(focusedWindow, "Could not make payment. Please try again or consult system administrator.", e);
            return;
        }
        finally {
            waitDialog.setVisible(false);
        }
    }

    private void doPayByCard(double tenderedAmount) throws Exception {
        try {
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            if (paymentGateway instanceof InginicoPlugin) {
                waitDialog.setVisible(true);
                if (!waitDialog.isCanceled()) {
                    this.doInformListenerPaymentDone();
                }
                return;
            }
            if (!paymentGateway.shouldShowCardInputProcessor()) {
                PosTransaction transaction = this.paymentType.createTransaction();
                transaction.setTicket(this.ticket);
                if (!this.confirmPayment()) {
                    return;
                }
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                this.setTransactionAmounts(transaction);
                if (this.ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    paymentGateway.getProcessor().preAuth(transaction);
                } else {
                    paymentGateway.getProcessor().chargeAmount(transaction);
                }
                this.settleTicket(transaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case SWIPE: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, this.paymentType);
                    swipeCardDialog.pack();
                    swipeCardDialog.open();
                    break;
                }
                case MANUAL: {
                    ManualCardEntryDialog dialog = new ManualCardEntryDialog(this, this.paymentType);
                    dialog.pack();
                    dialog.open();
                    break;
                }
                case EXTERNAL_TERMINAL: {
                    AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this, this.paymentType);
                    authorizationCodeDialog.pack();
                    authorizationCodeDialog.open();
                    break;
                }
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void creditCardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) throws Exception {
        if (selectedPaymentType != null) {
            this.paymentType = selectedPaymentType;
        }
        PosTransaction transaction = this.paymentType.createTransaction();
        transaction.setTicket(this.ticket);
        PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
        if (paymentGateway == null) {
            throw new PosException("No credit card payment gateway is configured.");
        }
        CardProcessor cardProcessor = paymentGateway.getProcessor();
        if (inputter instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)inputter;
            String cardString = swipeCardDialog.getCardString();
            if (StringUtils.isEmpty((String)cardString) || cardString.length() < 16) {
                throw new RuntimeException(Messages.getString("SettleTicketDialog.16"));
            }
            if (!this.confirmPayment()) {
                return;
            }
            transaction.setCardType(cardType);
            transaction.setCardTrack(cardString);
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(paymentGateway.getProductName());
            transaction.setCardReader(CardReader.SWIPE.name());
            this.setTransactionAmounts(transaction);
            if (this.ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                cardProcessor.preAuth(transaction);
            } else {
                cardProcessor.chargeAmount(transaction);
            }
            this.settleTicket(transaction);
        } else if (inputter instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(paymentGateway.getProductName());
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardHolderName(mDialog.getCardHolderName());
            transaction.setCardNumber(mDialog.getCardNumber());
            transaction.setCardExpMonth(mDialog.getExpMonth());
            transaction.setCardExpYear(mDialog.getExpYear());
            this.setTransactionAmounts(transaction);
            if (this.ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                cardProcessor.preAuth(transaction);
            } else {
                cardProcessor.chargeAmount(transaction);
            }
            this.settleTicket(transaction);
        } else if (inputter instanceof AuthorizationCodeDialog) {
            PosTransaction selectedTransaction = selectedPaymentType.createTransaction();
            selectedTransaction.setTicket(this.ticket);
            AuthorizationCodeDialog authDialog = (AuthorizationCodeDialog)inputter;
            String authorizationCode = authDialog.getAuthorizationCode();
            if (StringUtils.isEmpty((String)authorizationCode)) {
                throw new PosException(Messages.getString("SettleTicketDialog.17"));
            }
            selectedTransaction.setCardType(cardType);
            selectedTransaction.setCaptured(true);
            selectedTransaction.setAuthorizable(false);
            selectedTransaction.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
            selectedTransaction.setCardAuthCode(authorizationCode);
            this.setTransactionAmounts(selectedTransaction);
            this.settleTicket(selectedTransaction);
        }
    }

    private void giftCardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) throws Exception {
        if (selectedPaymentType != null) {
            this.paymentType = selectedPaymentType;
        }
        PosTransaction transaction = this.paymentType.createTransaction();
        transaction.setTicket(this.ticket);
        GiftCardPaymentPlugin giftCardPaymentGateway = GiftCardConfig.getPaymentGateway();
        if (giftCardPaymentGateway == null) {
            throw new PosException("No payment gateway is configured for gift card.");
        }
        GiftCardProcessor giftCardProcessor = giftCardPaymentGateway.getProcessor();
        if (inputter instanceof SwipeCardDialog) {
            SwipeCardDialog swipeGiftCardDialog = (SwipeCardDialog)inputter;
            String cardNo = swipeGiftCardDialog.getCardString();
            giftCardProcessor.validateCardNo(cardNo);
            transaction.setCardType(cardType);
            transaction.setGiftCertNumber(cardNo);
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.SWIPE.name());
            this.setTransactionAmounts(transaction);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicket(transaction);
        } else if (inputter instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
            giftCardProcessor.validateCardNo(mDialog.getCardNumber());
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardHolderName(mDialog.getCardHolderName());
            transaction.setGiftCertNumber(mDialog.getCardNumber());
            transaction.setCardExpMonth(mDialog.getExpMonth());
            transaction.setCardExpYear(mDialog.getExpYear());
            this.setTransactionAmounts(transaction);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicket(transaction);
        }
    }

    private void updateModel() {
        if (this.ticket == null) {
            return;
        }
        this.ticket.calculatePrice();
    }

    public void doApplyCoupon(int couponType) {
        try {
            if (this.ticket == null) {
                return;
            }
            if (!Application.getCurrentUser().hasPermission(UserPermission.ADD_DISCOUNT)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.7"));
                return;
            }
            if (couponType == 1) {
                TicketDiscountSelectionDialog dialog = new TicketDiscountSelectionDialog(this.ticket);
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
            } else {
                TicketItemDiscountSelectionDialog dialog = new TicketItemDiscountSelectionDialog(this.ticket);
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
            }
            this.updateModel();
            this.doInformListenerPaymentUpdate();
            if (OrderView.getInstance().isVisible()) {
                OrderView.getInstance().setCurrentTicket(this.ticket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void doSetGratuity() {
        if (this.ticket == null) {
            return;
        }
        GratuityInputDialog d = new GratuityInputDialog();
        d.pack();
        d.setResizable(false);
        d.open();
        if (d.isCanceled()) {
            return;
        }
        double gratuityAmount = d.getGratuityAmount();
        Gratuity gratuity = this.ticket.createGratuity();
        gratuity.setAmount(gratuityAmount);
        this.ticket.setGratuity(gratuity);
        this.ticket.calculatePrice();
        this.doInformListenerPaymentUpdate();
    }

    public void doInformListenerPaymentUpdate() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentDataChanged();
        }
    }

    private void setTransactionAmounts(PosTransaction transaction) {
        transaction.setTenderAmount(this.tenderAmount);
        if (this.tenderAmount >= this.ticket.getDueAmount()) {
            transaction.setAmount(this.ticket.getDueAmount());
        } else {
            transaction.setAmount(this.tenderAmount);
        }
    }

    public void doHoldTicket() {
        try {
            if (this.ticket.isReOpened().booleanValue() && this.ticket.getDueAmount() == 0.0) {
                this.ticket.setClosed(true);
            }
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
            for (PaymentListener paymentListener : this.paymentListeners) {
                paymentListener.paymentDone();
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    public void printTicket(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getId())) {
            OrderController.saveOrder(ticket);
        }
        ReceiptPrintService.printTicket(ticket);
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentDataChanged();
        }
    }

    public void doSplitTicket() {
        DataChangeListener listener = new DataChangeListener(){

            @Override
            public Object getSelectedData() {
                return SettleTicketProcessor.this.ticket;
            }

            @Override
            public void dataSetUpdated() {
            }

            @Override
            public void dataRemoved(Object object) {
            }

            @Override
            public void dataChanged(Object object) {
                if (object == null) {
                    return;
                }
                Ticket ticket = (Ticket)object;
                String id = ticket.getId();
                if (StringUtils.isNotEmpty((String)id)) {
                    OrderType orderType = ticket.getOrderType();
                    if (orderType != null && orderType.isRetailOrder().booleanValue()) {
                        SettleTicketProcessor.this.doInformListenerPaymentCancelled();
                    } else {
                        SettleTicketProcessor.this.doInformListenerPaymentDone();
                    }
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }

            @Override
            public void dataChangeCanceled(Object object) {
            }

            @Override
            public void dataAdded(Object object) {
            }
        };
        SplitTicketAction splitAction = new SplitTicketAction();
        splitAction.setDataChangedListener(listener);
        splitAction.execute();
    }

    public void cancelPayment() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentCanceled();
        }
    }

    public static void showTransactionCompleteMsg(double dueAmount, double tenderedAmount, Ticket ticket, PosTransaction transaction) {
        TransactionCompletionDialog dialog = new TransactionCompletionDialog(transaction);
        dialog.setCompletedTransaction(transaction);
        dialog.setTenderedAmount(tenderedAmount);
        dialog.setTotalAmount(dueAmount);
        dialog.setPaidAmount(transaction.getAmount());
        dialog.setDueAmount(ticket.getDueAmount());
        dialog.setGratuityAmount(transaction.getTipsAmount());
        dialog.setChangeAmount(transaction.getChangeAmount());
        dialog.updateView();
        dialog.pack();
        dialog.open();
    }

    public static void printTicket(Ticket ticket, PosTransaction transaction) {
        try {
            if (ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket);
            }
            if (DataProvider.get().getCurrentTerminal().isAutoPrintReceipt()) {
                ReceiptPrintService.printTransaction(transaction);
            }
        }
        catch (Exception ee) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.PRINT_ERROR, ee);
        }
    }

    public void doRefund() {
        new RefundAction().actionPerformed(null);
    }

    private void doForceRefund() {
        double paidAmount = this.ticket.getPaidAmount();
        try {
            double refundAmount = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", Math.abs(this.ticket.getDueAmount()));
            if (refundAmount <= 0.0) {
                return;
            }
            if (refundAmount > Math.abs(this.ticket.getDueAmount())) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than paid amount.");
                return;
            }
            PosTransaction transaction = PaymentType.CASH.createTransaction();
            transaction.setTicket(this.ticket);
            transaction.setCaptured(true);
            transaction.setAmount(refundAmount);
            transaction.setTenderAmount(refundAmount);
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(Application.getInstance().getTerminal());
            transaction.setUser(this.currentUser);
            transaction.setServer(this.currentUser);
            transaction.setCashDrawer(this.currentUser.getActiveDrawerPullReport());
            transaction.setTransactionTime(new Date());
            ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>();
            transactions.add(transaction);
            double totalTransactionTaxAmount = Math.abs(this.ticket.getTaxAmount());
            Double refundTaxAmount = NumberUtil.roundToTwoDigit(totalTransactionTaxAmount * refundAmount / Math.abs(this.ticket.getDueAmount()));
            double refundedAmount = PosTransactionService.getInstance().refundTicket(this.ticket, refundAmount, refundTaxAmount, Application.getCurrentUser(), transactions, true);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + refundedAmount);
            this.doInformListenerPaymentDone();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
            this.ticket.setPaidAmount(paidAmount);
        }
    }

    public void doVoidTicket() {
        if (this.ticket.getId() == null) {
            this.doInformListenerPaymentDone();
            return;
        }
        this.ticket.calculatePrice();
        if (this.ticket.getPaidAmount() > 0.0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), "Cannot void paid ticket");
            return;
        }
        VoidTicketAction action = new VoidTicketAction(this.ticket);
        action.actionPerformed(null);
        if (this.ticket.isVoided().booleanValue()) {
            this.doInformListenerPaymentDone();
        }
    }

    private void validateGratuity(PosTransaction transaction) {
        if (!this.ticket.hasGratuity()) {
            return;
        }
        if (this.ticket.getDueAmount() != transaction.getAmount() && this.ticket.getPaidAmount() + transaction.getTenderAmount() >= this.ticket.getTotalAmount()) {
            Gratuity gratuity = this.ticket.getGratuity();
            gratuity.setAmount(gratuity.getAmount() - (this.ticket.getDueAmount() - transaction.getAmount()));
            this.ticket.calculatePrice();
        }
    }

    private void doInformListenerPaymentDone() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentDone();
        }
    }

    private void doInformListenerPaymentCancelled() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentCanceled();
        }
    }

    private class RefundAction
    extends PosAction {
        public RefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            try {
                double refundedAmount;
                if (SettleTicketProcessor.this.ticket.getTransactions() == null) {
                    SettleTicketProcessor.this.ticket.setTransactions(new HashSet<PosTransaction>());
                }
                if ((refundedAmount = SettleTicketProcessor.this.ticket.getDueAmount().doubleValue()) >= 0.0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No valid refund amount found.");
                    return;
                }
                RefundDialog dialog = new RefundDialog(POSUtil.getFocusedWindow(), SettleTicketProcessor.this.ticket, SettleTicketProcessor.this);
                dialog.setSize(810, 600);
                dialog.open();
                SettleTicketProcessor.this.ticket.calculatePrice();
                if (NumberUtil.isZero(SettleTicketProcessor.this.ticket.getDueAmount())) {
                    SettleTicketProcessor.this.doInformListenerPaymentDone();
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }
            catch (PosException e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
            }
            catch (Exception e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
            }
        }
    }
}

