/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.ReorderTicketAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.TicketInfoButton;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class SplitedTicketSelectionDialog
extends POSDialog {
    private static final Dimension ticketSectionPrefSize = PosUIManager.getSize(180, 160);
    private List<Ticket> splitTickets;
    private JPanel splitTicketsPanel;
    private PosButton btnPay;
    private PosButton btnPayAll;
    private PosButton btnOrderInfo;
    private PosButton btnSelectCustomer;
    private boolean allowCustomerSelection = false;
    private String action;
    private PosButton btnHold;
    private PosButton btnPrint;
    private PosButton btnPrintAll;
    private boolean confirmSpliting;
    private List<ShopTable> selectedTables;
    private OrderType orderType;

    public SplitedTicketSelectionDialog(List<Ticket> tickets) {
        super(POSUtil.getFocusedWindow(), POSConstants.TICKETS.toUpperCase());
        this.splitTickets = tickets;
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
        this.splitTicketsPanel = new JPanel(new WrapLayout(3));
        this.splitTicketsPanel.setBorder(new TitledBorder(POSConstants.TICKETS.toUpperCase().replace(".", "")));
        JScrollPane scrollPane = new JScrollPane(this.splitTicketsPanel);
        scrollPane.setBorder(null);
        centerPanel.add((Component)scrollPane, "Center");
        this.add((Component)centerPanel, "Center");
        this.createButtonPanel();
        this.allowCustomerSelection(false);
    }

    public void setSelectedAction(String action) {
        this.action = action;
        if (StringUtils.isNotEmpty((String)action)) {
            this.btnSelectCustomer.setVisible(false);
            this.btnPay.setVisible(false);
            this.btnPayAll.setVisible(false);
            this.btnHold.setVisible(false);
            this.btnPrint.setVisible(false);
            this.btnPrintAll.setVisible(false);
            this.btnOrderInfo.setVisible(false);
        }
        this.setSelectedSection(null);
    }

    public void allowCustomerSelection(boolean b) {
        this.allowCustomerSelection = b;
        this.btnSelectCustomer.setVisible(b);
        this.rendererTickets();
    }

    public void createButtonPanel() {
        TransparentPanel buttonPanel = new TransparentPanel();
        buttonPanel.setLayout((LayoutManager)new MigLayout("fill,hidemode 3, ins 0 17 10 17", "fill", ""));
        this.btnPayAll = new PosButton(Messages.getString("SplitedTicketSelectionDialog.7"));
        this.btnPayAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doPayAllSelectedTicket(evt);
            }
        });
        this.btnPay = new PosButton(Messages.getString("SplitedTicketSelectionDialog.8"));
        this.btnPay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doPaySelectedTicket();
            }
        });
        this.btnPrintAll = new PosButton(Messages.getString("SplitedTicketSelectionDialog.17"));
        this.btnPrintAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doPrintAllSelectedTicket();
            }
        });
        this.btnPrint = new PosButton(Messages.getString("SplitedTicketSelectionDialog.20"));
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doPrintSelectedTicket();
            }
        });
        this.btnHold = new PosButton(Messages.getString("SplitedTicketSelectionDialog.23"));
        this.btnHold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doHoldSelectedTicket();
            }
        });
        this.btnOrderInfo = new PosButton(Messages.getString("SplitedTicketSelectionDialog.24"));
        this.btnOrderInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doOrderInfoSelectedTicket();
            }
        });
        PosButton btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doCancelSelectedTicket();
            }
        });
        this.btnSelectCustomer = new PosButton("SELECT MEMBER");
        this.btnSelectCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SplitedTicketSelectionDialog.this.doSelectCustomerSelectedTicket();
            }
        });
        this.btnSelectCustomer.setVisible(false);
        buttonPanel.add(this.btnSelectCustomer);
        buttonPanel.add(this.btnOrderInfo);
        buttonPanel.add(this.btnPrintAll);
        buttonPanel.add(this.btnPrint);
        buttonPanel.add(this.btnPayAll);
        buttonPanel.add(this.btnPay);
        buttonPanel.add(this.btnHold);
        buttonPanel.add(btnCancel);
        this.add((Component)buttonPanel, "South");
    }

    private void doOrderInfoSelectedTicket() {
        try {
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            TicketSection selectedSection = this.getSelectedSection();
            if (selectedSection == null) {
                ticketsToShow.addAll(this.splitTickets);
            } else {
                ticketsToShow.add(selectedSection.getTicket());
            }
            try {
                OrderInfoView view = new OrderInfoView(ticketsToShow);
                OrderInfoDialog dialog = new OrderInfoDialog(view);
                dialog.showOnlyPrintButton();
                dialog.setSize(PosUIManager.getSize(400), PosUIManager.getSize(600));
                dialog.setDefaultCloseOperation(2);
                dialog.setLocationRelativeTo(Application.getPosWindow());
                dialog.open();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    protected void updateTicketView(Ticket splitTicket) {
        for (int row = 0; row < this.splitTickets.size(); ++row) {
            Ticket modelTicket = this.splitTickets.get(row);
            if (!modelTicket.getShortId().equals(splitTicket.getShortId())) continue;
            this.splitTickets.set(row, splitTicket);
        }
    }

    private boolean confirmSpliting(boolean updateView) {
        boolean continueSpliting;
        boolean saveRequired = false;
        for (Ticket ticket : this.splitTickets) {
            if (ticket.getId() != null) continue;
            saveRequired = true;
            break;
        }
        if (!saveRequired) {
            return true;
        }
        boolean bl = continueSpliting = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Operation cannot be undone.Do you want to continue?", "Confirm") == 0;
        if (continueSpliting) {
            List<Integer> tableNumbers = this.splitTickets.get(0).getTableNumbers();
            TicketDAO.getInstance().saveOrUpdateSplitTickets(this.splitTickets, tableNumbers);
            this.confirmSpliting = true;
            if (updateView) {
                this.updateView();
            }
        }
        return continueSpliting;
    }

    public boolean isConfirmSpliting() {
        return this.confirmSpliting;
    }

    protected double getDueAmount() {
        double dueAmount = 0.0;
        for (Ticket ticket : this.splitTickets) {
            dueAmount += ticket.getDueAmount().doubleValue();
        }
        return dueAmount;
    }

    protected void saveTicketsIfRequired() {
        boolean saveRequired = false;
        for (Ticket ticket : this.splitTickets) {
            if (!ticket.isPaid().booleanValue() && !(ticket.getPaidAmount() > 0.0)) continue;
            saveRequired = true;
            break;
        }
        if (saveRequired) {
            ArrayList<Ticket> ticketsTobeSaved = new ArrayList<Ticket>();
            for (Ticket ticket : this.splitTickets) {
                if (ticket.isPaid().booleanValue() || ticket.isClosed().booleanValue()) continue;
                ticketsTobeSaved.add(ticket);
            }
            if (ticketsTobeSaved.isEmpty()) {
                return;
            }
            List<Integer> list = this.splitTickets.get(0).getTableNumbers();
            TicketDAO.getInstance().saveOrUpdateSplitTickets(ticketsTobeSaved, list);
        }
    }

    public void setRefundMode(boolean refundMode) {
        this.btnPay.setVisible(!refundMode);
        this.btnPayAll.setVisible(!refundMode);
    }

    public void updateView() {
        if (this.splitTickets == null) {
            return;
        }
        for (Component c : this.splitTicketsPanel.getComponents()) {
            TicketSection section = (TicketSection)c;
            section.updateView();
        }
    }

    public void rendererTickets() {
        if (this.splitTickets == null) {
            return;
        }
        this.splitTicketsPanel.removeAll();
        for (Ticket splitTicket : this.splitTickets) {
            TicketSection button = new TicketSection(splitTicket);
            button.setPreferredSize(StyledTicketSelectionDialog.tokenSize);
            this.splitTicketsPanel.add(button);
        }
        this.setSelectedSection(this.getFirstSection());
        this.splitTicketsPanel.revalidate();
        this.splitTicketsPanel.repaint();
    }

    private void doCreateNewTicket() {
        try {
            List<ShopTable> selectedTables = this.getSelectedTables();
            if (selectedTables.isEmpty()) {
                return;
            }
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), selectedTables, null);
        }
        catch (TicketAlreadyExistsException e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public void setSelectedSection(TicketSection section) {
        for (Component c : this.splitTicketsPanel.getComponents()) {
            TicketSection sec = (TicketSection)c;
            if (sec == section) {
                sec.setSelected(true);
                continue;
            }
            sec.setSelected(false);
        }
    }

    public TicketSection getSelectedSection() {
        for (Component c : this.splitTicketsPanel.getComponents()) {
            TicketSection sec = (TicketSection)c;
            if (!sec.isSelected()) continue;
            return sec;
        }
        return null;
    }

    public TicketSection getFirstSection() {
        int n = 0;
        Component[] componentArray = this.splitTicketsPanel.getComponents();
        int n2 = componentArray.length;
        if (n < n2) {
            Component c = componentArray[n];
            TicketSection sec = (TicketSection)c;
            return sec;
        }
        return null;
    }

    public Ticket getTicket() {
        if (this.getSelectedSection() != null) {
            return this.getSelectedSection().getTicket();
        }
        return null;
    }

    public void hidePayButtons(boolean b) {
        this.btnPay.setVisible(!b);
        this.btnPayAll.setVisible(!b);
    }

    public List<ShopTable> getSelectedTables() {
        return this.selectedTables;
    }

    public void setSelectedTables(List<ShopTable> selectedTables) {
        this.selectedTables = selectedTables;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public boolean isAllowCustomerSelection() {
        return this.allowCustomerSelection;
    }

    public String getAction() {
        return this.action;
    }

    private void doPaySelectedTicket() {
        try {
            TicketSection selectedSection = this.getSelectedSection();
            if (selectedSection == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select ticket.");
                return;
            }
            Ticket splitTicket = selectedSection.getTicket();
            if (splitTicket == null) {
                return;
            }
            if (splitTicket.isPaid().booleanValue()) {
                POSMessageDialog.showMessage(Messages.getString("SplitedTicketSelectionDialog.9"));
                return;
            }
            SettleTicketAction action = new SettleTicketAction(splitTicket);
            action.actionPerformed(null);
            this.saveTicketsIfRequired();
            this.updateView();
            if (this.getDueAmount() <= 0.0) {
                this.dispose();
            } else {
                this.setCanceled(false);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doPrintAllSelectedTicket() {
        try {
            if (!this.confirmSpliting(true)) {
                return;
            }
            for (Ticket splitTicket : this.splitTickets) {
                ReceiptPrintService.printTicket(splitTicket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doPayAllSelectedTicket(ActionEvent evt) {
        try {
            for (Ticket ticket : this.splitTickets) {
                if (ticket.getId() == null) continue;
                TicketDAO.getInstance().loadFullTicket(ticket);
            }
            GroupSettleTicketAction action = new GroupSettleTicketAction(this.splitTickets, null);
            action.actionPerformed(evt);
            this.saveTicketsIfRequired();
            if (this.getDueAmount() <= 0.0) {
                this.dispose();
            } else {
                this.updateView();
                this.setCanceled(false);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doPrintSelectedTicket() {
        try {
            TicketSection selectedSection = this.getSelectedSection();
            if (selectedSection == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select ticket.");
                return;
            }
            Ticket splitTicket = selectedSection.getTicket();
            if (splitTicket == null) {
                return;
            }
            if (!this.confirmSpliting(true)) {
                return;
            }
            ReceiptPrintService.printTicket(splitTicket);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doHoldSelectedTicket() {
        try {
            this.saveTicketsIfRequired();
            if (!this.confirmSpliting(false)) {
                return;
            }
            this.setCanceled(OrderView.getInstance().isVisible());
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doCancelSelectedTicket() {
        try {
            this.setCanceled(true);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doSelectCustomerSelectedTicket() {
        try {
            Ticket splitTicket = this.getSelectedSection().getTicket();
            if (splitTicket == null) {
                return;
            }
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(splitTicket.getOrderType());
            dialog.setCreateNewTicket(false);
            dialog.openUndecoratedFullScreen();
            if (!dialog.isCanceled()) {
                Customer selectedCustomer = dialog.getSelectedCustomer();
                splitTicket.setCustomerId(selectedCustomer.getId());
                splitTicket.setCustomer(selectedCustomer);
                this.updateView();
                this.splitTicketsPanel.revalidate();
                this.splitTicketsPanel.repaint();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private class TicketSection
    extends TicketInfoButton
    implements MouseListener {
        public TicketSection(Ticket ticket) {
            super(ticket);
            this.addMouseListener(this);
            this.setPreferredSize(ticketSectionPrefSize);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SplitedTicketSelectionDialog.this.setSelectedSection(this);
            if (SplitedTicketSelectionDialog.this.action != null) {
                SplitedTicketSelectionDialog.this.setCanceled(false);
                SplitedTicketSelectionDialog.this.dispose();
                DataChangeListener listener = new DataChangeListener(){

                    @Override
                    public Object getSelectedData() {
                        return SplitedTicketSelectionDialog.this.getSelectedSection().getTicket();
                    }

                    @Override
                    public void dataSetUpdated() {
                    }

                    @Override
                    public void dataRemoved(Object object) {
                    }

                    @Override
                    public void dataChanged(Object object) {
                    }

                    @Override
                    public void dataChangeCanceled(Object object) {
                    }

                    @Override
                    public void dataAdded(Object object) {
                    }
                };
                Ticket splitTicket = SplitedTicketSelectionDialog.this.getSelectedSection().getTicket();
                if (splitTicket == null) {
                    SplitedTicketSelectionDialog.this.doCreateNewTicket();
                } else if (SplitedTicketSelectionDialog.this.action.equals(POSConstants.SETTLE)) {
                    SettleTicketAction action = new SettleTicketAction(listener);
                    action.actionPerformed(null);
                } else if (SplitedTicketSelectionDialog.this.action.equals(POSConstants.SEND_TO_KITCHEN)) {
                    ArrayList<Ticket> tickets = new ArrayList<Ticket>();
                    tickets.add(splitTicket);
                    SendToKitchenAction action = new SendToKitchenAction(listener);
                    action.execute();
                } else if (SplitedTicketSelectionDialog.this.action.equals(POSConstants.ORDER_INFO)) {
                    ShowOrderInfoAction action = new ShowOrderInfoAction(listener);
                    action.execute();
                } else if (SplitedTicketSelectionDialog.this.action.equals(POSConstants.SPLIT_TICKET)) {
                    SplitTicketAction action = new SplitTicketAction(listener);
                    action.execute();
                } else if (SplitedTicketSelectionDialog.this.action.equals(POSConstants.REORDER_TICKET_BUTTON_TEXT)) {
                    ReorderTicketAction action = new ReorderTicketAction(listener);
                    action.execute();
                } else if (SplitedTicketSelectionDialog.this.action.equals(POSConstants.EDIT)) {
                    TicketEditAction action = new TicketEditAction(listener);
                    action.execute();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

