/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.voidticket;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.ticket.VoidItemViewerTable;
import com.floreantpos.ui.views.order.actions.VoidItemSplitViewsListener;
import com.floreantpos.ui.views.voidticket.VoidTicketItemView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class VoidItemSplitView
extends TransparentPanel
implements TableModelListener {
    private Ticket ticket;
    private VoidTicketItemView voidTicketItemView;
    private PosButton btnScrollDown;
    private PosButton btnScrollUp;
    private PosButton btnTransferToTicket1;
    private JScrollPane scrollPane;
    private VoidItemViewerTable voidItemViewerTable;
    protected int splitNumber;
    private VoidItemSplitViewsListener listener;
    private int noOfCustomSplit;
    private List<Integer> selectedTicketNumbers;

    public VoidItemSplitView(VoidItemSplitViewsListener listener) {
        this.listener = listener;
        this.initComponents();
        this.setOpaque(true);
        this.setTicket(this.ticket);
    }

    public List<VoidItem> getAllVoidItems() {
        return this.voidItemViewerTable.getVoidItems();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("VoidItemSplitView.0"), 2, 0));
        this.setPreferredSize(PosUIManager.getSize(280, 463));
        TransparentPanel ticketTableViewPanel = new TransparentPanel(new BorderLayout());
        ticketTableViewPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        int rightGap = PosUIManager.getSize(60) + 10;
        TransparentPanel ticketTotalPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 " + rightGap + " "));
        TransparentPanel rightButtonPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 1,fill,hidemode 3,inset 1"));
        this.btnScrollUp = new PosButton();
        this.btnScrollDown = new PosButton();
        this.btnTransferToTicket1 = new PosButton();
        this.btnTransferToTicket1.setIcon(IconFactory.getIcon("previous.png"));
        this.scrollPane = new JScrollPane();
        this.voidItemViewerTable = new VoidItemViewerTable();
        this.voidItemViewerTable.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.btnScrollUp.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.btnScrollUp.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidItemSplitView.this.doScrollUp(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollUp, "grow");
        this.btnScrollDown.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.btnScrollDown.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidItemSplitView.this.doScrollDown(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollDown, "grow");
        this.btnTransferToTicket1.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnTransferToTicket1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidItemSplitView.this.btnTransferToTicket1ActionPerformed();
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportView(this.voidItemViewerTable);
        ticketTableViewPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)rightButtonPanel, "East");
        this.add((Component)ticketTotalPanel, "South");
        this.add((Component)ticketTableViewPanel, "Center");
        this.voidItemViewerTable.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.voidItemViewerTable.setAutoResizeMode(4);
        this.setColumnWidth(2, PosUIManager.getSize(100));
        this.setColumnWidth(3, PosUIManager.getSize(100));
        this.setColumnWidth(4, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.voidItemViewerTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void btnTransferToTicket1ActionPerformed() {
        if (this.voidTicketItemView != null && this.voidTicketItemView.isVisible() && this.voidItemViewerTable.getSelectedRow() != -1) {
            int selectedRow = this.voidItemViewerTable.getSelectedRow();
            VoidItem voidItem = this.voidItemViewerTable.get(selectedRow);
            TicketItem ticketItemto = null;
            if (voidItem != null) {
                List ticketItems = this.ticket.getDeletedItems();
                if (ticketItems != null) {
                    for (TicketItem ticketItem : ticketItems) {
                        if (!ticketItem.getMenuItemId().equals(voidItem.getMenuItemId())) continue;
                        ticketItemto = ticketItem;
                    }
                }
                if (ticketItemto != null) {
                    this.listener.itemSelected(ticketItemto, this, this.voidTicketItemView, voidItem);
                }
            }
        }
    }

    public int getNoOfCustomSplit() {
        return this.noOfCustomSplit;
    }

    public List<Integer> getViewNumbers() {
        return this.selectedTicketNumbers;
    }

    private void doScrollDown(ActionEvent evt) {
        this.voidItemViewerTable.scrollDown();
    }

    private void doScrollUp(ActionEvent evt) {
        this.voidItemViewerTable.scrollUp();
    }

    public void updateModel() {
        this.ticket.calculatePrice();
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket _ticket) {
        this.ticket = _ticket;
    }

    public void setVoidTicketItemView(VoidTicketItemView voidTicketItemView) {
        this.voidTicketItemView = voidTicketItemView;
    }

    public VoidItemViewerTable getVoidItemViewerTable() {
        return this.voidItemViewerTable;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }
}

