/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.db.update.UpdateDBTo101;
import com.floreantpos.db.update.UpdateDBTo104;
import com.floreantpos.db.update.UpdateDBTo122;
import com.floreantpos.db.update.UpdateDBTo129;
import com.floreantpos.db.update.UpdateDBTo135;
import com.floreantpos.db.update.UpdateDBTo151;
import com.floreantpos.main.Application;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DefaultDataInserter;
import com.floreantpos.versioning.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

public class DatabaseUtil {
    public static final Integer DATABASE_VERSION = 154;
    private static Log logger = LogFactory.getLog(DatabaseUtil.class);
    static Attribute smallSize;
    static Attribute mediumSize;
    static Attribute largeSize;

    public static void checkConnection(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password) throws DatabaseConnectionException {
        _RootDAO.releaseConnection();
        try {
            Class.forName(hibernateConnectionDriverClass);
            DriverManager.getConnection(connectionString, user, password);
        }
        catch (Exception e) {
            throw new DatabaseConnectionException("Could not connect to database. " + e.getMessage());
        }
    }

    public static void initialize() throws DatabaseConnectionException {
        _RootDAO.initialize();
    }

    public static void initialize(String hibernanetCfgFile) throws DatabaseConnectionException {
        _RootDAO.initialize(hibernanetCfgFile);
    }

    public static void initialize(String hibernanetCfgFile, String hibernateDialectClass, String driverClass, String connectString, String databaseUser, String databasePassword) {
        _RootDAO.initialize(hibernanetCfgFile, hibernateDialectClass, driverClass, connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile, Map<String, String> properties) {
        _RootDAO.initialize(hibernanetCfgFile, properties);
    }

    public static void initialize(Map<String, String> properties) {
        _RootDAO.initialize(properties);
    }

    public static boolean createDatabase(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password, boolean exportSampleData) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), connectionString, hibernateDialect, hibernateConnectionDriverClass, user, password, exportSampleData);
    }

    public static boolean createDatabase(String hibernateCfgFileName, String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password, boolean exportSampleData) {
        DefaultDataInserter dataInserter;
        StandardServiceRegistry standardRegistry;
        block3: {
            try {
                _RootDAO.releaseConnection();
                StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().configure(hibernateCfgFileName);
                registryBuilder.applySetting("hibernate.dialect", (Object)hibernateDialect);
                registryBuilder.applySetting("hibernate.connection.driver_class", (Object)hibernateConnectionDriverClass);
                registryBuilder.applySetting("hibernate.connection.url", (Object)connectionString);
                registryBuilder.applySetting("hibernate.connection.username", (Object)user);
                registryBuilder.applySetting("hibernate.connection.password", (Object)password);
                registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create");
                registryBuilder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"0");
                registryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
                standardRegistry = registryBuilder.build();
                Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
                SchemaExport schemaExport = new SchemaExport();
                EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE);
                schemaExport.create(enumSet, metaData);
                _RootDAO.setSessionFactory(metaData.buildSessionFactory());
                dataInserter = new DefaultDataInserter();
                dataInserter.insertDefaultData(154);
                if (exportSampleData) break block3;
                return true;
            }
            catch (Exception e) {
                PosLog.error(DatabaseUtil.class, e);
                logger.error((Object)e);
                return false;
            }
        }
        dataInserter.createSampleData();
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
        return true;
    }

    public static void updateLegacyDatabase() {
    }

    public static boolean updateDatabase(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password) {
        return DatabaseUtil.updateDatabase(Application.getInstance().getHibernateConfigurationFileName(), connectionString, hibernateDialect, hibernateConnectionDriverClass, user, password);
    }

    public static boolean updateDatabase(String hibernateCfgFileName, String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password) {
        try {
            Object dataConvertionUtil;
            _RootDAO.releaseConnection();
            StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().configure(hibernateCfgFileName);
            registryBuilder.applySetting("hibernate.dialect", (Object)hibernateDialect);
            registryBuilder.applySetting("hibernate.connection.driver_class", (Object)hibernateConnectionDriverClass);
            registryBuilder.applySetting("hibernate.connection.url", (Object)connectionString);
            registryBuilder.applySetting("hibernate.connection.username", (Object)user);
            registryBuilder.applySetting("hibernate.connection.password", (Object)password);
            registryBuilder.applySetting("hibernate.max_fetch_depth", (Object)"3");
            registryBuilder.applySetting("hibernate.connection.isolation", (Object)String.valueOf(1));
            registryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
            StandardServiceRegistry standardRegistry = registryBuilder.build();
            Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
            SchemaUpdate schemaUpdate = new SchemaUpdate();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
            schemaUpdate.execute(enumSet, metaData);
            SessionFactory sessionFactory = metaData.buildSessionFactory();
            _RootDAO.setSessionFactory(sessionFactory);
            Store store = StoreDAO.getRestaurant();
            Integer databaseVersion = store.getDatabaseVersion();
            if (databaseVersion == null || databaseVersion < 135) {
                dataConvertionUtil = new UpdateDBTo135(sessionFactory);
                ((UpdateDBTo135)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 101) {
                dataConvertionUtil = new UpdateDBTo101(connectionString, user, password, sessionFactory);
                ((UpdateDBTo101)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 104) {
                dataConvertionUtil = new UpdateDBTo104();
                ((UpdateDBTo104)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 122) {
                dataConvertionUtil = new UpdateDBTo122();
                ((UpdateDBTo122)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 129) {
                dataConvertionUtil = new UpdateDBTo129();
                ((UpdateDBTo129)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 151) {
                dataConvertionUtil = new UpdateDBTo151();
                ((UpdateDBTo151)dataConvertionUtil).update();
            }
            store = StoreDAO.getRestaurant();
            store.setDatabaseVersion(154);
            store.setSoftwareVersion(VersionInfo.getVersion());
            store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
            StoreDAO.getInstance().update(store);
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
            return true;
        }
        catch (Exception e) {
            PosLog.error(DatabaseUtil.class, e);
            logger.error((Object)e);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded() {
        try {
            Store store = StoreDAO.getRestaurant();
            if (store == null) {
                throw new PosException("Database is not properly configured. It may be corrupted or damaged.\nPlease configure a valid database.");
            }
            Integer databaseVersion = store.getDatabaseVersion();
            return databaseVersion == null || databaseVersion < 154;
        }
        catch (SQLGrammarException e) {
            Pattern pattern;
            boolean found;
            String message;
            Throwable cause = e.getCause();
            if (cause != null && (message = cause.getMessage()) != null && (found = (pattern = Pattern.compile("Column .* is either not in any table")).matcher(message).find())) {
                return true;
            }
            logger.error((Object)e);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded(Integer databaseVersionInDb) {
        return databaseVersionInDb == null || databaseVersionInDb < 154;
    }

    public static Map<String, String> getStoreProperties(String connectionString, String hibernateConnectionDriverClass, String user, String password) throws Exception {
        Class.forName(hibernateConnectionDriverClass);
        try (Connection connection = null;){
            String errorMessage = "Database is in invalid state. It may be corrupted or damaged or may not compatible with %s.";
            errorMessage = String.format(errorMessage, VersionInfo.getAppName());
            connection = DriverManager.getConnection(connectionString, user, password);
            DatabaseMetaData metaData = connection.getMetaData();
            String actualTableName = DatabaseUtil.getActualTableName(metaData, "store_properties");
            if (actualTableName == null) {
                throw new PosException(errorMessage);
            }
            String propertyNameCol = DatabaseUtil.getActualColumnName(metaData, actualTableName, "property_name");
            String propertyValueCol = DatabaseUtil.getActualColumnName(metaData, actualTableName, "property_value");
            if (propertyNameCol == null || propertyValueCol == null) {
                throw new PosException(errorMessage);
            }
            String sql = String.format("select * from %s", actualTableName);
            HashMap<String, String> storePropertes = new HashMap<String, String>();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String propertyName = resultSet.getString(propertyNameCol);
                String propertyValue = resultSet.getString(propertyValueCol);
                storePropertes.put(propertyName, propertyValue);
            }
            resultSet.close();
            statement.close();
            HashMap<String, String> hashMap = storePropertes;
            return hashMap;
        }
    }

    public static boolean hasTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getTables(null, null, null, new String[]{"TABLE"});
        ArrayList<String> tableNameList = new ArrayList<String>();
        while (resultSet.next()) {
            String tableName2 = resultSet.getString("TABLE_NAME");
            tableNameList.add(tableName2.toLowerCase());
        }
        return tableNameList.contains(tableName.toLowerCase());
    }

    public static String getActualTableName(DatabaseMetaData metaData, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getTables(null, null, null, new String[]{"TABLE"});
        while (resultSet.next()) {
            String tableName2 = resultSet.getString("TABLE_NAME");
            if (!tableName2.equalsIgnoreCase(tableName)) continue;
            return tableName2;
        }
        return null;
    }

    public static String getActualColumnName(DatabaseMetaData metaData, String actutalTableName, String virtualColumnName) throws SQLException {
        ResultSet sourcecolumns = metaData.getColumns(null, null, actutalTableName, null);
        while (sourcecolumns.next()) {
            String columnName = sourcecolumns.getString("COLUMN_NAME");
            if (!columnName.equalsIgnoreCase(virtualColumnName)) continue;
            return columnName;
        }
        return null;
    }
}

