/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Discount;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PackagingUnitDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.util.ShiftUtil;
import com.orocube.common.util.TerminalUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DefaultDataInserter {
    private TaxGroup taxGroupSix33;
    private TaxGroup taxGroupSix01 = new TaxGroup("taxgroup2", "6.01");
    private TaxGroup taxGroupnineteen32 = new TaxGroup("taxgroup3", "19.32");
    private ModifierGroup cheeseModifierGroup;
    private ModifierGroup bevarageModifierGroup;
    private ModifierGroup toppingsModifierGroup;
    private MenuModifier americanCheese;
    private MenuModifier gouda;
    private MenuModifier chadder;
    private MenuModifier brie;
    private MenuModifier lemon;
    private MenuModifier salt;
    private MenuModifier mashroom;
    private MenuModifier pepparoni;
    private MenuModifier sausage;
    private MenuModifier onionsModifier;
    private InventoryUnit unitPiece;
    private InventoryUnit unitKg;
    private MenuItem beefBurger;
    private MenuItem bread;
    private MenuItem meat;
    private InventoryUnit unitGram;

    public void insertDefaultData(int databaseVersion) {
        this.createStore(databaseVersion);
        this.createShifts();
        this.createTerminal();
        this.createDefaultUser();
        this.createDefaultTax();
        this.createDefaultCurrency();
        this.createDefaultFloor();
    }

    public void createSampleData() {
        this.createSampleUsers();
        this.createOrderTypes();
        this.createAttributes();
        this.createPizzaCrust();
        this.createMenuItemData();
        this.createRecipe();
        this.createMenuItemSize();
        this.createSampleCurrencies();
        this.createSampleTaxes();
        this.createMultipliers();
        this.createDiscounts();
    }

    private void createMenuItemSize() {
        MenuItemSize menuItemSize = new MenuItemSize();
        menuItemSize.setName(Messages.getString("DatabaseUtil.21"));
        menuItemSize.setSortOrder(0);
        MenuItemSizeDAO.getInstance().save(menuItemSize);
        menuItemSize = new MenuItemSize();
        menuItemSize.setName(Messages.getString("DatabaseUtil.22"));
        menuItemSize.setSortOrder(1);
        MenuItemSizeDAO.getInstance().save(menuItemSize);
        menuItemSize = new MenuItemSize();
        menuItemSize.setName(Messages.getString("DatabaseUtil.23"));
        menuItemSize.setSortOrder(2);
        MenuItemSizeDAO.getInstance().save(menuItemSize);
    }

    private void createPizzaCrust() {
        PizzaCrust crust = new PizzaCrust();
        crust.setName(Messages.getString("DatabaseUtil.24"));
        crust.setSortOrder(0);
        PizzaCrustDAO.getInstance().save(crust);
        crust = new PizzaCrust();
        crust.setName(Messages.getString("DatabaseUtil.25"));
        crust.setSortOrder(1);
        PizzaCrustDAO.getInstance().save(crust);
    }

    private void createSampleCurrencies() {
        Currency currency = new Currency();
        currency = new Currency();
        currency.setName("EUR");
        currency.setSymbol("E");
        currency.setExchangeRate(0.8);
        CurrencyDAO.getInstance().save(currency);
        currency = new Currency();
        currency.setName("BRL");
        currency.setSymbol("B");
        currency.setExchangeRate(3.47);
        CurrencyDAO.getInstance().save(currency);
        currency = new Currency();
        currency.setName("ARS");
        currency.setSymbol("P");
        currency.setExchangeRate(13.89);
        CurrencyDAO.getInstance().save(currency);
        currency = new Currency();
        currency.setName("PYG");
        currency.setSymbol("P");
        currency.setExchangeRate(5639.78);
        CurrencyDAO.getInstance().save(currency);
    }

    private void createDefaultCurrency() {
        Currency currency = new Currency();
        currency.setName("USD");
        currency.setSymbol("$");
        currency.setExchangeRate(1.0);
        currency.setMain(true);
        CurrencyDAO.getInstance().save(currency);
    }

    private void createDefaultTax() {
        Tax tax = new Tax();
        tax.setName("US");
        tax.setRate(6.33);
        this.taxGroupSix33 = new TaxGroup("taxgroup1", "US 6.33");
        this.taxGroupSix33.addTotaxes(tax);
        TaxGroupDAO.getInstance().save(this.taxGroupSix33);
    }

    private void createDefaultUser() {
        UserType administrator = new UserType();
        administrator.setId(POSConstants.ADMINISTRATOR.toLowerCase());
        administrator.setName(POSConstants.ADMINISTRATOR);
        administrator.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
        UserTypeDAO.getInstance().save(administrator);
        User administratorUser = new User();
        administratorUser.setId("123");
        administratorUser.setEncryptedPassword("1111");
        administratorUser.setFirstName("admin");
        administratorUser.setLastName("s");
        administratorUser.setType(administrator);
        administratorUser.setRoot(true);
        administratorUser.setActive(true);
        UserDAO dao = new UserDAO();
        dao.save(administratorUser);
    }

    private void createStore(int databaseVersion) {
        Store store = new Store();
        store.setId("1");
        store.setUuid(UUID.randomUUID().toString());
        store.setName("Sample Restaurant");
        store.setOutletName("Sample Outlet");
        store.setAddressLine1("Somewhere");
        store.setTelephone("+0123456789");
        store.setProperties(new HashMap<String, String>());
        store.setDatabaseVersion(databaseVersion);
        ReceiptUtil.populateDefaultTicketReceiptProperties(store);
        ReceiptUtil.populateDefaultKitchenReceiptProperties(store);
        StoreDAO.getInstance().saveOrUpdate(store);
    }

    private void createTerminal() {
        int terminalId = TerminalConfig.getTerminalId();
        if (terminalId == -1) {
            Random random = new Random();
            terminalId = random.nextInt(10000) + 1;
        }
        Terminal terminal = new Terminal();
        terminal.setId(terminalId);
        terminal.setDefaultPassLength(4);
        terminal.setTerminalKey(TerminalUtil.getSystemUID());
        terminal.setName(String.valueOf(terminalId));
        TerminalDAO.getInstance().saveOrUpdate(terminal);
    }

    private void createDiscounts() {
        DiscountDAO discountDao = new DiscountDAO();
        Discount discount1 = new Discount();
        discount1.setId("buy1get1");
        discount1.setName(Messages.getString("DatabaseUtil.18", "Buy 1 and get 1 free"));
        discount1.setType(1);
        discount1.setValue(100.0);
        discount1.setAutoApply(false);
        discount1.setMinimumBuy(2.0);
        discount1.setQualificationType(0);
        discount1.setApplyToAll(true);
        discount1.setNeverExpire(true);
        discount1.setEnabled(true);
        discountDao.save(discount1);
        Discount discount2 = new Discount();
        discount2.setId("buy2get1");
        discount2.setName(Messages.getString("DatabaseUtil.19", "Buy 2 and get 1 free"));
        discount2.setType(1);
        discount2.setValue(100.0);
        discount2.setAutoApply(true);
        discount2.setMinimumBuy(3.0);
        discount2.setQualificationType(0);
        discount2.setApplyToAll(true);
        discount2.setNeverExpire(true);
        discount2.setEnabled(true);
        discountDao.save(discount2);
        Discount discount3 = new Discount();
        discount3.setId("10%onItem");
        discount3.setName(Messages.getString("DatabaseUtil.20", "10% Off on Item"));
        discount3.setType(1);
        discount3.setValue(10.0);
        discount3.setAutoApply(false);
        discount3.setMinimumBuy(1.0);
        discount3.setQualificationType(0);
        discount3.setApplyToAll(true);
        discount3.setNeverExpire(true);
        discount3.setEnabled(true);
        discountDao.save(discount3);
        Discount discount4 = new Discount();
        discount4.setId("10%onTicket");
        discount4.setName("10% on Ticket");
        discount4.setType(1);
        discount4.setValue(10.0);
        discount4.setAutoApply(false);
        discount4.setMinimumBuy(1.0);
        discount4.setQualificationType(1);
        discount4.setApplyToAll(true);
        discount4.setNeverExpire(true);
        discount4.setEnabled(true);
        discountDao.save(discount4);
    }

    private void createOrderTypes() {
        OrderTypeDAO orderTypeDAO = new OrderTypeDAO();
        OrderType orderType = new OrderType("dine-in");
        orderType.setName(Messages.getString("DatabaseUtil.14"));
        orderType.setShowTableSelection(true);
        orderType.setCloseOnPaid(true);
        orderType.setEnabled(true);
        orderType.setShouldPrintToKitchen(true);
        orderType.setShowInLoginScreen(true);
        orderType.setSortOrder(1);
        orderTypeDAO.save(orderType);
        orderType = new OrderType("take-out");
        orderType.setName(Messages.getString("DatabaseUtil.15"));
        orderType.setShowTableSelection(false);
        orderType.setCloseOnPaid(true);
        orderType.setEnabled(true);
        orderType.setPrepaid(true);
        orderType.setShouldPrintToKitchen(true);
        orderType.setShowInLoginScreen(true);
        orderType.setSortOrder(2);
        orderTypeDAO.save(orderType);
        orderType = new OrderType("retail");
        orderType.setName(Messages.getString("DatabaseUtil.16"));
        orderType.setShowTableSelection(false);
        orderType.setCloseOnPaid(true);
        orderType.setEnabled(true);
        orderType.setRetailOrder(true);
        orderType.setShouldPrintToKitchen(false);
        orderType.setShowInLoginScreen(true);
        orderType.setSortOrder(3);
        orderTypeDAO.save(orderType);
        orderType = new OrderType("home-delivery");
        orderType.setName(Messages.getString("DatabaseUtil.17"));
        orderType.setShowTableSelection(false);
        orderType.setCloseOnPaid(false);
        orderType.setEnabled(true);
        orderType.setShouldPrintToKitchen(true);
        orderType.setShowInLoginScreen(true);
        orderType.setRequiredCustomerData(true);
        orderType.setDelivery(true);
        orderType.setSortOrder(4);
        orderTypeDAO.save(orderType);
    }

    private void createSampleUsers() {
        UserType manager = new UserType();
        manager.setId(POSConstants.MANAGER.toLowerCase());
        manager.setName(POSConstants.MANAGER);
        manager.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
        UserTypeDAO.getInstance().save(manager);
        UserType cashier = new UserType();
        cashier.setId(POSConstants.CASHIER.toLowerCase());
        cashier.setName(POSConstants.CASHIER);
        cashier.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET, UserPermission.SPLIT_TICKET, UserPermission.EDIT_OTHER_USERS_TICKETS)));
        UserTypeDAO.getInstance().save(cashier);
        UserType server = new UserType();
        server.setId("server");
        server.setName("SERVER");
        server.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET, UserPermission.SPLIT_TICKET)));
        UserTypeDAO.getInstance().save(server);
        UserDAO dao = new UserDAO();
        this.createManagerUser(manager, cashier, server);
        User cashierUser = new User();
        cashierUser.setId("125");
        cashierUser.setEncryptedPassword("3333");
        cashierUser.setFirstName("Cashier");
        cashierUser.setLastName("C");
        cashierUser.setType(cashier);
        cashierUser.setRoot(true);
        cashierUser.setActive(true);
        dao.save(cashierUser);
        User serverUser = new User();
        serverUser.setId("126");
        serverUser.setEncryptedPassword("4444");
        serverUser.setFirstName("John");
        serverUser.setLastName("Doe");
        serverUser.setType(server);
        serverUser.setRoot(true);
        serverUser.setActive(true);
        serverUser.setStaffBank(true);
        serverUser.setAutoStartStaffBank(true);
        dao.save(serverUser);
        serverUser = new User();
        serverUser.setId("127");
        serverUser.setEncryptedPassword("6666");
        serverUser.setFirstName("Juthi");
        serverUser.setLastName("M");
        serverUser.setType(server);
        serverUser.setRoot(true);
        serverUser.setActive(true);
        dao.save(serverUser);
    }

    private void createSampleTaxes() {
        Tax five89 = new Tax("five89", "five 89", 5.89);
        TaxDAO.getInstance().save(five89);
        Tax zero12 = new Tax("zero12", "zero 12", 0.12);
        TaxDAO.getInstance().save(zero12);
        Tax fifteen45 = new Tax("fifteen45", "fifteen 45", 15.45);
        TaxDAO.getInstance().save(fifteen45);
        Tax three87 = new Tax("three87", "three87", 3.87);
        TaxDAO.getInstance().save(three87);
        this.taxGroupSix01.addTotaxes(five89);
        this.taxGroupSix01.addTotaxes(zero12);
        TaxGroupDAO.getInstance().save(this.taxGroupSix01);
        this.taxGroupnineteen32.addTotaxes(fifteen45);
        this.taxGroupnineteen32.addTotaxes(three87);
        TaxGroupDAO.getInstance().save(this.taxGroupnineteen32);
    }

    private void createMenuItemData() {
        this.createInventoryData();
        MenuCategory fastfood = new MenuCategory();
        fastfood.setName("FASTFOOD");
        fastfood.setVisible(true);
        fastfood.setSortOrder(1);
        MenuCategoryDAO.getInstance().save(fastfood);
        MenuCategory drinks = new MenuCategory();
        drinks.setName("DRINKS");
        drinks.setVisible(true);
        drinks.setSortOrder(2);
        MenuCategoryDAO.getInstance().save(drinks);
        MenuGroup burgerGroup = new MenuGroup();
        burgerGroup.setName("BURGER");
        burgerGroup.setVisible(true);
        burgerGroup.setMenuCategoryId(fastfood.getId());
        burgerGroup.setSortOrder(1);
        MenuGroupDAO.getInstance().save(burgerGroup);
        MenuGroup beverageGroup = new MenuGroup();
        beverageGroup.setName("BEVERAGE");
        beverageGroup.setVisible(true);
        beverageGroup.setMenuCategoryId(drinks.getId());
        beverageGroup.setSortOrder(2);
        MenuGroupDAO.getInstance().save(beverageGroup);
        MenuGroup sandwichGroup = new MenuGroup();
        sandwichGroup.setName("SANDWICH");
        sandwichGroup.setVisible(true);
        sandwichGroup.setMenuCategoryId(fastfood.getId());
        sandwichGroup.setSortOrder(3);
        MenuGroupDAO.getInstance().save(sandwichGroup);
        this.createMenuModifiers();
        Session session = MenuItemDAO.getInstance().createNewSession();
        Transaction transaction = session.beginTransaction();
        MenuItem americanBurger = new MenuItem("americanBurger", "American Burger", 77.99);
        americanBurger.setUnit(this.unitPiece);
        americanBurger.setCost(5.5);
        americanBurger.setVisible(true);
        americanBurger.setReorderLevel(5.0);
        americanBurger.setReplenishLevel(10.0);
        americanBurger.setMenuGroup(burgerGroup);
        americanBurger.setTaxGroup(this.taxGroupnineteen32);
        MenuItemDAO.getInstance().save(americanBurger, session);
        this.beefBurger = new MenuItem("beefBurger", "Beef Burger", 99.33);
        this.beefBurger.setUnit(this.unitPiece);
        this.beefBurger.setCost(1.5);
        this.beefBurger.setVisible(true);
        this.beefBurger.setReorderLevel(5.0);
        this.beefBurger.setReplenishLevel(10.0);
        this.beefBurger.setMenuGroup(burgerGroup);
        this.beefBurger.setTaxGroup(this.taxGroupSix33);
        MenuItemDAO.getInstance().save(this.beefBurger, session);
        MenuItem customBurger = new MenuItem("customBurger", "Custom Burger", 45.66);
        customBurger.setUnit(this.unitPiece);
        customBurger.setCost(5.5);
        customBurger.setReorderLevel(5.0);
        customBurger.setReplenishLevel(10.0);
        customBurger.setMenuGroup(burgerGroup);
        customBurger.setTaxGroup(this.taxGroupSix33);
        customBurger.setHasModifiers(true);
        customBurger.setHasMandatoryModifiers(true);
        this.createCheeseMenuModifierSpec(customBurger);
        MenuItemDAO.getInstance().save(customBurger, session);
        MenuItem numbBurger = new MenuItem("numbBurger", "Numb Burger", 23.32);
        numbBurger.setUnit(this.unitPiece);
        numbBurger.setCost(5.5);
        numbBurger.setReorderLevel(5.0);
        numbBurger.setReplenishLevel(10.0);
        numbBurger.setMenuGroup(burgerGroup);
        numbBurger.setTaxGroup(this.taxGroupSix01);
        numbBurger.setHasModifiers(true);
        numbBurger.setHasMandatoryModifiers(true);
        this.createCheeseMenuModifierSpec(numbBurger);
        MenuItemDAO.getInstance().save(numbBurger, session);
        MenuItem cheeseBurger = new MenuItem("cheeseBurger", "Cheese Burger", 75.89);
        cheeseBurger.setUnit(this.unitPiece);
        cheeseBurger.setCost(5.5);
        cheeseBurger.setReorderLevel(5.0);
        cheeseBurger.setReplenishLevel(10.0);
        cheeseBurger.setMenuGroup(burgerGroup);
        cheeseBurger.setHasModifiers(true);
        cheeseBurger.setHasMandatoryModifiers(true);
        cheeseBurger.setTaxGroup(this.taxGroupnineteen32);
        this.createToppingsMenuModifierSpec(cheeseBurger);
        MenuItemDAO.getInstance().save(cheeseBurger, session);
        MenuItem chickenBurger = new MenuItem("chickenBurger", "Chicken Burger", 89.99);
        chickenBurger.setUnit(this.unitPiece);
        chickenBurger.setCost(5.5);
        chickenBurger.setReorderLevel(5.0);
        chickenBurger.setReplenishLevel(10.0);
        chickenBurger.setMenuGroup(burgerGroup);
        chickenBurger.setTaxGroup(this.taxGroupSix33);
        MenuItemDAO.getInstance().save(chickenBurger, session);
        MenuItem nullBurger = new MenuItem("nullBurger", "Null Burger", 66.99);
        nullBurger.setUnit(this.unitPiece);
        nullBurger.setCost(5.5);
        nullBurger.setReorderLevel(5.0);
        nullBurger.setReplenishLevel(10.0);
        nullBurger.setMenuGroup(burgerGroup);
        MenuItemDAO.getInstance().save(nullBurger, session);
        MenuItem hamBurger = new MenuItem("hamBurger", "Ham Burger", 85.35);
        hamBurger.setUnit(this.unitPiece);
        hamBurger.setCost(5.5);
        hamBurger.setReorderLevel(5.0);
        hamBurger.setReplenishLevel(10.0);
        hamBurger.setMenuGroup(burgerGroup);
        hamBurger.setHasModifiers(true);
        hamBurger.setHasMandatoryModifiers(true);
        this.createToppingsMenuModifierSpec(hamBurger);
        MenuItemDAO.getInstance().save(hamBurger, session);
        this.bread = new MenuItem("bread", "Bread", 10.0);
        this.bread.setUnit(this.unitPiece);
        this.bread.setCost(3.0);
        this.bread.setReorderLevel(5.0);
        this.bread.setReplenishLevel(10.0);
        this.bread.setMenuGroup(burgerGroup);
        MenuItemDAO.getInstance().save(this.bread, session);
        this.meat = new MenuItem("meat", "Meat", 400.0);
        this.meat.setUnit(this.unitKg);
        this.meat.setCost(250.0);
        this.meat.setReorderLevel(5.0);
        this.meat.setReplenishLevel(10.0);
        this.meat.setMenuGroup(burgerGroup);
        MenuItemDAO.getInstance().save(this.meat, session);
        MenuItem coke = new MenuItem("coke", "COKE", 14.99);
        coke.setReorderLevel(5.0);
        coke.setReplenishLevel(10.0);
        coke.setUnit(this.unitPiece);
        coke.setCost(1.5);
        coke.setMenuGroup(beverageGroup);
        coke.setTaxGroup(this.taxGroupSix01);
        coke.setHasVariant(true);
        MenuItemDAO.getInstance().save(coke, session);
        this.doCreateVariantForCoke(coke, session);
        MenuItem pepsi = new MenuItem("pepsi", "PEPSI", 7.77);
        pepsi.setReorderLevel(5.0);
        pepsi.setReplenishLevel(10.0);
        pepsi.setUnit(this.unitPiece);
        pepsi.setCost(1.5);
        pepsi.setMenuGroup(beverageGroup);
        pepsi.setTaxGroup(this.taxGroupnineteen32);
        pepsi.setHasModifiers(true);
        pepsi.setHasMandatoryModifiers(true);
        pepsi.setHasVariant(true);
        this.createBeverageMenuModifierSpec(pepsi);
        MenuItemDAO.getInstance().save(pepsi, session);
        this.doCreateVariantForPepsi(pepsi, session);
        MenuItem fanta = new MenuItem("fanta", "FANTA", 8.91);
        fanta.setMenuGroup(beverageGroup);
        fanta.setReorderLevel(5.0);
        fanta.setReplenishLevel(10.0);
        fanta.setTaxGroup(this.taxGroupSix01);
        fanta.setUnit(this.unitPiece);
        fanta.setCost(1.5);
        MenuItemDAO.getInstance().save(fanta, session);
        MenuItem sprite = new MenuItem("sprite", "SPRITE", 11.13);
        sprite.setMenuGroup(beverageGroup);
        sprite.setReorderLevel(5.0);
        sprite.setReplenishLevel(10.0);
        sprite.setTaxGroup(this.taxGroupSix33);
        sprite.setUnit(this.unitPiece);
        sprite.setCost(1.5);
        MenuItemDAO.getInstance().save(sprite, session);
        MenuItem chickenSandwich = new MenuItem("chickenSandwich", "CHICKEN SANDWICH", 51.32);
        chickenSandwich.setTaxGroup(this.taxGroupnineteen32);
        chickenSandwich.setMenuGroup(sandwichGroup);
        chickenSandwich.setReorderLevel(5.0);
        chickenSandwich.setReplenishLevel(10.0);
        chickenSandwich.setVisible(true);
        chickenSandwich.setUnit(this.unitPiece);
        chickenSandwich.setCost(1.5);
        MenuItemDAO.getInstance().save(chickenSandwich, session);
        MenuItem beefSandwich = new MenuItem("beeefSandwich", "BEEF SANDWICH", 113.45);
        beefSandwich.setTaxGroup(this.taxGroupSix01);
        beefSandwich.setMenuGroup(sandwichGroup);
        beefSandwich.setReorderLevel(5.0);
        beefSandwich.setVisible(true);
        beefSandwich.setReplenishLevel(10.0);
        beefSandwich.setUnit(this.unitPiece);
        beefSandwich.setCost(1.5);
        MenuItemDAO.getInstance().save(beefSandwich, session);
        MenuItem hamSandwich = new MenuItem("hamSandwich", "HAM SANDWICH", 53.37);
        hamSandwich.setMenuGroup(sandwichGroup);
        hamSandwich.setReorderLevel(5.0);
        hamSandwich.setVisible(true);
        hamSandwich.setReplenishLevel(10.0);
        hamSandwich.setTaxGroup(this.taxGroupSix33);
        hamSandwich.setUnit(this.unitPiece);
        hamSandwich.setCost(1.5);
        MenuItemDAO.getInstance().save(hamSandwich, session);
        transaction.commit();
        session.close();
        MenuPage burgerPage = new MenuPage();
        burgerPage.setName("burgers");
        burgerPage.setCols(4);
        burgerPage.setRows(4);
        burgerPage.setButtonHeight(100);
        burgerPage.setButtonWidth(120);
        burgerPage.setVisible(true);
        burgerPage.setMenuGroupId(burgerGroup.getId());
        MenuPageDAO.getInstance().save(burgerPage);
        MenuPageItem menuPageItem = new MenuPageItem(0, 0, americanBurger, burgerPage);
        menuPageItem.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem);
        MenuPageItem menuPageItem2 = new MenuPageItem(1, 0, this.beefBurger, burgerPage);
        menuPageItem2.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem2);
        MenuPageItem menuPageItem3 = new MenuPageItem(2, 0, chickenBurger, burgerPage);
        menuPageItem3.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem3);
        MenuPageItem menuPageItem4 = new MenuPageItem(3, 0, cheeseBurger, burgerPage);
        menuPageItem4.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem4);
        MenuPageItem menuPageItem5 = new MenuPageItem(0, 1, customBurger, burgerPage);
        menuPageItem5.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem5);
        MenuPageItem menuPageItem6 = new MenuPageItem(1, 1, hamBurger, burgerPage);
        menuPageItem6.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem6);
        MenuPageItem menuPageItem7 = new MenuPageItem(2, 1, nullBurger, burgerPage);
        menuPageItem7.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem7);
        MenuPageItem menuPageItem8 = new MenuPageItem(3, 1, numbBurger, burgerPage);
        menuPageItem8.setMenuPageId(burgerPage.getId());
        MenuPageItemDAO.getInstance().save(menuPageItem8);
        MenuPageDAO.getInstance().saveOrUpdate(burgerPage);
        MenuPage sandwichPage = new MenuPage();
        sandwichPage.setName("page 1");
        sandwichPage.setCols(4);
        sandwichPage.setRows(4);
        sandwichPage.setButtonHeight(100);
        sandwichPage.setButtonWidth(120);
        sandwichPage.setVisible(true);
        sandwichPage.setMenuGroupId(sandwichGroup.getId());
        MenuPageDAO.getInstance().save(sandwichPage);
        MenuPageItem sandwichItem1 = new MenuPageItem(0, 0, beefSandwich, sandwichPage);
        sandwichItem1.setMenuPage(sandwichPage);
        MenuPageItemDAO.getInstance().save(sandwichItem1);
        MenuPageItem sandwichItem2 = new MenuPageItem(1, 0, chickenSandwich, sandwichPage);
        sandwichItem2.setMenuPage(sandwichPage);
        MenuPageItemDAO.getInstance().save(sandwichItem2);
        MenuPageItem sandwichItem3 = new MenuPageItem(2, 0, hamSandwich, sandwichPage);
        sandwichItem3.setMenuPage(sandwichPage);
        MenuPageItemDAO.getInstance().save(sandwichItem3);
        MenuPageDAO.getInstance().saveOrUpdate(sandwichPage);
        MenuPage drinksPage = new MenuPage();
        drinksPage.setName("page 1");
        drinksPage.setCols(4);
        drinksPage.setRows(4);
        drinksPage.setButtonHeight(100);
        drinksPage.setButtonWidth(120);
        drinksPage.setVisible(true);
        drinksPage.setMenuGroupId(beverageGroup.getId());
        MenuPageDAO.getInstance().save(drinksPage);
        MenuPageItem cokeItem = new MenuPageItem(1, 0, coke, drinksPage);
        cokeItem.setMenuPageId(drinksPage.getId());
        MenuPageItemDAO.getInstance().save(cokeItem);
        MenuPageItem fantaItem = new MenuPageItem(2, 0, fanta, drinksPage);
        fantaItem.setMenuPageId(drinksPage.getId());
        MenuPageItemDAO.getInstance().save(fantaItem);
        MenuPageItem spriteItem = new MenuPageItem(3, 0, sprite, drinksPage);
        spriteItem.setMenuPageId(drinksPage.getId());
        MenuPageItemDAO.getInstance().save(spriteItem);
        MenuPageItem pepsiItem = new MenuPageItem(0, 1, pepsi, drinksPage);
        pepsiItem.setMenuPageId(drinksPage.getId());
        MenuPageItemDAO.getInstance().save(pepsiItem);
        MenuPageDAO.getInstance().saveOrUpdate(drinksPage);
    }

    private void createRecipe() {
        Recepie recipe = new Recepie();
        recipe.setName("Beef Burger Recipe");
        recipe.setPortion(1.0);
        recipe.setYield(1.0);
        recipe.setCookingTime(60);
        recipe.setMenuItem(this.beefBurger);
        recipe.setYieldUnit(this.unitPiece.getCode());
        recipe.setPortionUnit(this.unitPiece.getUniqueCode());
        RecepieItem breadItem = new RecepieItem();
        breadItem.setInventoryItem(this.bread);
        breadItem.setQuantity(1.0);
        breadItem.setPercentage(100.0);
        breadItem.setUnit(this.unitPiece);
        breadItem.setUnitCode(this.unitPiece.getCode());
        recipe.addTorecepieItems(breadItem);
        RecepieItem meatItem = new RecepieItem();
        meatItem.setInventoryItem(this.meat);
        meatItem.setPercentage(10.0);
        meatItem.setQuantity(100.0);
        meatItem.setUnit(this.unitGram);
        meatItem.setUnitCode(this.unitGram.getCode());
        recipe.addTorecepieItems(meatItem);
        RecepieDAO.getInstance().save(recipe);
        this.beefBurger.setDefaultRecipeId(recipe.getId());
        MenuItemDAO.getInstance().update(this.beefBurger);
    }

    private void createMenuModifiers() {
        this.americanCheese = new MenuModifier("americanCheese");
        this.americanCheese.setName("American");
        this.americanCheese.setPrice(2.99);
        this.americanCheese.setTaxGroup(this.taxGroupnineteen32);
        MenuModifierDAO.getInstance().save(this.americanCheese);
        this.gouda = new MenuModifier("gouda");
        this.gouda.setName("Gouda");
        this.gouda.setPrice(1.0);
        this.gouda.setTaxGroup(this.taxGroupSix33);
        MenuModifierDAO.getInstance().save(this.gouda);
        this.chadder = new MenuModifier("chadder");
        this.chadder.setName("Chadder");
        this.chadder.setPrice(1.25);
        this.chadder.setTaxGroup(this.taxGroupSix33);
        MenuModifierDAO.getInstance().save(this.chadder);
        this.brie = new MenuModifier("brie");
        this.brie.setName("Brie");
        this.brie.setPrice(2.0);
        this.brie.setTaxGroup(this.taxGroupSix33);
        MenuModifierDAO.getInstance().save(this.brie);
        this.cheeseModifierGroup = new ModifierGroup();
        this.cheeseModifierGroup.setName("Cheese");
        this.cheeseModifierGroup.addTomodifiers(this.americanCheese);
        this.cheeseModifierGroup.addTomodifiers(this.gouda);
        this.cheeseModifierGroup.addTomodifiers(this.chadder);
        this.cheeseModifierGroup.addTomodifiers(this.brie);
        ModifierGroupDAO.getInstance().save(this.cheeseModifierGroup);
        this.lemon = new MenuModifier("lemon");
        this.lemon.setName("Lemon");
        this.lemon.setPrice(0.79);
        this.lemon.setTaxGroup(this.taxGroupSix01);
        MenuModifierDAO.getInstance().save(this.lemon);
        this.salt = new MenuModifier("salt");
        this.salt.setName("Salt");
        this.salt.setPrice(0.27);
        MenuModifierDAO.getInstance().save(this.salt);
        this.bevarageModifierGroup = new ModifierGroup();
        this.bevarageModifierGroup.setName("Beverages");
        this.bevarageModifierGroup.addTomodifiers(this.lemon);
        this.bevarageModifierGroup.addTomodifiers(this.salt);
        ModifierGroupDAO.getInstance().save(this.bevarageModifierGroup);
        this.mashroom = new MenuModifier("mashroom");
        this.mashroom.setName("Mashroom");
        this.mashroom.setPrice(1.0);
        MenuModifierDAO.getInstance().save(this.mashroom);
        this.pepparoni = new MenuModifier("pepparoni");
        this.pepparoni.setName("Pepparoni");
        this.pepparoni.setPrice(3.33);
        this.pepparoni.setTaxGroup(this.taxGroupSix01);
        MenuModifierDAO.getInstance().save(this.pepparoni);
        this.sausage = new MenuModifier("sausage");
        this.sausage.setName("Sausage");
        this.sausage.setPrice(1.25);
        MenuModifierDAO.getInstance().save(this.sausage);
        this.onionsModifier = new MenuModifier("onion");
        this.onionsModifier.setName("Onions");
        this.onionsModifier.setExtraPrice(2.75);
        this.onionsModifier.setShouldPrintToKitchen(true);
        this.onionsModifier.setPrice(2.0);
        MenuModifierDAO.getInstance().save(this.onionsModifier);
        this.toppingsModifierGroup = new ModifierGroup();
        this.toppingsModifierGroup.setName("Toppings");
        this.toppingsModifierGroup.addTomodifiers(this.mashroom);
        this.toppingsModifierGroup.addTomodifiers(this.pepparoni);
        this.toppingsModifierGroup.addTomodifiers(this.sausage);
        this.toppingsModifierGroup.addTomodifiers(this.onionsModifier);
        ModifierGroupDAO.getInstance().save(this.toppingsModifierGroup);
    }

    private void createCheeseMenuModifierSpec(MenuItem menuItem) {
        MenuItemModifierSpec cheeseModifierGroupSpec = new MenuItemModifierSpec();
        cheeseModifierGroupSpec.setModifierGroup(this.cheeseModifierGroup);
        cheeseModifierGroupSpec.setName("Cheese");
        cheeseModifierGroupSpec.setMinQuantity(1);
        cheeseModifierGroupSpec.setMaxQuantity(2);
        cheeseModifierGroupSpec.setSortOrder(0);
        cheeseModifierGroupSpec.setEnable(true);
        cheeseModifierGroupSpec.setJumpGroup(true);
        MenuItemModifierSpecDAO.getInstance().save(cheeseModifierGroupSpec);
        MenuItemModifierPage cheeseModifierSpecPage = new MenuItemModifierPage();
        cheeseModifierSpecPage.setName("Page 1");
        cheeseModifierSpecPage.setButtonHeight(100);
        cheeseModifierSpecPage.setButtonWidth(100);
        cheeseModifierSpecPage.setRows(4);
        cheeseModifierSpecPage.setCols(4);
        cheeseModifierSpecPage.setVisible(true);
        cheeseModifierSpecPage.setSortOrder(1);
        cheeseModifierSpecPage.setFlixibleButtonSize(false);
        cheeseModifierSpecPage.setModifierSpecId(cheeseModifierGroupSpec.getId());
        MenuItemModifierPageDAO.getInstance().save(cheeseModifierSpecPage);
        MenuItemModifierPageItem cheesePageItem = new MenuItemModifierPageItem(0, 0, this.americanCheese, cheeseModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(cheesePageItem);
        cheeseModifierSpecPage.addTopageItems(cheesePageItem);
        MenuItemModifierPageItem goudaPageItem = new MenuItemModifierPageItem(1, 0, this.gouda, cheeseModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(goudaPageItem);
        cheeseModifierSpecPage.addTopageItems(goudaPageItem);
        MenuItemModifierPageItem briePageItem = new MenuItemModifierPageItem(2, 0, this.brie, cheeseModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(briePageItem);
        cheeseModifierSpecPage.addTopageItems(briePageItem);
        MenuItemModifierPageItem cheddarPageItem = new MenuItemModifierPageItem(3, 0, this.chadder, cheeseModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(cheddarPageItem);
        cheeseModifierSpecPage.addTopageItems(cheddarPageItem);
        cheeseModifierGroupSpec.addTomodifierPages(cheeseModifierSpecPage);
        menuItem.addTomenuItemModiferSpecs(cheeseModifierGroupSpec);
    }

    private void createBeverageMenuModifierSpec(MenuItem menuItem) {
        MenuItemModifierSpec beverageModifierGroupSpec = new MenuItemModifierSpec();
        beverageModifierGroupSpec.setModifierGroup(this.toppingsModifierGroup);
        beverageModifierGroupSpec.setName("Beverage");
        beverageModifierGroupSpec.setMinQuantity(1);
        beverageModifierGroupSpec.setMaxQuantity(2);
        beverageModifierGroupSpec.setSortOrder(0);
        beverageModifierGroupSpec.setEnable(true);
        beverageModifierGroupSpec.setJumpGroup(true);
        MenuItemModifierSpecDAO.getInstance().save(beverageModifierGroupSpec);
        MenuItemModifierPage beverageModifierSpecPage = new MenuItemModifierPage();
        beverageModifierSpecPage.setName("Page 1");
        beverageModifierSpecPage.setButtonHeight(100);
        beverageModifierSpecPage.setButtonWidth(100);
        beverageModifierSpecPage.setRows(4);
        beverageModifierSpecPage.setCols(4);
        beverageModifierSpecPage.setVisible(true);
        beverageModifierSpecPage.setSortOrder(1);
        beverageModifierSpecPage.setFlixibleButtonSize(false);
        beverageModifierSpecPage.setModifierSpecId(beverageModifierGroupSpec.getId());
        MenuItemModifierPageDAO.getInstance().saveOrUpdate(beverageModifierSpecPage);
        MenuItemModifierPageItem saltPageItem = new MenuItemModifierPageItem(0, 0, this.salt, beverageModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(saltPageItem);
        beverageModifierSpecPage.addTopageItems(saltPageItem);
        MenuItemModifierPageItem lemonPageItem = new MenuItemModifierPageItem(1, 0, this.lemon, beverageModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(lemonPageItem);
        beverageModifierSpecPage.addTopageItems(lemonPageItem);
        beverageModifierGroupSpec.addTomodifierPages(beverageModifierSpecPage);
        menuItem.addTomenuItemModiferSpecs(beverageModifierGroupSpec);
    }

    private void createToppingsMenuModifierSpec(MenuItem menuItem) {
        MenuItemModifierSpec toppingsModifierGroupSpec = new MenuItemModifierSpec();
        toppingsModifierGroupSpec.setModifierGroup(this.toppingsModifierGroup);
        toppingsModifierGroupSpec.setName("toppings");
        toppingsModifierGroupSpec.setMinQuantity(1);
        toppingsModifierGroupSpec.setMaxQuantity(2);
        toppingsModifierGroupSpec.setSortOrder(0);
        toppingsModifierGroupSpec.setEnable(true);
        toppingsModifierGroupSpec.setJumpGroup(true);
        MenuItemModifierSpecDAO.getInstance().save(toppingsModifierGroupSpec);
        MenuItemModifierPage toppingsModifierSpecPage = new MenuItemModifierPage();
        toppingsModifierSpecPage.setName("Page 1");
        toppingsModifierSpecPage.setButtonHeight(100);
        toppingsModifierSpecPage.setButtonWidth(100);
        toppingsModifierSpecPage.setRows(4);
        toppingsModifierSpecPage.setCols(4);
        toppingsModifierSpecPage.setVisible(true);
        toppingsModifierSpecPage.setSortOrder(1);
        toppingsModifierSpecPage.setFlixibleButtonSize(false);
        toppingsModifierSpecPage.setModifierSpecId(toppingsModifierGroupSpec.getId());
        MenuItemModifierPageDAO.getInstance().saveOrUpdate(toppingsModifierSpecPage);
        MenuItemModifierPageItem mashroomPageItem = new MenuItemModifierPageItem(0, 0, this.mashroom, toppingsModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(mashroomPageItem);
        toppingsModifierSpecPage.addTopageItems(mashroomPageItem);
        MenuItemModifierPageItem pepproniPageItem = new MenuItemModifierPageItem(1, 0, this.pepparoni, toppingsModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(pepproniPageItem);
        toppingsModifierSpecPage.addTopageItems(pepproniPageItem);
        MenuItemModifierPageItem sausagePageItem = new MenuItemModifierPageItem(2, 0, this.sausage, toppingsModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(sausagePageItem);
        toppingsModifierSpecPage.addTopageItems(sausagePageItem);
        MenuItemModifierPageItem onionPageItem = new MenuItemModifierPageItem(3, 0, this.onionsModifier, toppingsModifierSpecPage);
        MenuItemModifierPageItemDAO.getInstance().saveOrUpdate(onionPageItem);
        toppingsModifierSpecPage.addTopageItems(onionPageItem);
        toppingsModifierGroupSpec.addTomodifierPages(toppingsModifierSpecPage);
        menuItem.addTomenuItemModiferSpecs(toppingsModifierGroupSpec);
    }

    private void createMultipliers() {
        Multiplier regular = new Multiplier("regular");
        regular.setRate(100.0);
        regular.setTicketPrefix("Regular");
        regular.setDefaultMultiplier(true);
        MultiplierDAO.getInstance().save(regular);
        Multiplier tripple = new Multiplier("tripple");
        tripple.setRate(300.0);
        tripple.setTicketPrefix("Tripple");
        MultiplierDAO.getInstance().save(tripple);
        Multiplier quarter = new Multiplier("quarter");
        quarter.setRate(25.0);
        quarter.setTicketPrefix("Quarter");
        MultiplierDAO.getInstance().save(quarter);
        Multiplier half = new Multiplier("half");
        half.setRate(50.0);
        half.setTicketPrefix("Half");
        MultiplierDAO.getInstance().save(half);
        Multiplier extra = new Multiplier("extra");
        extra.setRate(200.0);
        extra.setTicketPrefix("extra");
        MultiplierDAO.getInstance().save(extra);
    }

    private void createShifts() {
        DayPart regularShift = new DayPart();
        regularShift.setId("regular");
        regularShift.setName("Regular");
        Date shiftStartTime = ShiftUtil.buildShiftStartTime(10, 0, 0, 6, 0, 1);
        Date shiftEndTime = ShiftUtil.buildShiftEndTime(10, 0, 0, 6, 0, 1);
        regularShift.setStartTime(shiftStartTime);
        regularShift.setEndTime(shiftEndTime);
        long length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
        regularShift.setShiftLength(length);
        DayPartDAO.getInstance().save(regularShift);
        DayPart eveningShift = new DayPart();
        eveningShift.setId("evening");
        eveningShift.setName("Evening");
        shiftStartTime = ShiftUtil.buildShiftStartTime(6, 0, 1, 2, 0, 0);
        shiftEndTime = ShiftUtil.buildShiftEndTime(6, 0, 1, 2, 0, 0);
        eveningShift.setStartTime(shiftStartTime);
        eveningShift.setEndTime(shiftEndTime);
        length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
        eveningShift.setShiftLength(length);
        DayPartDAO.getInstance().save(eveningShift);
        DayPart nightShift = new DayPart();
        nightShift.setId("night");
        nightShift.setName("Night");
        shiftStartTime = ShiftUtil.buildShiftStartTime(2, 0, 0, 10, 0, 0);
        shiftEndTime = ShiftUtil.buildShiftEndTime(2, 0, 0, 10, 0, 0);
        nightShift.setStartTime(shiftStartTime);
        nightShift.setEndTime(shiftEndTime);
        length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
        nightShift.setShiftLength(length);
        DayPartDAO.getInstance().save(nightShift);
    }

    private void createAttributes() {
        AttributeGroup sizeGroup = new AttributeGroup();
        sizeGroup.setName("Size");
        DatabaseUtil.smallSize = new Attribute();
        DatabaseUtil.smallSize.setName(Messages.getString("DatabaseUtil.21"));
        DatabaseUtil.smallSize.setSortOrder(0);
        DatabaseUtil.smallSize.setGroup(sizeGroup);
        sizeGroup.addToattributes(DatabaseUtil.smallSize);
        DatabaseUtil.mediumSize = new Attribute();
        DatabaseUtil.mediumSize.setName(Messages.getString("DatabaseUtil.22"));
        DatabaseUtil.mediumSize.setSortOrder(1);
        DatabaseUtil.mediumSize.setGroup(sizeGroup);
        sizeGroup.addToattributes(DatabaseUtil.mediumSize);
        DatabaseUtil.largeSize = new Attribute();
        DatabaseUtil.largeSize.setName(Messages.getString("DatabaseUtil.23"));
        DatabaseUtil.largeSize.setSortOrder(2);
        DatabaseUtil.largeSize.setGroup(sizeGroup);
        sizeGroup.addToattributes(DatabaseUtil.largeSize);
        AttributeGroup crustGroup = new AttributeGroup();
        crustGroup.setName("Crust");
        Attribute pan = new Attribute();
        pan.setName(Messages.getString("DatabaseUtil.24"));
        pan.setSortOrder(0);
        pan.setGroup(crustGroup);
        crustGroup.addToattributes(pan);
        Attribute handTossed = new Attribute();
        handTossed.setName(Messages.getString("DatabaseUtil.25"));
        handTossed.setSortOrder(1);
        handTossed.setGroup(crustGroup);
        crustGroup.addToattributes(handTossed);
        AttributeGroupDAO.getInstance().saveOrUpdate(sizeGroup);
        AttributeGroupDAO.getInstance().saveOrUpdate(crustGroup);
    }

    private void doCreateVariantForCoke(MenuItem item, Session session) {
        MenuItem largeItem = new MenuItem();
        largeItem.setId("large-" + item.getId());
        largeItem.setName("Large-" + item.getName());
        largeItem.setParentMenuItemId(item.getId());
        largeItem.setMenuGroupId(item.getMenuGroupId());
        largeItem.setMenuCategoryId(item.getMenuCategoryId());
        largeItem.setUnit(item.getUnit());
        largeItem.setVariant(true);
        largeItem.setPrice(4.89);
        largeItem.setInventoryItem(item.isInventoryItem());
        largeItem.setAttributes(Arrays.asList(DatabaseUtil.largeSize));
        MenuItemDAO.getInstance().save(largeItem, session);
        MenuItem mediumItem = new MenuItem();
        mediumItem.setId("medium-" + item.getId());
        mediumItem.setName("Medium-" + item.getName());
        mediumItem.setParentMenuItemId(item.getId());
        mediumItem.setMenuGroupId(item.getMenuGroupId());
        mediumItem.setMenuCategoryId(item.getMenuCategoryId());
        mediumItem.setUnit(item.getUnit());
        mediumItem.setVariant(true);
        mediumItem.setPrice(2.97);
        mediumItem.setInventoryItem(item.isInventoryItem());
        mediumItem.setAttributes(Arrays.asList(DatabaseUtil.mediumSize));
        MenuItemDAO.getInstance().save(mediumItem, session);
        MenuItem smallItem = new MenuItem();
        smallItem.setId("small-" + item.getId());
        smallItem.setName("Small-" + item.getName());
        smallItem.setParentMenuItemId(item.getId());
        smallItem.setMenuGroupId(item.getMenuGroupId());
        smallItem.setMenuCategoryId(item.getMenuCategoryId());
        smallItem.setUnit(item.getUnit());
        smallItem.setVariant(true);
        smallItem.setPrice(1.32);
        smallItem.setInventoryItem(item.isInventoryItem());
        smallItem.setAttributes(Arrays.asList(DatabaseUtil.smallSize));
        MenuItemDAO.getInstance().save(smallItem, session);
    }

    private void doCreateVariantForPepsi(MenuItem item, Session session) {
        MenuItem largeItem = new MenuItem();
        largeItem.setId("large-" + item.getId());
        largeItem.setName("Large-" + item.getName());
        largeItem.setParentMenuItemId(item.getId());
        largeItem.setMenuGroupId(item.getMenuGroupId());
        largeItem.setMenuCategoryId(item.getMenuCategoryId());
        largeItem.setUnit(item.getUnit());
        largeItem.setVariant(true);
        largeItem.setPrice(2.33);
        largeItem.setInventoryItem(item.isInventoryItem());
        largeItem.setAttributes(Arrays.asList(DatabaseUtil.largeSize));
        MenuItemDAO.getInstance().save(largeItem, session);
        MenuItem mediumItem = new MenuItem();
        mediumItem.setId("medium-" + item.getId());
        mediumItem.setName("Medium-" + item.getName());
        mediumItem.setParentMenuItemId(item.getId());
        mediumItem.setMenuGroupId(item.getMenuGroupId());
        mediumItem.setMenuCategoryId(item.getMenuCategoryId());
        mediumItem.setUnit(item.getUnit());
        mediumItem.setVariant(true);
        mediumItem.setPrice(1.67);
        mediumItem.setInventoryItem(item.isInventoryItem());
        mediumItem.setAttributes(Arrays.asList(DatabaseUtil.mediumSize));
        MenuItemDAO.getInstance().save(mediumItem, session);
    }

    private void createInventoryData() {
        InventoryUnitGroup group = new InventoryUnitGroup();
        group.setName("Measurement");
        InventoryUnitGroupDAO.getInstance().save(group);
        InventoryUnitGroup weight = new InventoryUnitGroup();
        weight.setName("Weight");
        InventoryUnitGroupDAO.getInstance().save(weight);
        this.unitPiece = new InventoryUnit();
        this.unitPiece.setBaseUnit(true);
        this.unitPiece.setCode("pc");
        this.unitPiece.setName("Piece");
        this.unitPiece.setConversionRate(1.0);
        this.unitPiece.setUnitGroupId(group.getId());
        InventoryUnitDAO.getInstance().save(this.unitPiece);
        this.unitGram = new InventoryUnit();
        this.unitGram.setCode("g");
        this.unitGram.setName("gram");
        this.unitGram.setConversionRate(1000.0);
        this.unitGram.setUnitGroupId(weight.getId());
        InventoryUnitDAO.getInstance().save(this.unitGram);
        this.unitKg = new InventoryUnit();
        this.unitKg.setBaseUnit(true);
        this.unitKg.setCode("kg");
        this.unitKg.setName("Kilo gram");
        this.unitKg.setConversionRate(1.0);
        this.unitKg.setUnitGroupId(weight.getId());
        InventoryUnitDAO.getInstance().save(this.unitKg);
        PackagingUnit packagingUnit = new PackagingUnit();
        packagingUnit.setCode("box");
        packagingUnit.setName("Box");
        PackagingUnitDAO.getInstance().save(packagingUnit);
        packagingUnit = new PackagingUnit();
        packagingUnit.setCode("cartoon");
        packagingUnit.setName("Cartoon");
        PackagingUnitDAO.getInstance().saveOrUpdate(packagingUnit);
        InventoryLocation location = new InventoryLocation("store");
        location.setName("Store");
        location.setDefaultInLocation(true);
        location.setDefaultOutLocation(true);
        location.setSortOrder(0);
        location.setVisible(true);
        location.setRoot(true);
        InventoryLocationDAO.getInstance().save(location);
        InventoryVendor vendor = new InventoryVendor("cash");
        vendor.setName("Cash");
        vendor.setVisible(true);
        InventoryVendorDAO.getInstance().save(vendor);
    }

    private void createDefaultFloor() {
        int i;
        ShopFloor floor = new ShopFloor();
        floor.setName("Main Floor");
        List<ShopTable> tableList = ShopTableDAO.getInstance().findAll();
        HashSet<ShopTable> shopTables = new HashSet<ShopTable>();
        if (tableList != null && !tableList.isEmpty()) {
            for (i = 0; i < tableList.size(); ++i) {
                ShopTable shopTable = tableList.get(i);
                shopTable.setX(this.getPositionX().get(i));
                shopTable.setY(this.getPositionY().get(i));
                ShopTableDAO.getInstance().saveOrUpdate(shopTable);
                shopTables.add(shopTable);
                if (i != 13) {
                    continue;
                }
                break;
            }
        } else {
            for (i = 0; i < this.getPositionX().size(); ++i) {
                shopTables.add(new ShopTable(floor, this.getPositionX().get(i), this.getPositionY().get(i), i + 1));
            }
        }
        floor.setTables(shopTables);
        Session session = ShopFloorDAO.getInstance().getSession();
        Transaction transaction = session.beginTransaction();
        session.save((Object)floor);
        transaction.commit();
        session.close();
    }

    private List<Integer> getPositionX() {
        ArrayList<Integer> positionX = new ArrayList<Integer>();
        positionX.add(19);
        positionX.add(161);
        positionX.add(309);
        positionX.add(17);
        positionX.add(162);
        positionX.add(318);
        positionX.add(18);
        positionX.add(161);
        positionX.add(330);
        positionX.add(22);
        positionX.add(169);
        positionX.add(329);
        positionX.add(487);
        positionX.add(661);
        return positionX;
    }

    private List<Integer> getPositionY() {
        ArrayList<Integer> positionY = new ArrayList<Integer>();
        positionY.add(12);
        positionY.add(12);
        positionY.add(14);
        positionY.add(132);
        positionY.add(136);
        positionY.add(140);
        positionY.add(258);
        positionY.add(258);
        positionY.add(260);
        positionY.add(382);
        positionY.add(381);
        positionY.add(387);
        positionY.add(391);
        positionY.add(390);
        return positionY;
    }

    private void createManagerUser(UserType manager, UserType cashier, UserType server) {
        User managerUser = new User();
        managerUser.setId("124");
        managerUser.setEncryptedPassword("2222");
        managerUser.setFirstName("Manager");
        managerUser.setLastName("M");
        managerUser.setType(manager);
        managerUser.setRoot(true);
        managerUser.setActive(true);
        managerUser.setStaffBank(true);
        User cashierUser = new User();
        cashierUser.setId("981");
        cashierUser.setFirstName("Manager");
        cashierUser.setLastName("M");
        cashierUser.setType(cashier);
        cashierUser.setParentUser(managerUser);
        cashierUser.setActive(true);
        cashierUser.setStaffBank(true);
        User serverUser = new User();
        serverUser.setId("890");
        serverUser.setFirstName("Manager");
        serverUser.setLastName("M");
        serverUser.setType(server);
        serverUser.setParentUser(managerUser);
        serverUser.setActive(true);
        serverUser.setStaffBank(true);
        serverUser.setAutoStartStaffBank(true);
        UserDAO dao = UserDAO.getInstance();
        dao.save(managerUser);
        dao.save(cashierUser);
        dao.save(serverUser);
    }
}

