/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import jssc.SerialPort;
import jssc.SerialPortException;

public class DrawerUtil {
    private boolean escp24pin;
    private static int MAX_ADVANCE_9PIN = 216;
    private static int MAX_ADVANCE_24PIN = 180;
    private static int MAX_UNITS = 127;
    private static final float CM_PER_INCH = 2.54f;
    private static final char ESC = '\u001b';
    private static final char AT = '@';
    private static final char LINE_FEED = '\n';
    private static final char PARENTHESIS_LEFT = '(';
    private static final char BACKSLASH = '\\';
    private static final char CR = '\r';
    private static final char TAB = '\t';
    private static final char FF = '\f';
    private static final char g = 'g';
    private static final char p = 'p';
    private static final char t = 't';
    private static final char l = 'l';
    private static final char x = 'x';
    private static final char E = 'E';
    private static final char F = 'F';
    private static final char J = 'J';
    private static final char P = 'P';
    private static final char Q = 'Q';
    private static final char $ = '$';
    private static final char ARGUMENT_0 = '\u0000';
    private static final char ARGUMENT_1 = '\u0001';
    private static final char ARGUMENT_2 = '\u0002';
    private static final char ARGUMENT_3 = '\u0003';
    private static final char ARGUMENT_4 = '\u0004';
    private static final char ARGUMENT_5 = '\u0005';
    private static final char ARGUMENT_6 = '\u0006';
    private static final char ARGUMENT_7 = '\u0007';
    private static final char ARGUMENT_25 = '\u0019';
    private static final char TEAR = 'i';
    private static final char _0 = '\u0000';
    private static final char _1 = '\u0001';
    private static final char _25 = '\u0019';
    private static final char _250 = '\u00fa';
    private static final char _999 = '\u03e7';
    private static final char _48 = '0';
    private static final char _55 = '7';
    private static final char _121 = 'y';
    public static final char USA = '\u0001';
    public static final char BRAZIL = '\u0019';
    public static SerialPort serialPort;
    private static char[] controlCodes;

    public void close() {
        try {
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static boolean initialize() {
        try {
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
            DrawerUtil.setCharacterSet('\u0001');
        }
        catch (SerialPortException ex) {
            return false;
        }
        return true;
    }

    public static boolean printToThePort() {
        try {
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
            DrawerUtil.print('\u001b');
            DrawerUtil.print('@');
            DrawerUtil.setCharacterSet('\u0001');
        }
        catch (SerialPortException ex) {
            return false;
        }
        return true;
    }

    public static void select10CPI() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('P');
    }

    public static void select15CPI() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('g');
    }

    public static void selectDraftPrinting() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('x');
        DrawerUtil.print('0');
    }

    public static void selectLQPrinting() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('x');
        DrawerUtil.print('1');
    }

    public static void setCharacterSet(char charset) {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('(');
        DrawerUtil.print('t');
        DrawerUtil.print('\u0003');
        DrawerUtil.print('\u0000');
        DrawerUtil.print('\u0001');
        DrawerUtil.print(charset);
        DrawerUtil.print('\u0000');
        DrawerUtil.print('\u001b');
        DrawerUtil.print('t');
        DrawerUtil.print('\u0001');
    }

    public static void lineFeed() {
        DrawerUtil.print('\r');
        DrawerUtil.print('\n');
    }

    public static void formFeed() {
        DrawerUtil.print('\r');
        DrawerUtil.print('\f');
    }

    public static void bold(boolean bold) {
        DrawerUtil.print('\u001b');
        if (bold) {
            DrawerUtil.print('E');
        } else {
            DrawerUtil.print('F');
        }
    }

    public static void tear() {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('i');
    }

    public static void kick() {
        DrawerUtil.print("Start kicking drawer\n");
        if (controlCodes.length >= 5) {
            DrawerUtil.print(controlCodes[0]);
            DrawerUtil.print(controlCodes[1]);
            DrawerUtil.print(controlCodes[2]);
            DrawerUtil.print(controlCodes[3]);
            DrawerUtil.print(controlCodes[4]);
        } else {
            DrawerUtil.print('\u001b');
            DrawerUtil.print('p');
            DrawerUtil.print('\u0000');
            DrawerUtil.print('\u0019');
            DrawerUtil.print('\u00fa');
        }
        DrawerUtil.print("End kicking drawer\n");
    }

    public static void proportionalMode(boolean proportional) {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('p');
        if (proportional) {
            DrawerUtil.print('1');
        } else {
            DrawerUtil.print('0');
        }
    }

    public static void advanceVertical(float centimeters) {
    }

    public static void advanceHorizontal(float centimeters) {
        float inches = centimeters / 2.54f;
        int units_low = (int)(inches * 120.0f) % 256;
        int units_high = (int)(inches * 120.0f) / 256;
        DrawerUtil.print('\u001b');
        DrawerUtil.print('\\');
        DrawerUtil.print((char)units_low);
        DrawerUtil.print((char)units_high);
    }

    public static void setAbsoluteHorizontalPosition(float centimeters) {
        float inches = centimeters / 2.54f;
        int units_low = (int)(inches * 60.0f) % 256;
        int units_high = (int)(inches * 60.0f) / 256;
        DrawerUtil.print('\u001b');
        DrawerUtil.print('$');
        DrawerUtil.print((char)units_low);
        DrawerUtil.print((char)units_high);
    }

    public static void horizontalTab(int tabs) {
        for (int i = 0; i < tabs; ++i) {
            DrawerUtil.print('\t');
        }
    }

    public static void setMargins(int columnsLeft, int columnsRight) {
        DrawerUtil.print('\u001b');
        DrawerUtil.print('l');
        DrawerUtil.print((char)columnsLeft);
        DrawerUtil.print('\u001b');
        DrawerUtil.print('Q');
        DrawerUtil.print((char)columnsRight);
    }

    public static void print(String text) {
        try {
            serialPort.writeBytes(text.getBytes());
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static void print(char text) {
        try {
            serialPort.writeByte((byte)text);
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static boolean isInitialized() {
        return true;
    }

    public static String getShare() {
        return "";
    }

    public static void kickDrawer() {
        try {
            PosLog.debug(DrawerUtil.class, "kicking drawer...");
            String portName = TerminalConfig.getDrawerPortName();
            char[] codesArray = TerminalConfig.getDrawerControlCodesArray();
            DrawerUtil.kickDrawer(portName, codesArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void kickDrawer(String portName, char[] codes) {
        controlCodes = codes;
        serialPort = new SerialPort(portName);
        DrawerUtil.initialize();
        try {
            DrawerUtil.kick();
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static void setCustomerDisplayMessage(String portName, String customerDisplayMessage) {
        serialPort = new SerialPort(portName);
        DrawerUtil.initialize();
        try {
            DrawerUtil.print('\f');
            serialPort.writeBytes(customerDisplayMessage.getBytes());
            serialPort.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }

    public static void setItemDisplay(String port, String message) {
        try {
            serialPort = new SerialPort(port);
            DrawerUtil.initialize();
            DrawerUtil.print('\f');
            DrawerUtil.print(message);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {}
        }
    }

    public static void testWeightInput() {
        try {
            SerialPort serialPort = new SerialPort("COM1");
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
            DrawerUtil.setCharacterSet('\u0001');
            DrawerUtil.print('W');
            DrawerUtil.print('\r');
            byte[] readBytes = serialPort.readBytes();
            PosLog.info(DrawerUtil.class, "Response: " + new String(readBytes));
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
    }
}

