/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.kitchendisplay.LineDisplayWindow;
import com.floreantpos.util.NumberUtil;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.FocusManager;
import org.apache.commons.lang.StringUtils;

public class POSUtil {
    public static Window getFocusedWindow() {
        return FocusManager.getCurrentManager().getFocusedWindow();
    }

    public static Frame getFocusedFrame() {
        return (Frame)FocusManager.getCurrentManager().getFocusedWindow();
    }

    public static Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 2);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    public static BackOfficeWindow getBackOfficeWindow() {
        return BackOfficeWindow.getInstance();
    }

    public static LineDisplayWindow getLineDisplayWindow() {
        Window[] windows;
        Window[] windowArray = windows = Window.getWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            Window window = windowArray[n2];
            if (window instanceof LineDisplayWindow) {
                return (LineDisplayWindow)window;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isBlankOrNull(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    public static String escapePropertyKey(String propertyKey) {
        return propertyKey.replaceAll("\\s+", "_");
    }

    public static boolean getBoolean(String b) {
        if (b == null) {
            return false;
        }
        return Boolean.valueOf(b);
    }

    public static boolean getBoolean(Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean getBoolean(Boolean b, boolean defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public static double getDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public static double getDoubleAmount(Object result) {
        if (result != null && result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return 0.0;
    }

    public static double getRoundedDouble(Object result) {
        if (result != null && result instanceof Number) {
            return NumberUtil.round(((Number)result).doubleValue());
        }
        return 0.0;
    }

    public static int getInteger(Integer d) {
        if (d == null) {
            return 0;
        }
        return d;
    }

    public static int parseInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            return 0;
        }
    }

    public static int parseInteger(String s, String parseErrorMessage) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            throw new PosException(parseErrorMessage);
        }
    }

    public static double parseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception x) {
            return 0.0;
        }
    }

    public static double parseDouble(String s, String parseErrorMessage, boolean mandatory) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception x) {
            if (mandatory) {
                throw new PosException(parseErrorMessage);
            }
            return 0.0;
        }
    }

    public static String encodeURLString(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception x) {
            return s;
        }
    }

    public static boolean isValidPassword(char[] password) {
        char[] cArray = password;
        int n = password.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean checkDrawerAssignment() {
        Terminal terminal = Application.getInstance().getTerminal();
        User currentUser = Application.getCurrentUser();
        return POSUtil.checkDrawerAssignment(terminal, currentUser);
    }

    public static boolean checkDrawerAssignment(Terminal terminal, User user) {
        if (TerminalDAO.getInstance().isDrawerAssigned(terminal)) {
            return true;
        }
        if (user.isStaffBank().booleanValue() && user.isStaffBankStarted().booleanValue()) {
            return true;
        }
        POSUtil.showUnableToAcceptPayment();
        return false;
    }

    private static void showUnableToAcceptPayment() {
        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SwitchboardView.18"));
    }

    public static Blob convertImageToBlob(File imageFile) throws Exception {
        int lastIndexOfImage;
        if (imageFile == null) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(imageFile);
        if (bufferedImage.getWidth() > 400 || bufferedImage.getHeight() > 400) {
            int type = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, 400, 400, type);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        String imageName = imageFile.getName();
        String imageExtension = imageName.substring((lastIndexOfImage = imageName.lastIndexOf(".")) + 1);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        }
        byte[] byteArray = outputStream.toByteArray();
        if (byteArray.length > 500000) {
            throw new RuntimeException("Image size too large. Maximum allowed image size is 500KB");
        }
        return new SerialBlob(byteArray);
    }

    public static Blob convertImageToBlob(BufferedImage bufferedImage, String imageExtension) throws Exception {
        if (bufferedImage == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        }
        byte[] byteArray = outputStream.toByteArray();
        if (byteArray.length > 500000) {
            throw new RuntimeException("Image size too large. Maximum allowed image size is 500KB");
        }
        return new SerialBlob(byteArray);
    }

    public static Blob convertScaledImageToBlob(File imageFile) throws Exception {
        int lastIndexOfImage;
        if (imageFile == null) {
            return null;
        }
        int width = 120;
        int height = 120;
        BufferedImage originalImage = ImageIO.read(imageFile);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
        BufferedImage resizeImage = POSUtil.resizeImage(originalImage, width, height, type);
        String imageName = imageFile.getName();
        String imageExtension = imageName.substring((lastIndexOfImage = imageName.lastIndexOf(".")) + 1);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)resizeImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)resizeImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)resizeImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)resizeImage, "gif", outputStream);
        }
        return new SerialBlob(outputStream.toByteArray());
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int IMG_WIDTH, int IMG_HEIGHT, int type) {
        BufferedImage resizedImage = new BufferedImage(IMG_WIDTH, IMG_HEIGHT, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, IMG_WIDTH, IMG_HEIGHT, null);
        g.dispose();
        return resizedImage;
    }

    public static User getUserWithPermission(UserPermission requiredPermission) {
        String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)password)) {
            return null;
        }
        User user = UserDAO.getInstance().findUserBySecretKey(password);
        if (user == null) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
            return null;
        }
        if (!user.hasPermission(requiredPermission)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.2"));
            return null;
        }
        return user;
    }

    public static void storeLongProperty(Map<String, String> propertyMap, String propertyName, String propertyValue, int length) {
        String nameToStore;
        Set<String> keys = propertyMap.keySet();
        HashSet<String> existingKeys = new HashSet<String>();
        for (String key : keys) {
            if (!key.startsWith(propertyName)) continue;
            existingKeys.add(key);
        }
        for (String string : existingKeys) {
            propertyMap.remove(string);
        }
        if (propertyValue.length() <= length) {
            propertyMap.put(String.valueOf(propertyName) + "1", propertyValue);
            return;
        }
        int count = 1;
        String valueToStore = "";
        do {
            valueToStore = propertyValue.substring(0, length);
            propertyValue = propertyValue.substring(length);
            nameToStore = String.valueOf(propertyName) + count++;
            propertyMap.put(nameToStore, valueToStore);
        } while (propertyValue.length() >= length);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            nameToStore = String.valueOf(propertyName) + count++;
            propertyMap.put(nameToStore, propertyValue);
        }
    }

    public static String readLongProperty(Map<String, String> propertyMap, String propertyName) {
        ArrayList<Integer> propertyNumbers = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> keys = propertyMap.keySet();
        for (String key : keys) {
            if (!key.startsWith(propertyName)) continue;
            String numberString = key.replaceAll(propertyName, "");
            try {
                propertyNumbers.add(Integer.parseInt(numberString));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Collections.sort(propertyNumbers);
        for (Integer integer : propertyNumbers) {
            String string = propertyMap.get(String.valueOf(propertyName) + integer);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static void removeLongProperty(Map<String, String> propertyMap, String propertyName) {
        Iterator<Map.Entry<String, String>> it = propertyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getKey().startsWith(propertyName)) continue;
            it.remove();
        }
    }

    public static Set copySelectedValues(Set toCollection, Set selectedValues) {
        if (toCollection == null) {
            toCollection = new LinkedHashSet();
            toCollection.addAll(selectedValues);
            return toCollection;
        }
        Iterator iterator = toCollection.iterator();
        while (iterator.hasNext()) {
            Object existingValue = iterator.next();
            if (selectedValues.contains(existingValue)) continue;
            iterator.remove();
        }
        toCollection.addAll(selectedValues);
        return toCollection;
    }

    public static List copySelectedValues(List toCollection, List selectedValues) {
        if (toCollection == null) {
            toCollection = new ArrayList();
            toCollection.addAll(selectedValues);
            return toCollection;
        }
        Iterator iterator = toCollection.iterator();
        while (iterator.hasNext()) {
            Object existingValue = iterator.next();
            if (selectedValues.contains(existingValue)) continue;
            iterator.remove();
        }
        toCollection.addAll(selectedValues);
        return toCollection;
    }
}

