/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;

public class PosWebService {
    public static List getDataList(String entity) throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/" + entity);
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<OrderType> getOrderTypes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/ordertype");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<OrderType>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<Outlet> getOutlets() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/outlet");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<Outlet>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<SalesArea> getSalesArea() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/salesarea");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<SalesArea>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<Department> getDepartments() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/department");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<Department>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<TerminalType> getTerminalTypes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/terminaltype");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<TerminalType>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<Terminal> getTerminals() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/terminal");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<Terminal>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<Currency> getCurrencies() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/currency");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<Currency>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<UserPermission> getUserPermissions() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/userpermission");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<UserPermission>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<UserType> getUserTypes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/usertype");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<UserType>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<User> getUsers() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/user");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<User>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<Tax> getTaxes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/tax");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<Tax>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<TaxGroup> getTaxGroups() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/taxgroup");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<TaxGroup>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<MenuCategory> getMenuCategories() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuCategory");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<MenuCategory>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<MenuGroup> getMenuGroups() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuGroup");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<MenuGroup>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<MenuItem> getMenuItems() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuItem");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<MenuItem>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<ModifierGroup> getModifierGroups() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/ModifierGroup");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<ModifierGroup>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<MenuModifier> getMenuModifiers() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuModifier");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<MenuModifier>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<PriceRule> getPriceRules() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/PriceRule");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<PriceRule>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<PriceTable> getPriceList() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/PriceTable");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<PriceTable>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static List<PriceShift> getPriceShift() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/PriceShift");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)response.getEntity((GenericType)new GenericType<List<PriceShift>>(){});
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static String checkConnection(String url, String storeId, String adminUserName, String adminPassword) {
        try {
            Client client = Client.create();
            client.getProperties();
            MultivaluedMapImpl map = new MultivaluedMapImpl();
            map.add((Object)"store_id", (Object)storeId);
            map.add((Object)"user_name", (Object)adminUserName);
            map.add((Object)"password", (Object)adminPassword);
            WebResource webResource = client.resource(url + "/service/data/access");
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)map);
            if (response.getStatus() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
            }
            String accessInfo = (String)response.getEntity(String.class);
            if (accessInfo.length() > 50) {
                return "error,Invalid server address";
            }
            return accessInfo;
        }
        catch (Exception ex) {
            return "error, Connection failed.";
        }
    }

    public static void uploadStoreSessionData(List<StoreSession> storeSessionList) throws Exception {
        if (storeSessionList != null) {
            for (StoreSession storeSession : storeSessionList) {
                PosWebService.uploadStoreSessionData(storeSession);
            }
        }
    }

    public static void uploadStoreSessionData(StoreSession storeSessionOrgin) throws Exception {
        StoreSession storeSession = new StoreSession();
        PropertyUtils.copyProperties((Object)storeSession, (Object)storeSessionOrgin);
        if (!storeSession.isCloudSynced().booleanValue()) {
            storeSession.setOutletId(String.valueOf(StoreDAO.getRestaurant().getUniqueId()));
            PosWebService.makeXMLTransient(storeSession.getClosedBy());
            PosWebService.makeXMLTransient(storeSession.getOpenedBy());
            ArrayList<StoreSession> sessions = new ArrayList<StoreSession>();
            sessions.add(storeSession);
            try {
                GenericEntity<List<StoreSession>> entity = new GenericEntity<List<StoreSession>>(sessions){};
                PosWebService.uploadData((GenericEntity)entity, "storesession");
            }
            catch (Exception e) {
                String message = "Uploading storesession failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
            PosWebService.uploadTickets(storeSession);
            PosWebService.uploadSessionCashDrawers(storeSession);
            PosWebService.uploadSessionTransactions(storeSession);
            if (storeSessionOrgin.getCloseTime() != null) {
                storeSessionOrgin.setCloudSynced(true);
                StoreSessionDAO.getInstance().update(storeSessionOrgin);
            }
        }
    }

    public static void uploadTerminal() {
        List<Terminal> terminals = TerminalDAO.getInstance().findAll();
        if (terminals != null && !terminals.isEmpty()) {
            for (Terminal terminal : terminals) {
                PosWebService.makeXMLTransient(terminal);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Terminal>>(terminals){}, "terminal");
            }
            catch (Exception e) {
                String message = "Uploading terminal failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private static void uploadSessionCashDrawers(StoreSession storeSession) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        List<CashDrawer> cashDrawers = CashDrawerDAO.getInstance().findByUnSyncStoreOperationData(storeSession);
        if (cashDrawers != null && !cashDrawers.isEmpty()) {
            for (CashDrawer cashDrawer : cashDrawers) {
                CashDrawer drawer = new CashDrawer();
                PropertyUtils.copyProperties((Object)drawer, (Object)cashDrawer);
                if (cashDrawer.getReportTime() != null) {
                    ids.add(drawer.getId());
                }
                if (cashDrawer.getStartTime() != null) {
                    CashDrawerReportService reportService2 = new CashDrawerReportService(cashDrawer);
                    reportService2.populateReport();
                }
                PosWebService.makeXMLTransient(cashDrawer);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<CashDrawer>>(cashDrawers){}, "cashdrawer");
                CashDrawerDAO.getInstance().updateCashDrawerSync(ids);
            }
            catch (Exception e) {
                String message = "Uploading cashdrawer failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private static void makeXMLTransient(CashDrawer cashDrawer) {
        cashDrawer.setTransactions(null);
    }

    private static void makeXMLTransient(User user) {
        if (user == null) {
            return;
        }
        user.setCurrentCashDrawer(null);
        user.setLinkedUser(null);
    }

    private static void makeXMLTransient(Terminal terminal) {
        if (terminal == null) {
            return;
        }
        terminal.setCurrentCashDrawer(null);
        terminal.setAssignedUser(null);
    }

    private static void uploadTickets(StoreSession storeSession) {
        TicketDAO ticketDAOInstance = TicketDAO.getInstance();
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        List<Ticket> ticketOrgin = ticketDAOInstance.getTicketsOfCurrentSession(storeSession);
        Store thisStore = StoreDAO.getRestaurant();
        String outletId = String.valueOf(thisStore.getUniqueId());
        if (ticketOrgin != null && !ticketOrgin.isEmpty()) {
            for (Ticket ticket : ticketOrgin) {
                ticketDAOInstance.loadFullTicket(ticket);
                PosWebService.makeXMLTransient(ticket);
                ticket.setOutletId(outletId);
                tickets.add(ticket);
            }
        }
        try {
            GenericEntity<List<Ticket>> ticketEntity = new GenericEntity<List<Ticket>>(tickets){};
            PosWebService.uploadData((GenericEntity)ticketEntity, "tickets");
            ticketDAOInstance.updateTicketAndTicketItemSync(ticketDAOInstance.getTicketsOfCurrentSession(storeSession), true);
        }
        catch (Exception e) {
            String message = "Uploading tickets failed...";
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
        }
    }

    private static void uploadSessionTransactions(StoreSession storeSession) {
        ArrayList<String> transactionIds = new ArrayList<String>();
        List<PosTransaction> unSyncPosTrans = PosTransactionDAO.getInstance().getUnSyncTransactionsByStoreSession(storeSession);
        Store thisStore = StoreDAO.getRestaurant();
        if (unSyncPosTrans != null && !unSyncPosTrans.isEmpty()) {
            for (PosTransaction posTransaction : unSyncPosTrans) {
                transactionIds.add(posTransaction.getId());
                String outletId = String.valueOf(thisStore.getUniqueId());
                posTransaction.setOutletId(outletId);
                PosWebService.makeXMLTransientTransactions(posTransaction.getTicket());
            }
        }
        try {
            GenericEntity<List<PosTransaction>> entity = new GenericEntity<List<PosTransaction>>(unSyncPosTrans){};
            PosWebService.uploadData((GenericEntity)entity, "transactions");
            PosTransactionDAO.getInstance().updatePosTransSync(transactionIds, true);
        }
        catch (Exception e) {
            String message = "Uploading transactions failed...";
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
        }
    }

    private static void makeXMLTransientTransactions(Ticket ticket) {
        ticket.setTicketItems(null);
        ticket.setProperties(null);
        ticket.setTransactions(null);
        ticket.setDepartment(null);
        ticket.setDiscounts(null);
        ticket.setCashier(null);
        ticket.setOwner(null);
        ticket.setOrderType(null);
        ticket.setGratuity(null);
    }

    private static void makeXMLTransient(Ticket ticket) {
        List<TicketItem> ticketItemList;
        OrderType orderType;
        ticket.setProperties(null);
        ticket.setTransactions(null);
        ticket.setDepartment(null);
        List<TicketDiscount> discountList = ticket.getDiscounts();
        if (discountList != null && discountList.size() > 0) {
            for (TicketDiscount ticketDiscount : discountList) {
                PosWebService.makeXMLTransient(ticketDiscount);
            }
        }
        if ((orderType = ticket.getOrderType()) != null) {
            PosWebService.makeXMLTransient(orderType);
        }
        if ((ticketItemList = ticket.getTicketItems()) != null) {
            Hibernate.initialize(ticketItemList);
            for (TicketItem ticketItem : ticketItemList) {
                PosWebService.makeXMLTransient(ticketItem);
            }
        }
    }

    private static void makeXMLTransient(TicketDiscount ticketDiscount) {
        ticketDiscount.setTicket(null);
    }

    private static void makeXMLTransient(TicketItem ticketItem) {
        ticketItem.setTicket(null);
        ticketItem.setTicketItemModifiers(null);
        ticketItem.setParentTicketItem(null);
        ticketItem.setMenuItem(null);
        List<TicketItemDiscount> discountList = ticketItem.getDiscounts();
        if (discountList != null && discountList.size() > 0) {
            for (TicketItemDiscount ticketDiscount : discountList) {
                PosWebService.makeXMLTransient(ticketDiscount);
            }
        }
    }

    private static void makeXMLTransient(TicketItemDiscount ticketDiscount) {
        ticketDiscount.setTicketItem(null);
    }

    private static void makeXMLTransient(OrderType orderType) {
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    public static void uploadData(GenericEntity entity, String pathInfo) throws Exception {
        Client client = Client.create();
        client.getProperties();
        WebResource webResource = client.resource(Store.getWebServiceUrl() + "/" + pathInfo + "/save");
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)entity);
        if (response.getStatus() == 200) {
            System.out.println("uploaded...");
        } else if (response.getStatus() == 500) {
            throw new Exception("upload Failed..");
        }
    }
}

