/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.model.Address;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.StoreUtil;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.hibernate.Session;

public class AndroidDataProvider
extends DataProvider {
    private Store store;
    private Outlet outlet;
    private Terminal terminal;
    private String defaultCourseId;
    private StoreSession currentSession;
    private Map<String, User> userMap = new LinkedHashMap<String, User>();
    private PosPrinters printers;

    @Override
    public void initialize() {
        this.loadStore();
        this.setCloudTerminal(new Terminal(-1));
        this.loadUsers();
    }

    private void loadUsers() {
        this.userMap.clear();
        List<User> users = UserDAO.getInstance().findAll();
        if (users != null && users.size() > 0) {
            for (User user : users) {
                this.userMap.put(user.getId(), user);
            }
        }
    }

    @Override
    public void refreshStore() {
        this.loadStore();
    }

    @Override
    public void refreshCurrentTerminal() {
        TerminalDAO.getInstance().refresh(this.terminal);
    }

    private void loadStore() {
        StoreSessionControl currentStoreOperation;
        this.store = StoreDAO.getRestaurant();
        if (this.store.getUniqueId() == null || this.store.getUniqueId() == 0) {
            this.store.setUniqueId(RandomUtils.nextInt());
            StoreDAO.getInstance().saveOrUpdate(this.store);
        }
        this.outlet = OutletDAO.getInstance().get(String.valueOf(this.store.getUniqueId()));
        if (this.outlet == null) {
            this.outlet = new Outlet();
            this.outlet.setId(String.valueOf(this.store.getUniqueId()));
            this.outlet.setName(this.store.getOutletName());
            Address address = new Address();
            address.setAddressLine(this.store.getAddressLine1());
            this.outlet.setAddress(address);
            AddressDAO.getInstance().saveOrUpdate(address);
            OutletDAO.getInstance().save(this.outlet);
        }
        if ((currentStoreOperation = StoreUtil.getCurrentStoreOperation()) != null) {
            this.currentSession = currentStoreOperation.getCurrentData();
        }
        this.printers = PosPrinters.load();
    }

    @Override
    public void setStoreSession(StoreSession session) {
        this.currentSession = session;
    }

    @Override
    public StoreSession getStoreSession() {
        return this.currentSession;
    }

    @Override
    public Terminal getCurrentTerminal() {
        return this.terminal;
    }

    @Override
    public void setCloudTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    @Override
    public OrderType getOrderType(String orderTypeId) {
        if (StringUtils.isEmpty((String)orderTypeId)) {
            return null;
        }
        return OrderTypeDAO.getInstance().get(orderTypeId);
    }

    @Override
    public List<OrderType> getOrderTypes() {
        return OrderTypeDAO.getInstance().findAll();
    }

    @Override
    public UserType getUserType(String userTypeId) {
        if (StringUtils.isEmpty((String)userTypeId)) {
            return null;
        }
        return UserTypeDAO.getInstance().get(userTypeId);
    }

    @Override
    public Currency getCurrency(String currencyId) {
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        return CurrencyDAO.getInstance().get(currencyId);
    }

    @Override
    public Course getCourse(String courseId) {
        if (StringUtils.isEmpty((String)courseId)) {
            return null;
        }
        return CourseDAO.getInstance().get(courseId);
    }

    @Override
    public TerminalType getTerminalType(String terminalTypeId) {
        if (StringUtils.isEmpty((String)terminalTypeId)) {
            return null;
        }
        return TerminalTypeDAO.getInstance().get(terminalTypeId);
    }

    @Override
    public Multiplier getMultiplierById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return MultiplierDAO.getInstance().get(id);
    }

    @Override
    public List<Multiplier> getMultiplierList() {
        return MultiplierDAO.getInstance().findAll();
    }

    @Override
    public InventoryLocation getDefaultInLocation() {
        return InventoryLocationDAO.getInstance().getDefaultInInventoryLocation();
    }

    @Override
    public InventoryLocation getDefaultOutLocation() {
        return InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation();
    }

    @Override
    public List<Course> getCourses() {
        return CourseDAO.getInstance().findAll();
    }

    @Override
    public String getDefaultCourseId() {
        return this.defaultCourseId;
    }

    @Override
    public String getRecipeMenuItemName(Recepie recipe) {
        return RecepieDAO.getInstance().getMenuItemName(recipe);
    }

    @Override
    public MenuItemInventoryStatus getMenuItemStockStatus(MenuItem menuItem) {
        MenuItemInventoryStatusDAO dao = MenuItemInventoryStatusDAO.getInstance();
        try (Session session = dao.createNewSession();){
            MenuItemInventoryStatus stockStatus = dao.get(menuItem.getId(), session);
            if (stockStatus == null) {
                stockStatus = new MenuItemInventoryStatus(menuItem.getId());
                dao.save(stockStatus, session);
            }
            MenuItemInventoryStatus menuItemInventoryStatus = stockStatus;
            return menuItemInventoryStatus;
        }
    }

    @Override
    public SalesArea getSalesArea(String salesAreaId) {
        if (StringUtils.isEmpty((String)salesAreaId)) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(salesAreaId);
    }

    @Override
    public Customer getCustomer(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return CustomerDAO.getInstance().get(id);
    }

    @Override
    public double getPriceFromPriceRule(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup) {
        Double price = PriceRuleDAO.getInstance().getPrice(menuItem, orderType, department, salesArea, customerGroup);
        if (price == null) {
            return menuItem.getPrice();
        }
        return price;
    }

    @Override
    public PosPrinters getPrinters() {
        return this.printers;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public Outlet getOutlet() {
        return this.outlet;
    }

    @Override
    public InventoryUnit getInventoryUnitById(String unitId) {
        if (StringUtils.isEmpty((String)unitId)) {
            return null;
        }
        return InventoryUnitDAO.getInstance().get(unitId);
    }

    @Override
    public TaxGroup getTaxGroupById(String taxGroupId) {
        if (StringUtils.isEmpty((String)taxGroupId)) {
            return null;
        }
        return TaxGroupDAO.getInstance().get(taxGroupId);
    }

    @Override
    public ReportGroup getReportGroupById(String reportGroupId) {
        if (StringUtils.isEmpty((String)reportGroupId)) {
            return null;
        }
        return ReportGroupDAO.getInstance().get(reportGroupId);
    }

    @Override
    public PrinterGroup getPrinterGroupById(String printerGroupId) {
        if (StringUtils.isEmpty((String)printerGroupId)) {
            return null;
        }
        return PrinterGroupDAO.getInstance().get(printerGroupId);
    }

    @Override
    public Department getDepartmentById(String departmentId) {
        if (StringUtils.isEmpty((String)departmentId)) {
            return null;
        }
        return DepartmentDAO.getInstance().get(departmentId);
    }

    @Override
    public OrderType getOrderTypeById(String orderTypeId) {
        if (StringUtils.isEmpty((String)orderTypeId)) {
            return null;
        }
        return OrderTypeDAO.getInstance().get(orderTypeId);
    }

    @Override
    public InventoryLocation getInventoryLocationById(String inventoryLocationId) {
        if (StringUtils.isEmpty((String)inventoryLocationId)) {
            return null;
        }
        return InventoryLocationDAO.getInstance().get(inventoryLocationId);
    }

    @Override
    public User getUserById(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        User user = this.userMap.get(userId);
        if (user != null) {
            return user;
        }
        User eUser = UserDAO.getInstance().get(userId);
        return eUser;
    }

    @Override
    public Terminal getTerminalById(Integer terminalId) {
        if (terminalId == null) {
            return null;
        }
        return TerminalDAO.getInstance().get(terminalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectOf(Class clazz, Serializable id) {
        Session session = null;
        try {
            session = StoreDAO.getInstance().createNewSession();
            Object object = session.get(clazz, id);
            return object;
        }
        finally {
            StoreDAO.getInstance().closeSession(session);
        }
    }

    @Override
    public Shift getShiftById(String shiftId) {
        if (StringUtils.isEmpty((String)shiftId)) {
            return null;
        }
        return ShiftDAO.getInstance().get(shiftId);
    }

    @Override
    public List<DayPart> getDaryPartShifts() {
        return DayPartDAO.getInstance().findAll();
    }

    @Override
    public List<PriceShift> getPriceShifts() {
        return PriceShiftDAO.getInstance().findAll();
    }

    @Override
    public List<MenuShift> getMenuShifts() {
        return MenuShiftDAO.getInstance().findAll();
    }

    @Override
    public File getAppConfigFileLocation() {
        return new File(".");
    }
}

