/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.orocube.licensemanager.OroLicense;
import com.orocube.rest.service.OroMobileDisclaimerDialog;
import com.orocube.rest.service.PosResponse;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class AndroidDevice
implements Serializable {
    private static final File licenseDir = new File(System.getProperty("user.home") + "/.orocube");
    private String appName;
    private String appVersion;
    private Integer terminalId;
    private String terminalKey;
    private String name;
    private Boolean enable;
    private Boolean hasValidLicense;
    private boolean licenseRequired = true;
    private String connectionStatus;
    private Terminal terminal;
    private OroLicense license;

    public AndroidDevice(Integer terminalId, String terminalKey) {
        this.terminalId = terminalId;
        this.terminalKey = terminalKey;
    }

    public Integer getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(Integer terminalId) {
        this.terminalId = terminalId;
    }

    public String getTerminalKey() {
        return this.terminalKey;
    }

    public void setTerminalKey(String terminalKey) {
        this.terminalKey = terminalKey;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public Boolean isHasValidLicense() {
        return true;
    }

    public void setHasValidLicense(Boolean hasValidLicense) {
        this.hasValidLicense = hasValidLicense;
    }

    public boolean hasAccessPermission() {
        String reqTerminalKey = this.getTerminalKey();
        return !StringUtils.isEmpty((String)reqTerminalKey);
    }

    public boolean isNewTerminal() {
        return this.terminalId == null || this.terminalId <= 0;
    }

    public String getConnectionStatus() {
        return this.connectionStatus == null ? "-" : this.connectionStatus;
    }

    private static File getLicenseFromCurrentDiectory(String productName) {
        File licenseDir = new File(".");
        File licenseFile = new File(licenseDir, productName + ".lic");
        if (licenseFile.exists()) {
            return licenseFile;
        }
        return null;
    }

    private static File getLicenseFromHomeDiectory(String productName) {
        File licenseFile = new File(licenseDir, productName + ".lic");
        if (licenseFile.exists()) {
            return licenseFile;
        }
        return null;
    }

    public void setConnectionStatus(String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public static AndroidDevice build(String request) {
        String terminalKey = StringUtils.substringBetween((String)(request = request.replaceAll("&#", "/")), (String)"<terminalKey>", (String)"</terminalKey>");
        Integer terminalId = AndroidDevice.getTerminalIdByTerminalKey(terminalKey);
        if (terminalId == null || terminalId <= 0) {
            terminalId = -1;
        }
        AndroidDevice device = new AndroidDevice(terminalId, terminalKey);
        device.appName = StringUtils.substringBetween((String)request, (String)"<appName>", (String)"</appName>");
        device.appVersion = StringUtils.substringBetween((String)request, (String)"<appVersion>", (String)"</appVersion>");
        device.name = StringUtils.substringBetween((String)request, (String)"<deviceName>", (String)"</deviceName>");
        device.setHasValidLicense(device.hasAccessPermission());
        return device;
    }

    public Terminal saveAsNewTerminal(String terminalKey) {
        Terminal createNewTerminal = this.checkAndGetTerminal(terminalKey);
        return createNewTerminal;
    }

    public static List<AndroidDevice> buildList() {
        ArrayList<AndroidDevice> terminalList = new ArrayList<AndroidDevice>();
        List<Terminal> mobileTerminals = TerminalDAO.getInstance().findTerminalsByDeviceType(1, 0);
        if (mobileTerminals != null) {
            for (Terminal terminal : mobileTerminals) {
                AndroidDevice mobileDevice = new AndroidDevice(terminal.getId(), terminal.getTerminalKey());
                mobileDevice.hasAccessPermission();
                terminalList.add(mobileDevice);
            }
        }
        return terminalList;
    }

    public Terminal checkAndGetTerminal(String terminalKey2) {
        TerminalDAO terminalDAO = TerminalDAO.getInstance();
        Terminal terminal = terminalDAO.getByTerminalKey(terminalKey2);
        if (terminal != null) {
            terminal.setDepartment(null);
            terminal.setAssignedUser(null);
            CashDrawer cashDrawer = terminal.getCurrentCashDrawer();
            if (cashDrawer != null) {
                cashDrawer.setTransactions(null);
            }
            terminal.setOutlet(null);
            terminal.setSalesArea(null);
            terminal.setProperties(null);
            if (terminal.getDeviceType() == 0) {
                terminal.setDeviceType(1);
                terminal.setName(this.name);
                TerminalDAO.getInstance().saveOrUpdate(terminal);
            }
            return terminal;
        }
        Outlet outlet = DataProvider.get().getOutlet();
        if (terminal == null) {
            Integer terminalId = TerminalDAO.getInstance().createNewTerminalId();
            terminal = new Terminal();
            terminal.setId(terminalId);
            terminal.setDeviceType(1);
            terminal.setTerminalKey(terminalKey2);
            terminal.setName(StringUtils.isNotEmpty((String)this.name) ? this.name : String.valueOf("Terminal " + terminalId));
            if (outlet != null) {
                terminal.setOutletId(outlet.getId());
            }
            terminalDAO.saveOrUpdate(terminal);
        }
        if (terminal.getOutlet() == null) {
            terminal.setOutlet(outlet);
            terminalDAO.saveOrUpdate(terminal);
        }
        return terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getTerminalIdByTerminalKey(String terminalKey) {
        Session session = null;
        try {
            session = TerminalDAO.getInstance().createNewSession();
            Criteria criteria = session.createCriteria(Terminal.class);
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)terminalKey));
            criteria.setMaxResults(1);
            Integer n = (Integer)criteria.uniqueResult();
            return n;
        }
        catch (Exception e) {
            PosLog.error(AndroidDevice.class, e);
        }
        finally {
            TerminalDAO.getInstance().closeSession(session);
        }
        return -1;
    }

    public String getStatus() {
        return this.isHasValidLicense().booleanValue() ? (this.licenseRequired ? "Registered" : "Registered *") : "X";
    }

    public void setStatus(String status) {
    }

    public String getName() {
        if (StringUtils.isNotEmpty((String)this.name)) {
            return this.name;
        }
        Terminal terminal = this.getTerminal();
        if (terminal != null) {
            this.name = terminal.getName();
            return this.name;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Terminal getTerminal() {
        if (this.terminal == null && this.getTerminalId() != null) {
            this.terminal = TerminalDAO.getInstance().get(this.getTerminalId());
        }
        return this.terminal;
    }

    public Boolean isEnable() {
        Terminal terminal = this.getTerminal();
        if (terminal != null) {
            this.enable = terminal.isActive();
            return this.enable;
        }
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public PosResponse doRegister() {
        PosResponse response = new PosResponse();
        try {
            boolean canceled = OroMobileDisclaimerDialog.showDialog(this.appName, this.appVersion, this.terminalKey);
            if (!canceled) {
                response.setResponseCode(1);
                this.terminal = this.checkAndGetTerminal(this.terminalKey);
                this.terminal.setName(this.name);
                if (StringUtils.isNotEmpty((String)this.name) && !this.name.equals(this.terminal.getName())) {
                    TerminalDAO.getInstance().saveOrUpdate(this.terminal);
                }
                response.setData(String.valueOf(this.terminal.getId()));
                response.setMsg("Successfully registered.");
            }
            return response;
        }
        catch (Exception e) {
            PosLog.error(AndroidDevice.class, e);
            response.setResponseCode(0);
            response.setMsg("Failed to register.");
            return response;
        }
    }

    public void doUnregister() {
        String fileName = this.appName + "_" + this.terminalKey;
        File licenseFile = AndroidDevice.getLicenseFromCurrentDiectory(fileName);
        if (licenseFile == null) {
            licenseFile = AndroidDevice.getLicenseFromHomeDiectory(fileName);
        }
        this.setHasValidLicense(false);
        if (licenseFile == null || !licenseFile.exists()) {
            return;
        }
        licenseFile.delete();
        this.license = null;
    }

    public void setTerminal(Terminal mobileTerminal) {
        this.terminal = mobileTerminal;
    }
}

