/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class JsonBeanFieldExcluder
implements ExclusionStrategy {
    private Class<?> c;
    private String[] fieldNames;
    private List<Class> classes = new ArrayList<Class>();

    public JsonBeanFieldExcluder(Class ... clazz) throws SecurityException, NoSuchFieldException, ClassNotFoundException {
        for (Class class1 : clazz) {
            this.classes.add(class1);
        }
    }

    public boolean shouldSkipClass(Class<?> arg0) {
        if (this.classes != null && this.classes.contains(arg0)) {
            return true;
        }
        return this.c == arg0;
    }

    public boolean shouldSkipField(FieldAttributes f) {
        String fieldName = f.getName();
        Class theClass = f.getDeclaringClass();
        boolean duplicateProp = this.isFieldInSuperclass(theClass, fieldName);
        if (this.shouldSkipClass(f.getDeclaredClass()) || duplicateProp) {
            return true;
        }
        return f.getDeclaringClass() == this.c || this.fieldNames != null && this.escapeField(f.getName());
    }

    private boolean isFieldInSuperclass(Class<?> subclass, String fieldName) {
        return fieldName.equals("hashCode");
    }

    private Field getField(Class<?> theClass, String fieldName) {
        try {
            return theClass.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean escapeField(String f) {
        if (f.equals("hashCode")) {
            return true;
        }
        for (String fieldName : this.fieldNames) {
            if (!f.equals(fieldName)) continue;
            return true;
        }
        return false;
    }
}

