/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.Elements;
import com.orocube.rest.service.FloorStatus;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceListener;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.server.RestDataService;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class OroDataRequestHandler
extends Thread {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private Socket socket;
    private InputStream inputStream;
    private ServiceListener listener;

    public OroDataRequestHandler(Socket socket) throws Exception {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String request = "";
        try {
            this.inputStream = this.socket.getInputStream();
            byte[] length = new byte[5];
            this.inputStream.read(length);
            request = this.readData(this.inputStream, request, POSUtil.parseInteger(new String(length)));
            request = request.trim();
            PosResponse response = new PosResponse();
            Object data = this.buildResponse(request, response);
            String jsonResponseString = "";
            if (data instanceof Elements) {
                if (data != null) {
                    this.listener.terminalConnected(request);
                }
                response.setElements((Elements)data);
                jsonResponseString = ServiceUtils.getAsJsonString(response, true);
            } else if (data instanceof FloorStatus) {
                response.setFloorStatus((FloorStatus)data);
                response.setBrokerServerAddress(DataProvider.get().getStore().getProperty("mqtt_server_address"));
                jsonResponseString = ServiceUtils.convertToJson(response);
            } else if (data instanceof PosResponse) {
                response = (PosResponse)data;
                this.listener.terminalConnected(request);
                jsonResponseString = ServiceUtils.getAsJsonString(response);
            } else {
                if (data != null) {
                    String dataString = data.toString();
                    if (dataString != null && dataString.contains("-1")) {
                        this.listener.dataSetChanged(dataString);
                    }
                    this.listener.terminalConnected(dataString);
                    response.setData(dataString);
                }
                jsonResponseString = ServiceUtils.getAsJsonString(response);
            }
            this.writeResponse(jsonResponseString);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), "Error:" + e);
        }
        finally {
            try {
                if (request.contains("register")) {
                    this.listener.dataSetChanged("");
                }
                this.socket.close();
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), "Error:" + e);
            }
        }
    }

    private void writeResponse(String jsonResponseString) throws IOException {
        DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
        byte[] tosend = jsonResponseString.getBytes();
        dos.write(tosend, 0, tosend.length);
        dos.flush();
    }

    private String readData(InputStream inputStream, String data, int length) throws IOException {
        if (data.length() >= length) {
            return data;
        }
        byte[] b1 = new byte[length];
        IOUtils.read((InputStream)inputStream, (byte[])b1);
        data = data + new String(b1);
        return this.readData(inputStream, data, length);
    }

    private Object buildResponse(String request, PosResponse response) throws Exception {
        String reqMethod = StringUtils.substringBetween((String)request, (String)"<method>", (String)"</method>");
        if (StringUtils.isEmpty((String)reqMethod)) {
            response.setMsg("Invalid request method");
            return null;
        }
        Class<RestDataService> dataProvider = RestDataService.class;
        boolean match = false;
        for (Method method : dataProvider.getDeclaredMethods()) {
            Path pathParamAnnotation;
            Class<GET> methodAnnotationClass = GET.class;
            if (reqMethod.equals(POST)) {
                methodAnnotationClass = POST.class;
            }
            if (!method.isAnnotationPresent(methodAnnotationClass)) continue;
            Path pathParam = pathParamAnnotation = method.getAnnotation(Path.class);
            HashMap<String, String> valueMap = new HashMap<String, String>();
            String pathValue = pathParam.value();
            String[] splits = pathValue.split("/");
            if (splits.length > 0) {
                String reqPath = StringUtils.substringBetween((String)request, (String)"<path>", (String)"</path>");
                String[] splitedReqPaths = reqPath.split("/");
                for (int i = 0; i < splits.length; ++i) {
                    if (splitedReqPaths.length <= i) continue;
                    String path = splits[i];
                    String requestPath = splitedReqPaths[i];
                    if (path.startsWith("{")) {
                        valueMap.put(path, requestPath);
                        continue;
                    }
                    match = path.equals(requestPath);
                    if (!match) break;
                }
            }
            try {
                if (!match) continue;
                if (reqMethod.equals(POST)) {
                    String keys = StringUtils.substringBetween((String)request, (String)"<params>", (String)"</params>");
                    if (StringUtils.isNotEmpty((String)keys) && keys.equals("ticket")) {
                        String value = StringUtils.substringBetween((String)request, (String)"<value>", (String)"</value>");
                        if (value == null) {
                            return null;
                        }
                        if (!StoreUtil.isStoreOpen()) {
                            response.setResponseCode(9999);
                            response.setMsg("Store is closed");
                            return "Store is closed.";
                        }
                        List<Ticket> tickets = ServiceUtils.convertJsonToTicketList(value);
                        if (tickets == null) {
                            return null;
                        }
                        Object data = method.invoke(dataProvider.newInstance(), tickets);
                        response.setResponseCode(1);
                        response.setMsg("success");
                        return data;
                    }
                    JSONObject jsonObject = new JSONObject(keys);
                    Map params = new HashMap();
                    if (jsonObject.length() > 0) {
                        params = jsonObject.toMap();
                        valueMap.putAll(params);
                    }
                }
                Object data = method.invoke(dataProvider.newInstance(), valueMap.values().toArray());
                response.setResponseCode(1);
                response.setMsg("success");
                return data;
            }
            catch (Throwable ex) {
                response.setMsg("Error:" + ex.getMessage());
                PosLog.error(this.getClass(), ex.getMessage());
            }
        }
        if (!match) {
            response.setResponseCode(0);
            response.setMsg("Request not found");
        }
        return null;
    }

    public void setListener(ServiceListener listener) {
        this.listener = listener;
    }
}

