/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OroLicenseInfoDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.PluginFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class OroMobileLicenseActivationDialog
extends POSDialog {
    private String productName;
    private String productVersion;
    private static OroLicense license;
    private POSTextField tfTerminalKey;
    private String terminalKey;

    public OroMobileLicenseActivationDialog(String productName, String productVersion, String terminalKey) {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/icon.png")).getImage());
        this.productName = productName;
        this.productVersion = productVersion;
        this.terminalKey = terminalKey;
        this.setModal(true);
        this.init();
        this.initData();
    }

    private void initData() {
        if (StringUtils.isNotEmpty((String)this.terminalKey)) {
            this.tfTerminalKey.setText(this.terminalKey);
        }
    }

    private void init() {
        this.setTitle(String.valueOf(AppProperties.getAppName()) + " License Activation");
        this.setSize(600, 350);
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][grow][]", ""));
        JLabel lblActivationMsg = new JLabel("Please enter license to register your device");
        lblActivationMsg.setFont(new Font(lblActivationMsg.getFont().getName(), 1, 20));
        lblActivationMsg.setHorizontalAlignment(0);
        JLabel lblTerminalKey = new JLabel("Terminal key:");
        this.tfTerminalKey = new POSTextField();
        this.tfTerminalKey.setEditable(false);
        JButton btnCopy = new JButton("Copy");
        btnCopy.setPreferredSize(PosUIManager.getSize(70, 0));
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String terminalKey = OroMobileLicenseActivationDialog.this.tfTerminalKey.getText();
                if (StringUtils.isEmpty((String)terminalKey)) {
                    return;
                }
                StringSelection selection = new StringSelection(terminalKey);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        });
        this.add((Component)lblActivationMsg, "North");
        centerPanel.add((Component)lblTerminalKey, "align trailing");
        centerPanel.add((Component)this.tfTerminalKey, "growx");
        centerPanel.add((Component)btnCopy, "");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnSelectLicense = new PosButton("Select license");
        btnSelectLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OroMobileLicenseActivationDialog.this.doSelectLicense(PluginFileChooser.selectPluginFile((Component)Application.getPosWindow()));
            }
        });
        PosButton btnReqDemoLic = new PosButton("Request Demo License");
        buttonPanel.add((Component)btnReqDemoLic, "grow");
        btnReqDemoLic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    String terminalKey = OroMobileLicenseActivationDialog.this.tfTerminalKey.getText();
                    if (StringUtils.isEmpty((String)terminalKey)) {
                        return;
                    }
                    OroMobileLicenseActivationDialog.this.doReqDemoLicense(OroMobileLicenseActivationDialog.this.productName, OroMobileLicenseActivationDialog.this.productVersion, terminalKey);
                }
                catch (HttpHostConnectException e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Unable to connect host server. please try again later.");
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }
        });
        buttonPanel.add(btnReqDemoLic);
        buttonPanel.add((Component)btnSelectLicense, "grow");
        buttonPanel.add(new PosButton(new CloseDialogAction(this, "Exit")));
        this.add((Component)buttonPanel, "South");
    }

    protected void doReqDemoLicense(String productName, String productVersion, String terminalKey) throws Exception {
        String url = String.valueOf(AppConfig.getString("license.server.url", "https://orodev.net/lm")) + "/service/lm/androidDemoRequest";
        String emailAddress = PosOptionPane.showEmailInputDialog("Enter email address", "");
        if (emailAddress == null) {
            return;
        }
        if (StringUtils.isEmpty((String)emailAddress)) {
            POSMessageDialog.showMessage("Please enter email address");
            this.doReqDemoLicense(productName, productVersion, terminalKey);
            return;
        }
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        Matcher matcher = pattern.matcher(emailAddress);
        if (!matcher.matches()) {
            POSMessageDialog.showMessage("Please enter valid email address");
            this.doReqDemoLicense(productName, productVersion, terminalKey);
            return;
        }
        ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
        form.add(new BasicNameValuePair("customerName", "Demo User"));
        form.add(new BasicNameValuePair("customerEmail", emailAddress));
        form.add(new BasicNameValuePair("product", productName));
        form.add(new BasicNameValuePair("product_version", productVersion));
        form.add(new BasicNameValuePair("terminal_key", terminalKey));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, Consts.UTF_8);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
        if (httpResponse == null) {
            throw new Exception("Response not found!");
        }
        String getResult = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        if (StringUtils.isEmpty((String)getResult)) {
            throw new Exception("Error: result null or empty!");
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(getResult));
        JsonObject readObject = reader.readObject();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String errorMessage = readObject.getString("message");
            throw new Exception("Error: " + errorMessage);
        }
        JsonValue jsonValue = (JsonValue)readObject.get((Object)"content");
        String product = readObject.getString("product");
        if (jsonValue == null) {
            throw new Exception("No content found!");
        }
        String pathName = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator;
        pathName = String.valueOf(pathName) + product + "_" + terminalKey + ".lic";
        File pluginFile = new File(pathName);
        byte[] decodedContent = Base64.decodeBase64((String)jsonValue.toString());
        FileUtils.writeByteArrayToFile((File)pluginFile, (byte[])decodedContent);
        this.doSelectLicense(pluginFile);
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
    }

    private void doSelectLicense(File licenseFile) {
        if (licenseFile == null) {
            return;
        }
        try {
            license = LicenseUtil.loadAndValidate((File)licenseFile, (String)this.productName, (String)this.productVersion, (String)this.terminalKey);
            if (this.isValidLicense()) {
                LicenseUtil.copyLicenseFile((File)licenseFile, (String)(String.valueOf(this.productName) + "_" + this.terminalKey));
                this.setLicense(license);
                this.showLicenseInfo();
                this.dispose();
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "License invalid");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "License is invalid, Please select valid license.");
        }
    }

    private void showLicenseInfo() {
        try {
            OroLicenseInfoDialog licenseInfoDialog = new OroLicenseInfoDialog(license);
            licenseInfoDialog.setSize(PosUIManager.getSize(500, 500));
            licenseInfoDialog.setLocationRelativeTo(null);
            licenseInfoDialog.setVisible(true);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public static OroLicense showDialog(String productName, String productVersion, String terminalKey) {
        OroMobileLicenseActivationDialog dialog = new OroMobileLicenseActivationDialog(productName, productVersion, terminalKey);
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        return license;
    }

    public boolean isValidLicense() {
        if (license != null) {
            return license.isValid();
        }
        return false;
    }

    public OroLicense getLicense() {
        return license;
    }

    public void setLicense(OroLicense license) {
        OroMobileLicenseActivationDialog.license = license;
    }
}

