/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.OroDataRequestHandler;
import com.orocube.rest.service.ServiceListener;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;

public class OroService
implements Runnable {
    private static final int PORT = 6565;
    private ServerSocket ss = null;
    private static ServiceListener listener;

    public void startService() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            PosLog.info(this.getClass(), "listening on ...6565");
            if (listener != null) {
                listener.serviceStarted(6565);
            }
            this.ss = new ServerSocket(6565);
            OroService.startListening(this.ss);
        }
        catch (BindException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Service already running.");
            System.exit(0);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        finally {
            if (this.ss != null) {
                try {
                    this.ss.close();
                }
                catch (IOException e) {
                    PosLog.error(this.getClass(), e.getMessage());
                }
            }
        }
    }

    static void startListening(ServerSocket ss) throws Exception {
        while (true) {
            PosLog.info(OroService.class, "Waiting For Connections....");
            Socket s = ss.accept();
            OroDataRequestHandler handler = new OroDataRequestHandler(s);
            handler.setListener(listener);
            handler.start();
        }
    }

    public static void main(String[] args) {
        OroService service = new OroService();
        service.startService();
    }

    public void stopService() {
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (IOException e) {
                PosLog.error(this.getClass(), e.getMessage());
            }
        }
        listener.serviceStopped();
    }

    public boolean isRunning() {
        if (this.ss == null) {
            return false;
        }
        return !this.ss.isClosed();
    }

    public void setListener(ServiceListener listener) {
        OroService.listener = listener;
    }
}

