/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.PosResponse;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class ServiceUtils {
    public static String convertToJson(Object element) throws Exception {
        if (element == null) {
            return "";
        }
        String resp = "";
        try {
            System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            JAXBContext messageContext = JAXBContext.newInstance((Class[])new Class[]{element.getClass()});
            Marshaller marshaller = messageContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            marshaller.setProperty("eclipselink.json.include-root", (Object)true);
            StringWriter dataWriter = new StringWriter();
            marshaller.marshal(element, (Writer)dataWriter);
            resp = dataWriter.toString();
            return resp;
        }
        catch (Exception e) {
            PosLog.error(ServiceUtils.class, e);
            return "";
        }
    }

    public static String getAsJsonString(PosResponse element) throws Exception {
        return ServiceUtils.getAsJsonString(element, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
    }

    public static String getAsJsonString(PosResponse element, boolean excludeCashDrawer) throws Exception {
        if (excludeCashDrawer) {
            return ServiceUtils.getAsJsonString(element, CashDrawer.class, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
        }
        return ServiceUtils.getAsJsonString(element, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
    }

    public static String getAsJsonString(PosResponse element, Class ... exclusionClasses) throws Exception {
        if (element == null) {
            return "";
        }
        try {
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(exclusionClasses)}).create();
            String json = gson.toJson((Object)element);
            return json;
        }
        catch (Exception ex) {
            PosLog.error(ServiceUtils.class, ex);
            return "";
        }
    }

    public static String convertTicketsToJson(Object tickets) throws Exception {
        if (tickets == null) {
            return "";
        }
        try {
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(User.class, StoreSession.class, Terminal.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class)}).create();
            String json = gson.toJson(tickets);
            return json;
        }
        catch (Exception ex) {
            PosLog.error(ServiceUtils.class, ex);
            return "";
        }
    }

    public static Ticket convertToObject(String element) throws Exception {
        if (element == null) {
            return null;
        }
        String resp = "";
        try {
            System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            JAXBContext messageContext = JAXBContext.newInstance((Class[])new Class[]{element.getClass()});
            Unmarshaller unmarshaller = messageContext.createUnmarshaller();
            StringReader reader = new StringReader(element);
            Ticket ticket = (Ticket)unmarshaller.unmarshal((Reader)reader);
            return ticket;
        }
        catch (Exception e) {
            PosLog.error(ServiceUtils.class, e);
            return null;
        }
    }

    public static String convertImageIconToString(ImageIcon imageIcon) {
        String imageString = "";
        if (imageIcon != null) {
            try {
                Image image = imageIcon.getImage();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D bGr = bufferedImage.createGraphics();
                bGr.drawImage(image, 0, 0, null);
                bGr.dispose();
                File outputfile = new File("saved.png");
                ImageIO.write((RenderedImage)bufferedImage, "png", outputfile);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                baos.flush();
                byte[] byteArray = baos.toByteArray();
                byte[] encoded_data = Base64.encodeBase64((byte[])byteArray);
                imageString = new String(encoded_data);
                baos.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return imageString;
    }

    public static List<Integer> convertJsonToIntList(String request, String key) {
        try {
            JSONObject jsonObj = new JSONObject(request);
            String valueString = String.valueOf(jsonObj.get(key));
            return ServiceUtils.convertStringArrayToList(valueString);
        }
        catch (Exception e) {
            PosLog.error(ServiceUtils.class, e);
            return null;
        }
    }

    public static List<Ticket> convertJsonToTicketList(String request) {
        try {
            if (request == null) {
                return null;
            }
            ArrayList<Ticket> tickets = new ArrayList<Ticket>();
            JSONArray jsonArray = new JSONArray(request);
            for (int i = 0; i < jsonArray.length(); ++i) {
                Ticket ticket;
                List<TicketItemModifier> ticketItemModifiers;
                JSONObject json = jsonArray.getJSONObject(i);
                HashMap<String, ArrayList<TicketItemModifier>> ticketItemModifierMap = new HashMap<String, ArrayList<TicketItemModifier>>();
                if (json.has("ticketItemModifiers")) {
                    JSONArray ticketItemModifierJson = json.getJSONArray("ticketItemModifiers");
                    for (int tm = 0; tm < ticketItemModifierJson.length(); ++tm) {
                        JSONObject modifierJson = ticketItemModifierJson.getJSONObject(tm);
                        TicketItemModifier ticketItemModifier = (TicketItemModifier)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(modifierJson.toString(), TicketItemModifier.class);
                        if (ticketItemModifier.getTicketItem() == null) continue;
                        ticketItemModifiers = (ArrayList<TicketItemModifier>)ticketItemModifierMap.get(ticketItemModifier.getTicketItem().getId());
                        if (ticketItemModifiers == null) {
                            ticketItemModifiers = new ArrayList<TicketItemModifier>();
                            ticketItemModifierMap.put(ticketItemModifier.getTicketItem().getId(), (ArrayList<TicketItemModifier>)ticketItemModifiers);
                        }
                        ticketItemModifiers.add(ticketItemModifier);
                    }
                }
                if ((ticket = (Ticket)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(json.toString(), Ticket.class)) == null) continue;
                ticket.convertDiscountPropertyToList();
                ArrayList<TicketItem> ticketItems = new ArrayList<TicketItem>();
                for (TicketItem ticketItem : ticket.getTicketItems()) {
                    ticketItemModifiers = (List)ticketItemModifierMap.get(ticketItem.getId());
                    if (ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
                        ModifiableTicketItem modifiableTicketItem = new ModifiableTicketItem(ticketItem.getId());
                        try {
                            PropertyUtils.copyProperties((Object)modifiableTicketItem, (Object)ticketItem);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        modifiableTicketItem.setId(ticketItem.getId());
                        modifiableTicketItem.setTicketItemModifiers(ticketItemModifiers);
                        ticketItems.add(modifiableTicketItem);
                        continue;
                    }
                    ticketItems.add(ticketItem);
                }
                ticket.setTicketItems(ticketItems);
                tickets.add(ticket);
            }
            return tickets;
        }
        catch (Exception e) {
            e.printStackTrace();
            PosLog.error(ServiceUtils.class, e);
            return null;
        }
    }

    public static List<ShopTableStatus> convertJsonToShopTableStatusList(String request) {
        try {
            if (request == null) {
                return null;
            }
            ArrayList<ShopTableStatus> shopTableStatusList = new ArrayList<ShopTableStatus>();
            JSONArray jsonArray = new JSONArray(request);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                ShopTableStatus shopTableStatus = (ShopTableStatus)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(json.toString(), ShopTableStatus.class);
                if (shopTableStatus == null) continue;
                shopTableStatusList.add(shopTableStatus);
            }
            return shopTableStatusList;
        }
        catch (Exception e) {
            e.printStackTrace();
            PosLog.error(ServiceUtils.class, e);
            return null;
        }
    }

    public static ModifiableTicketItem covertToModifiableTicketItem(TicketItem ticketItem) {
        try {
            ModifiableTicketItem newTicketItem = new ModifiableTicketItem();
            newTicketItem.setId(ticketItem.getId());
            newTicketItem.setVersion(ticketItem.getVersion());
            newTicketItem.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
            newTicketItem.setQuantity(ticketItem.getQuantity());
            newTicketItem.setTicket(ticketItem.getTicket());
            newTicketItem.setUnitPrice(ticketItem.getUnitPrice());
            newTicketItem.setUnitName(ticketItem.getUnitName());
            newTicketItem.setTicketItemModifiers(ticketItem.getTicketItemModifiers());
            newTicketItem.setTaxes(ticketItem.getTaxes());
            newTicketItem.setTaxIncluded(ticketItem.isTaxIncluded());
            newTicketItem.setCourseId(ticketItem.getCourseId());
            newTicketItem.setCourseName(ticketItem.getCourseName());
            newTicketItem.setMenuItemId(ticketItem.getId());
            newTicketItem.setComboItem(ticketItem.isComboItem());
            newTicketItem.setPizzaType(ticketItem.isPizzaType());
            newTicketItem.setFractionalUnit(ticketItem.isFractionalUnit());
            newTicketItem.setName(ticketItem.getName());
            newTicketItem.setGroupId(ticketItem.getGroupId());
            newTicketItem.setGroupName(ticketItem.getGroupName());
            newTicketItem.setCategoryName(ticketItem.getCategoryName());
            newTicketItem.setCategoryId(ticketItem.getCategoryId());
            newTicketItem.setServiceChargeApplicable(ticketItem.isServiceChargeApplicable());
            newTicketItem.setServiceChargeRate(ticketItem.getServiceCharge());
            newTicketItem.setTaxOnServiceCharge(ticketItem.isTaxOnServiceCharge());
            newTicketItem.setUnitCost(ticketItem.getUnitCost());
            newTicketItem.setInventoryItem(ticketItem.isInventoryItem());
            newTicketItem.setShouldPrintToKitchen(ticketItem.isShouldPrintToKitchen());
            newTicketItem.setBeverage(ticketItem.isBeverage());
            newTicketItem.setPrinterGroup(ticketItem.getPrinterGroup());
            newTicketItem.setShouldPrintToKitchen(ticketItem.isShouldPrintToKitchen());
            newTicketItem.setPrintKitchenSticker(ticketItem.isPrintKitchenSticker());
            newTicketItem.setDiscounts(ticketItem.getDiscounts());
            return newTicketItem;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Integer> convertStringArrayToList(String stringArray) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (stringArray != null) {
            stringArray = stringArray.replace("[", "").replace("]", "").replaceAll("\"", Matcher.quoteReplacement(""));
            String[] splitedTables = stringArray.split(",");
            for (int i = 0; i < splitedTables.length; ++i) {
                Integer integerValue = Integer.valueOf(splitedTables[i]);
                list.add(integerValue);
            }
        }
        return list;
    }

    public static String createPosResponseAsString(List<Ticket> tickets) throws Exception {
        PosResponse reponse = ServiceUtils.createPosResponse(tickets);
        String jsonResponse = ServiceUtils.convertTicketsToJson(reponse);
        return jsonResponse;
    }

    public static PosResponse createPosResponse(List<Ticket> tickets) {
        PosResponse reponse = new PosResponse();
        reponse.setResponseCode(1);
        reponse.setRequest("Ticket Notification");
        reponse.setMsg((tickets.size() == 1 ? "1 ticket" : tickets.size() + "tickets") + " has been updated.");
        reponse.setDeviceId(TerminalUtil.getSystemUID());
        reponse.setTickets(tickets);
        for (Ticket ticket : tickets) {
            Terminal terminal;
            TicketDAO.getInstance().loadFullTicket(ticket);
            Set<PosTransaction> transactions = ticket.getTransactions();
            if (transactions != null && transactions.size() > 0) {
                for (PosTransaction posTransaction : transactions) {
                    posTransaction.setTicket(null);
                }
            }
            OrderType orderType = ticket.getOrderType();
            orderType.setDepartments(null);
            orderType.setCategories(null);
            orderType.setTerminalTypes(null);
            Outlet outlet = ticket.getOutlet();
            if (outlet != null) {
                outlet.setDepartments(null);
            }
            if ((terminal = ticket.getTerminal()) != null) {
                terminal.setOutlet(null);
                terminal.setCurrentCashDrawer(null);
                terminal.setTerminalType(null);
            }
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                List<TicketItemModifier> modifiers;
                ticketItem.setTicket(null);
                ticketItem.setMenuItem(new MenuItem(ticketItem.getMenuItemId()));
                List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
                if (discounts != null && discounts.size() > 0) {
                    for (TicketItemDiscount ticketItemDiscount : discounts) {
                        ticketItemDiscount.setTicketItem(null);
                    }
                }
                if ((modifiers = ticketItem.getTicketItemModifiers()) == null || modifiers.size() <= 0) continue;
                for (TicketItemModifier ticketItemModifier : modifiers) {
                    ticketItemModifier.setTicketItem(null);
                }
            }
        }
        return reponse;
    }

    public static String getHostAddress() throws UnknownHostException, SocketException {
        String mqttServerAddress = Application.getInstance().getStore().getProperty("mqtt_server_address");
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!inetAddress.isSiteLocalAddress()) continue;
                String hostAddress = inetAddress.getHostAddress();
                if (mqttServerAddress == null || !mqttServerAddress.contains(hostAddress)) continue;
                return hostAddress;
            }
        }
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static List<String> getLocalIPAddressList() throws UnknownHostException, SocketException {
        ArrayList<String> ipAddressList = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!inetAddress.isSiteLocalAddress()) continue;
                ipAddressList.add(inetAddress.getHostAddress());
            }
        }
        return ipAddressList;
    }
}

