/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.util.StoreUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.Elements;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.server.RestDataService;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationServiceUtils {
    public static final String DATA_UPDATE_NOTIFICATION = "Data Update Notification";
    public static final String TICKET_NOTIFICATION = "Ticket Notification";
    public static final String RECEIPT_PRINT_NOTIFICATION = "Receipt Print Notification";
    public static final String KITCHEN_PRINT_NOTIFICATION = "Kitchen Print Notification";
    public static final String RECEIPT_AND_KITCHEN_PRINT_NOTIFICATION = "Receipt & Kitchen Print Notification";
    public static final String TABLE_NOTIFICATION = "Table Notification";
    public static final String CASH_DRAWER_NOTIFICATION = "Cash Drawer Notification";

    public static void notificationReceived(JSONObject jsonMsg) {
        String request;
        if (!jsonMsg.has("request")) {
            return;
        }
        switch (request = jsonMsg.getString("request")) {
            case "Ticket Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jsonMsg);
                break;
            }
            case "Receipt Print Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jsonMsg, true, false);
                break;
            }
            case "Kitchen Print Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jsonMsg, false, true);
                break;
            }
            case "Receipt & Kitchen Print Notification": {
                NotificationServiceUtils.convertAndSaveAsTicket(jsonMsg, true, true);
                break;
            }
            case "Table Notification": {
                NotificationServiceUtils.convertAndSaveAsShopTableStatus(jsonMsg);
                break;
            }
            case "Cash Drawer Notification": {
                NotificationServiceUtils.convertAndSaveCashDrawers(jsonMsg);
            }
        }
    }

    public static void publishDrawerClosed(CashDrawer cashDrawer) {
        ArrayList<CashDrawer> drawers = new ArrayList<CashDrawer>();
        drawers.add(cashDrawer);
        NotificationServiceUtils.pulishDrawers(drawers);
    }

    public static void publishDrawerOpened(CashDrawer cashDrawer) {
        ArrayList<CashDrawer> drawers = new ArrayList<CashDrawer>();
        drawers.add(cashDrawer);
        NotificationServiceUtils.pulishDrawers(drawers);
    }

    public static void pulishDrawers(List<CashDrawer> drawers) {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            if (drawers != null && drawers.size() > 0) {
                for (CashDrawer cashDrawer : drawers) {
                    cashDrawer.setTransactions(null);
                    ids.add(cashDrawer.getId());
                }
                String jsonResponse = NotificationServiceUtils.convertCashDrawersToJson(drawers);
                OroMqttClient.getInstance().publishOnThread("mobile_notification", jsonResponse);
            }
        }
        catch (Exception e2) {
            PosLog.error(NotificationServiceUtils.class, e2);
        }
    }

    public static void pulishTicket(final String ticketId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<Ticket> tickets = new ArrayList<Ticket>();
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(ticketId);
                tickets.add(ticket);
                NotificationServiceUtils.pulishTickets(tickets);
            }
        }).start();
    }

    public static void pulishTickets(List<Ticket> tickets) {
        try {
            if (tickets != null && tickets.size() > 0) {
                for (Ticket ticket : tickets) {
                    ticket.setDiscounts(null);
                }
                String jsonResponse = ServiceUtils.createPosResponseAsString(tickets);
                OroMqttClient.getInstance().publishData("mobile_notification", jsonResponse);
            }
        }
        catch (Exception e2) {
            PosLog.error(NotificationServiceUtils.class, e2);
        }
    }

    public static void publishUpdatedData() {
        RestDataService service = new RestDataService();
        List<Terminal> mobileTerminals = TerminalDAO.getInstance().findTerminalsByDeviceType(1, 1);
        if (mobileTerminals == null || mobileTerminals.isEmpty()) {
            return;
        }
        try {
            Elements elements = service.getDataList(mobileTerminals.get(0).getTerminalKey());
            elements.setTerminal(null);
            PosResponse response = PosResponse.create(1, "Data has been updated");
            response.setRequest(DATA_UPDATE_NOTIFICATION);
            response.setElements(elements);
            String jsonResponseString = ServiceUtils.getAsJsonString(response, true);
            OroMqttClient.getInstance().publishData("mobile_notification", jsonResponseString);
        }
        catch (Exception e) {
            PosLog.error(NotificationServiceUtils.class, e);
        }
    }

    public static void convertAndSaveAsTicket(JSONObject rootElement) {
        NotificationServiceUtils.convertAndSaveAsTicket(rootElement, false, false);
    }

    public static void convertAndSaveAsTicket(JSONObject rootElement, boolean receiptPrint, boolean kitchenPrint) {
        try {
            JSONArray tickets = rootElement.getJSONArray("tickets");
            String deviceId = null;
            if (rootElement.has("deviceId")) {
                deviceId = rootElement.getString("deviceId");
            }
            List<Ticket> ticketList = ServiceUtils.convertJsonToTicketList(tickets.toString());
            RestDataService service = new RestDataService();
            service.saveOrUpdateTickets(ticketList, receiptPrint, kitchenPrint, deviceId);
        }
        catch (Exception ex) {
            PosLog.error(ServiceUtils.class, ex);
        }
    }

    private static void convertAndSaveCashDrawers(JSONObject rootElement) {
        try {
            JSONArray data = rootElement.getJSONArray("data");
            if (data != null && data.length() > 0) {
                for (int i = 0; i < data.length(); ++i) {
                    JSONObject jsonObject = data.getJSONObject(i);
                    Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create();
                    CashDrawer sourceCashDrawer = (CashDrawer)gson.fromJson(jsonObject.toString(), CashDrawer.class);
                    if (sourceCashDrawer == null) continue;
                    sourceCashDrawer.setStoreOperationData(StoreUtil.getCurrentStoreSession());
                    CashDrawer existingCashDrawer = CashDrawerDAO.getInstance().get(sourceCashDrawer.getId());
                    if (existingCashDrawer == null) {
                        CashDrawerDAO.getInstance().save(sourceCashDrawer);
                        NotificationServiceUtils.updateTerminal(sourceCashDrawer.getTerminalId(), sourceCashDrawer.getAssignedUser(), sourceCashDrawer);
                        existingCashDrawer = sourceCashDrawer;
                    }
                    if (!sourceCashDrawer.isClosed()) continue;
                    existingCashDrawer.setClosedBy(sourceCashDrawer.getClosedBy());
                    existingCashDrawer.setReportTime(sourceCashDrawer.getReportTime());
                    CashDrawerDAO.getInstance().update(sourceCashDrawer);
                    NotificationServiceUtils.updateTerminal(sourceCashDrawer.getTerminalId(), null, null);
                }
            }
        }
        catch (Exception e) {
            PosLog.error(ServiceUtils.class, e);
        }
    }

    private static void updateTerminal(Integer terminalId, User assignedUser, CashDrawer currentCashDrawer) {
        Terminal terminal = TerminalDAO.getInstance().get(terminalId);
        if (terminal != null) {
            terminal.setAssignedUser(assignedUser);
            terminal.setCurrentCashDrawer(currentCashDrawer);
            terminal.setActive(true);
            TerminalDAO.getInstance().saveOrUpdate(terminal);
        }
    }

    public static void convertAndSaveAsShopTableStatus(JSONObject rootElement) {
        try {
            JSONArray statusList = rootElement.getJSONArray("shopTableStatusList");
            List<ShopTableStatus> tableStatusList = ServiceUtils.convertJsonToShopTableStatusList(statusList.toString());
            RestDataService service = new RestDataService();
            service.saveOrUpdateShopTableStatus(tableStatusList);
        }
        catch (Exception ex) {
            PosLog.error(ServiceUtils.class, ex);
        }
    }

    public static String convertCashDrawersToJson(List<CashDrawer> cashDrawers) throws Exception {
        PosResponse reponse = new PosResponse();
        reponse.setResponseCode(1);
        reponse.setRequest(CASH_DRAWER_NOTIFICATION);
        reponse.setMsg((cashDrawers.size() == 1 ? "1 cash drawer" : cashDrawers.size() + "cash drawers") + " has been updated.");
        reponse.setDeviceId(TerminalUtil.getSystemUID());
        reponse.setData(cashDrawers);
        return ServiceUtils.getAsJsonString(reponse);
    }
}

