/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.orocube.common.util.TerminalUtil;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class OroMqttClient
implements MqttCallbackExtended {
    private MqttClient oroMqttClient;
    private int qos = 0;
    private static OroMqttClient instance;
    private String storeUniqueId;
    private String deviceId;

    private OroMqttClient(String deviceId) {
        this.deviceId = deviceId;
    }

    public static OroMqttClient getInstance() {
        return OroMqttClient.getInstance(TerminalUtil.getSystemUID());
    }

    public static OroMqttClient getInstance(String deviceId) {
        if (instance == null) {
            instance = new OroMqttClient(deviceId);
        }
        return instance;
    }

    public MqttClient getMqttClient() {
        return OroMqttClient.getInstance().oroMqttClient;
    }

    public boolean isConnectedToServer() {
        return this.oroMqttClient.isConnected();
    }

    public void initMqttClient() throws Exception {
        this.initMqttClient((MqttCallback)this);
    }

    public void initMqttClient(MqttCallback callBack) throws Exception {
        String serverAddress = "tcp://oroposcloud.com:1883";
        this.oroMqttClient = new MqttClient(serverAddress, this.deviceId == null ? TerminalUtil.getSystemUID() : this.deviceId, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(false);
        connOpts.setConnectionTimeout(2000);
        connOpts.setAutomaticReconnect(true);
        connOpts.setKeepAliveInterval(120);
        this.oroMqttClient.setCallback(callBack);
        this.oroMqttClient.connect(connOpts);
    }

    public void subscribe() throws Exception {
        Application application = Application.getInstance();
        String storeUUID = "";
        Store store = application.getStore();
        if (application != null && store != null) {
            storeUUID = store.getUuid();
        }
        this.storeUniqueId = String.valueOf(AppConfig.getString("store_uuid", storeUUID)) + "/";
        this.oroMqttClient.subscribe(String.valueOf(this.storeUniqueId) + "pos_notification", this.qos);
        this.oroMqttClient.subscribe(String.valueOf(this.storeUniqueId) + "mobile_notification", this.qos);
        Application.getInstance().getUpdateManager().subscribeToUpdateService(this, this.storeUniqueId);
    }

    public void subscribe(String topic, int qos, IMqttMessageListener messageListener) throws Exception {
        this.oroMqttClient.subscribe(topic, qos, messageListener);
    }

    protected void showMqttNotification(String msg) {
        PosLog.info(this.getClass(), msg);
    }

    public void publishOnThread(final String topic, final String msg) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OroMqttClient.this.publishData(topic, msg);
            }
        }).start();
    }

    public void publishData(String topic, String msg) {
        try {
            if (!this.isConnectedToServer()) {
                return;
            }
            MqttMessage message = new MqttMessage();
            message.setPayload(msg.getBytes());
            this.oroMqttClient.publish(String.valueOf(this.storeUniqueId) + topic, msg.getBytes(), this.qos, false);
        }
        catch (Exception me) {
            PosLog.error(this.getClass(), me);
        }
    }

    protected void debug(String msg) {
        PosLog.debug(OroMqttClient.class, msg);
    }

    public void connectionLost(Throwable cause) {
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        try {
            this.subscribe();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

