/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.server;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserPermissionDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.teminaltype.TerminalCategory;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.AndroidDevice;
import com.orocube.rest.service.BeanItem;
import com.orocube.rest.service.Elements;
import com.orocube.rest.service.FloorStatus;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

@Path(value="data")
public class RestDataService {
    private static final String SUCCESS = "success";

    @GET
    @Path(value="checkConnection/{request}")
    @Produces(value={"text/plain"})
    public PosResponse checkConnection(@PathParam(value="request") String request) {
        AndroidDevice androidDevice = AndroidDevice.build(request);
        if (!androidDevice.hasAccessPermission()) {
            return PosResponse.create(901, "Terminal not registered.");
        }
        PosResponse reponse = PosResponse.create(1, "1111");
        reponse.setBrokerServerAddress(DataProvider.get().getStore().getProperty("mqtt_server_address"));
        reponse.setData(new Terminal(androidDevice.getTerminalId()));
        return reponse;
    }

    @GET
    @Path(value="register/{request}")
    @Produces(value={"text/plain"})
    public PosResponse register(@PathParam(value="request") String request) {
        AndroidDevice androidDevice = AndroidDevice.build(request);
        PosResponse response = null;
        if (androidDevice.isNewTerminal()) {
            return androidDevice.doRegister();
        }
        response = PosResponse.create(1, "Connected");
        response.setData(String.valueOf(androidDevice.getTerminalId()));
        return response;
    }

    @GET
    @Path(value="user/{userPassword}")
    @Produces(value={"application/json"})
    public User getUser(@PathParam(value="userPassword") String userPassword) {
        return UserDAO.getInstance().findUserBySecretKey(userPassword);
    }

    @GET
    @Path(value="store")
    @Produces(value={"application/json"})
    public List<Store> getStores(Elements elements) {
        try {
            List<Store> stores = StoreDAO.getInstance().findAll();
            if (stores != null && stores.size() > 0) {
                for (Store store : stores) {
                    elements.setBrokerServerAddress(store.getProperty("mqtt_server_address"));
                    store.setProperties(null);
                    store.setLoginScreenBackground(null);
                    store.setStoreLogo(null);
                }
            }
            return stores;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="getFloorStatus")
    @Produces(value={"text/plain"})
    public FloorStatus getFloorStatus() {
        List<ShopTableStatus> shopTableStatusList = ShopTableStatusDAO.getInstance().findAll();
        FloorStatus floorStatus = new FloorStatus();
        floorStatus.setTables(shopTableStatusList);
        return floorStatus;
    }

    @GET
    @Path(value="outlets")
    @Produces(value={"application/json"})
    public List<Outlet> getOutlets() {
        try {
            List<Outlet> outlets = OutletDAO.getInstance().findAll();
            if (outlets != null) {
                for (Outlet outlet : outlets) {
                    String taxGroupId = outlet.getTaxGroupId();
                    outlet.setDepartments(null);
                    outlet.setTaxGroup(null);
                    outlet.setTaxGroupId(taxGroupId);
                }
            }
            return outlets;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="userPermissions")
    @Produces(value={"application/json"})
    private List<UserPermission> getUserPermissoins() {
        List<UserPermission> userPermissionsList = UserPermissionDAO.getInstance().findAll();
        return userPermissionsList;
    }

    @GET
    @Path(value="userTypes")
    @Produces(value={"application/json"})
    private List<UserType> getUserTypes() {
        List<UserType> userTypeList = UserTypeDAO.getInstance().findAll();
        return userTypeList;
    }

    @GET
    @Path(value="orderTypes")
    @Produces(value={"application/json"})
    public List<OrderType> findOrderTypes() {
        try {
            return this.getOrderTypes(this.getTerminalType());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public List<User> getUsers() {
        try {
            List<User> users = UserDAO.getInstance().findAll();
            if (users != null) {
                for (User user : users) {
                    user.setPassword(user.getPasswordAsPlainText());
                    CashDrawer cashDrawer = user.getActiveDrawerPullReport();
                    if (cashDrawer != null) {
                        cashDrawer.setTransactions(null);
                    }
                    user.setLinkedUser(null);
                    user.setParentUser(null);
                }
            }
            return users;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="menuCategories")
    @Produces(value={"application/json"})
    public List<MenuCategory> findCategories() {
        try {
            return this.getMenuCategories(this.getTerminalType());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="menuGroups")
    @Produces(value={"application/json"})
    public List<MenuGroup> findMenuGroups() {
        try {
            List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().findAll();
            if (menuGroups != null && menuGroups.size() > 0) {
                for (MenuGroup menuGroup : menuGroups) {
                    menuGroup.setMenuPages(null);
                    String menuCategoryId = menuGroup.getMenuCategoryId();
                    menuGroup.setMenuCategory(null);
                    menuGroup.setMenuCategoryId(menuCategoryId);
                }
            }
            return menuGroups;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="modifierGroups")
    @Produces(value={"application/json"})
    public List<ModifierGroup> getModifierGroups() {
        try {
            List<ModifierGroup> modifierGroups = ModifierGroupDAO.getInstance().findAll();
            if (modifierGroups != null && modifierGroups.size() > 0) {
                for (ModifierGroup modifierGroup : modifierGroups) {
                    modifierGroup.setModifiers(null);
                }
            }
            return modifierGroups;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="modifiers")
    @Produces(value={"application/json"})
    public List<MenuModifier> getModifiers() {
        try {
            List<MenuModifier> modifiers = MenuModifierDAO.getInstance().findAll();
            if (modifiers != null && modifiers.size() > 0) {
                for (MenuModifier modifier : modifiers) {
                    MenuModifierDAO.getInstance().initialize(modifier);
                    modifier.setMultiplierPriceList(null);
                    modifier.setMenuItemModifierGroup(null);
                }
            }
            return modifiers;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="cookingInstructions")
    @Produces(value={"application/json"})
    public List<CookingInstruction> getCookingInstructions() {
        try {
            List<CookingInstruction> cookingInstructions = CookingInstructionDAO.getInstance().findAll();
            return cookingInstructions;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="discounts")
    @Produces(value={"application/json"})
    public List<Discount> getDiscounts() {
        try {
            List<Discount> discounts = DiscountDAO.getInstance().findAll();
            if (discounts != null && discounts.size() > 0) {
                for (Discount discount : discounts) {
                    discount.setMenuCategories(null);
                    discount.setMenuGroups(null);
                    ArrayList<String> menuItemIds = new ArrayList<String>();
                    List<MenuItem> menuItems = discount.getMenuItems();
                    if (menuItems != null && menuItems.size() > 0) {
                        for (MenuItem item : menuItems) {
                            menuItemIds.add(item.getId());
                        }
                    }
                    discount.setMenuItemIds(menuItemIds);
                    discount.setMenuItems(null);
                }
            }
            return discounts;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="menuItemModifierSpecs")
    @Produces(value={"application/json"})
    public List<MenuItemModifierSpec> getMenuItemModifierGroups() {
        try {
            List<MenuItemModifierSpec> modifierSpecs = MenuItemModifierSpecDAO.getInstance().findAll();
            if (modifierSpecs != null && modifierSpecs.size() > 0) {
                for (MenuItemModifierSpec modifierSpec : modifierSpecs) {
                    Set<MenuModifier> modifiers;
                    modifierSpec = MenuItemModifierSpecDAO.getInstance().initialize(modifierSpec);
                    modifierSpec.setDefaultModifierList(null);
                    modifierSpec.setModifierGroup(null);
                    Set<MenuItemModifierPage> pages = modifierSpec.getModifierPages();
                    if (pages != null && pages.size() > 0) {
                        for (MenuItemModifierPage menuItemModifierPage : pages) {
                            menuItemModifierPage.setModifierSpec(null);
                            List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
                            if (pageItems == null || pageItems.size() <= 0) continue;
                            for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                                menuItemModifierPageItem.setImageId(menuItemModifierPageItem.getMenuModifierId());
                                menuItemModifierPageItem.setParentPage(null);
                                menuItemModifierPageItem.setMenuModifierId(null);
                            }
                        }
                    }
                    if ((modifiers = modifierSpec.getModifiers()) == null || modifiers.size() <= 0) continue;
                    for (MenuModifier menuModifier : modifiers) {
                        MenuModifierDAO.getInstance().initialize(menuModifier);
                    }
                }
            }
            return modifierSpecs;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadItemSpecsRelation(Elements elements) {
        ArrayList<BeanItem> beanItems = new ArrayList<BeanItem>();
        Session session = TerminalDAO.getInstance().createNewSession();
        try {
            NativeQuery sqlQuery = session.createSQLQuery("select id,menuitem_id from MENUITEM_MODIFIERSPEC");
            List list = sqlQuery.list();
            if (list != null && list.size() > 0) {
                for (Object[] object : list) {
                    if (object.length <= 1) continue;
                    Object id = object[0];
                    Object parent = object[1];
                    if (id == null || parent == null) continue;
                    beanItems.add(new BeanItem(id.toString(), "", parent.toString()));
                }
            }
            elements.setMenuItemModifierSpecTables(beanItems);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        finally {
            TerminalDAO.getInstance().closeSession(session);
        }
        return null;
    }

    @GET
    @Path(value="taxes")
    @Produces(value={"application/json"})
    public List<TaxGroup> getTaxGroups() {
        try {
            return TaxGroupDAO.getInstance().findAll();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="menuItems/{request}")
    @Produces(value={"application/json"})
    public Elements findAll(@PathParam(value="request") String request) {
        try {
            return this.loadAllData(request);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @GET
    @Path(value="tickets/{ticketIds}")
    @Produces(value={"application/json"})
    public PosResponse getTickets(@PathParam(value="ticketIds") String ticketIds) {
        try {
            if (StringUtils.isNotEmpty((String)ticketIds)) {
                ArrayList<Ticket> tickets = new ArrayList<Ticket>();
                String[] ids = ticketIds.split(",");
                if (ids.length > 0) {
                    for (String ticketId : ids) {
                        Ticket ticket = TicketDAO.getInstance().get(ticketId);
                        if (ticket == null) continue;
                        tickets.add(ticket);
                    }
                }
                return ServiceUtils.createPosResponse(tickets);
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return null;
    }

    @POST
    @Path(value="table/occupy")
    @Produces(value={"application/json"})
    public String occupyTables(String tablNumbers) {
        return this.occupyTables(ServiceUtils.convertStringArrayToList(tablNumbers));
    }

    @POST
    @Path(value="table/release")
    @Produces(value={"application/json"})
    public String releaseTables(String tablNumbers) {
        return this.releaseTables(ServiceUtils.convertStringArrayToList(tablNumbers));
    }

    @POST
    @Path(value="ticket/save")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PosResponse saveTicket(List<Ticket> tickets) {
        try {
            PosResponse response = this.saveOrUpdateTickets(tickets, false, false);
            return response;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @POST
    @Path(value="tableStatus/save")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PosResponse saveOrUpdateShopTableStatus(List<ShopTableStatus> tableStatusList) {
        try {
            PosResponse response = this.saveOrUpdateShopTableStatusList(tableStatusList);
            return response;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @POST
    @Path(value="ticket/done")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PosResponse saveAndPrintTicket(List<Ticket> tickets) {
        try {
            return this.saveOrUpdateTickets(tickets, true, true);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @POST
    @Path(value="ticket/print")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PosResponse printAndSentTickets(List<Ticket> tickets) {
        try {
            return this.saveOrUpdateTickets(tickets, true, true);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @POST
    @Path(value="ticket/printReceipt")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PosResponse printTickets(List<Ticket> tickets) {
        try {
            return this.saveOrUpdateTickets(tickets, true, false);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @POST
    @Path(value="ticket/sentToKitchen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PosResponse setTicketsToKitchen(List<Ticket> tickets) {
        try {
            return this.saveOrUpdateTickets(tickets, false, true);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    @POST
    @Path(value="checkTicketVersion/{ticketId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getTicketVersion(@PathParam(value="ticketId") String ticketId) {
        try {
            TerminalDAO dao = TerminalDAO.getInstance();
            long version = dao.getVersion(Ticket.class, Ticket.PROP_ID, ticketId);
            return String.valueOf(version);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public Elements loadAllData(String reqeust) throws Exception {
        AndroidDevice androidDevice = AndroidDevice.build(reqeust);
        if (androidDevice.isNewTerminal() && androidDevice.doRegister().getResponseCode() == 0) {
            return null;
        }
        return this.getDataList(androidDevice.getTerminalKey());
    }

    public Elements getDataList(String terminalKey) {
        TerminalType terminalType = this.getTerminalType();
        Elements elements = new Elements();
        this.loadTerminal(elements, terminalKey);
        this.loadStore(elements);
        this.loadOutlets(elements);
        this.loadUsers(elements);
        this.loadUserPermission(elements);
        this.loadUserTypes(elements);
        this.loadOrderTypes(elements, terminalType);
        this.loadMenuItems(elements, terminalType);
        this.loadModifiers(elements);
        this.loadMenuItemModifierSpecs(elements);
        this.loadItemSpecsRelation(elements);
        this.loadSizeAndCrust(elements);
        elements.setDiscounts(this.getDiscounts());
        elements.setCookingInstructions(this.getCookingInstructions());
        this.loadShopTables(elements);
        elements.setFloorStatus(this.getFloorStatus());
        elements.setTaxGroups(this.getTaxGroups());
        return elements;
    }

    private void loadUserPermission(Elements elements) {
        try {
            List<UserPermission> userPermissionsList = this.getUserPermissoins();
            elements.setUserPermissions(userPermissionsList);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void loadUserTypes(Elements elements) {
        List<UserType> userTypeList = this.getUserTypes();
        elements.setUserTypes(userTypeList);
    }

    private void loadTerminal(Elements elements, String terminalKey) {
        try {
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(terminalKey);
            elements.setTerminal(terminal);
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(e);
        }
    }

    private void loadStore(Elements elements) {
        List<Store> stores = this.getStores(elements);
        elements.setStores(stores);
    }

    private void loadOutlets(Elements elements) {
        elements.setOutlets(this.getOutlets());
    }

    private void loadUsers(Elements elements) {
        elements.setUsers(this.getUsers());
    }

    private void loadOrderTypes(Elements elements, TerminalType terminalType) {
        List<OrderType> orderTypeList = this.getOrderTypes(terminalType);
        if (orderTypeList != null && orderTypeList.size() > 0) {
            for (OrderType orderType : orderTypeList) {
                orderType.setCategories(null);
                orderType.setDepartments(null);
                orderType.setTerminalTypes(null);
            }
            elements.setOrderTypes(orderTypeList);
        }
    }

    private List<OrderType> getOrderTypes(TerminalType terminalType) {
        List<OrderType> orderTypeList = null;
        if (terminalType != null) {
            orderTypeList = terminalType.getOrderTypes();
        }
        if (orderTypeList == null || orderTypeList.isEmpty()) {
            orderTypeList = OrderTypeDAO.getInstance().findAll();
        }
        if (orderTypeList != null) {
            for (OrderType orderType : orderTypeList) {
                orderType = OrderTypeDAO.getInstance().initialize(orderType);
            }
        }
        return orderTypeList;
    }

    private void loadMenuItems(Elements elements, TerminalType terminalType) {
        List<MenuCategory> menuCategoryList = this.getMenuCategories(terminalType);
        ArrayList<BeanItem> menuCategories = new ArrayList<BeanItem>();
        if (menuCategoryList != null) {
            for (MenuCategory category : menuCategoryList) {
                menuCategories.add(new BeanItem(category.getId(), category.getName()));
                this.loadMenuGroups(elements, category);
            }
            elements.setMenuCategories(menuCategories);
        }
    }

    private void loadMenuItemModifierSpecs(Elements elements) {
        elements.setMenuItemModifierSpecs(this.getMenuItemModifierGroups());
    }

    private void loadModifiers(Elements elements) {
        List<MenuModifier> modifiers = this.getModifiers();
        elements.setModifiers(modifiers);
    }

    private void loadSizeAndCrust(Elements elements) {
    }

    private List<MenuCategory> getMenuCategories(TerminalType terminalType) {
        List<MenuCategory> menuCategoryList = null;
        if (terminalType != null) {
            menuCategoryList = terminalType.getCategories();
        }
        if (menuCategoryList == null || menuCategoryList.isEmpty()) {
            menuCategoryList = MenuCategoryDAO.getInstance().findAll();
        }
        if (menuCategoryList != null && menuCategoryList.size() > 0) {
            for (MenuCategory menuCategory : menuCategoryList) {
                menuCategory.setMenuGroups(null);
                menuCategory.setDepartments(null);
                menuCategory.setMenuShifts(null);
                menuCategory.setOrderTypes(null);
                menuCategory.setTerminalTypes(null);
            }
        }
        return menuCategoryList;
    }

    private void loadMenuGroups(Elements elements, MenuCategory category) {
        List<MenuGroup> menuGroupList = MenuGroupDAO.getInstance().findByParent(category);
        if (menuGroupList != null) {
            ArrayList<BeanItem> menuGroups = new ArrayList<BeanItem>();
            for (MenuGroup menuGroup : menuGroupList) {
                menuGroups.add(new BeanItem(menuGroup.getId(), menuGroup.getName(), menuGroup.getMenuCategoryId()));
                this.loadMenuItems(elements, menuGroup);
            }
            elements.getMenuGroups().addAll(menuGroups);
        }
    }

    private void loadMenuItems(Elements elements, MenuGroup menuGroup) {
        List<MenuItem> menuItemList = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
        if (menuItemList != null) {
            ArrayList<BeanItem> menuItems = new ArrayList<BeanItem>();
            ArrayList<PizzaPrice> pizzaPrices = new ArrayList<PizzaPrice>();
            for (MenuItem menuItem : menuItemList) {
                BeanItem item = new BeanItem(menuItem.getId(), menuItem.getName(), menuItem.getMenuGroupId(), menuItem.getPrice(), ServiceUtils.convertImageIconToString(menuItem.getScaledImageIcon(200, 200)));
                item.setTaxGroupId(menuItem.getTaxGroupId());
                item.setHasModifier(menuItem.isHasModifiers());
                item.setHasMandatoryModifiers(menuItem.isHasMandatoryModifiers());
                item.setBarcode(menuItem.getBarcode());
                if (menuItem.isPizzaType().booleanValue()) {
                    MenuItemDAO.getInstance().initialize(menuItem);
                    List<PizzaPrice> pizzaPriceList = menuItem.getPizzaPriceList();
                    if (pizzaPriceList != null && pizzaPriceList.size() > 0) {
                        for (PizzaPrice pizzaPrice : pizzaPriceList) {
                            pizzaPrice.setItemId(menuItem.getId());
                        }
                        pizzaPrices.addAll(pizzaPriceList);
                    }
                    item.setShowTable(menuItem.isPizzaType());
                }
                menuItems.add(item);
            }
            elements.getMenuItems().addAll(menuItems);
        }
    }

    private void loadShopTables(Elements elements) {
        ArrayList<BeanItem> shopFloorsList = new ArrayList<BeanItem>();
        ArrayList<BeanItem> shopTableList = new ArrayList<BeanItem>();
        List<ShopFloor> shopFloors = ShopFloorDAO.getInstance().findAll();
        if (shopFloors != null) {
            for (ShopFloor shopFloor : shopFloors) {
                shopFloorsList.add(new BeanItem(shopFloor.getId(), shopFloor.getName(), null, null, ServiceUtils.convertImageIconToString(shopFloor.getImage())));
                List<ShopTable> shopTables = ShopTableDAO.getInstance().getByFloor(shopFloor);
                if (shopTables == null) continue;
                int buttonDefaultWidth = 90;
                int buttonDefaultHeight = 90;
                for (ShopTable table : shopTables) {
                    if (table.getFloor() == null) continue;
                    String name = table.getName();
                    Integer width = table.getWidth();
                    Integer height = table.getHeight();
                    if (width == null || width <= 0) {
                        width = buttonDefaultWidth;
                    }
                    if (height == null || height <= 0) {
                        height = buttonDefaultHeight;
                    }
                    shopTableList.add(new BeanItem(String.valueOf(table.getId()), name == null ? "" : name, shopFloor.getId(), table.getX(), table.getY(), width, height, table.getTicketId(), table.getTicketShortId(), table.getUserId(), table.getUserName()));
                }
                elements.setShopTables(shopTableList);
            }
            elements.setShopFloors(shopFloorsList);
        }
    }

    private TerminalType getTerminalType() {
        TerminalType terminalType = TerminalTypeDAO.getInstance().getTerminalType(TerminalCategory.TABLET);
        TerminalTypeDAO.getInstance().initialize(terminalType);
        return terminalType;
    }

    private String occupyTables(List<Integer> tableNumbers) {
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return "";
        }
        User currentUser = UserDAO.getInstance().findUserBySecretKey("1111");
        ArrayList<ShopTableStatus> tableStatusList = new ArrayList<ShopTableStatus>();
        for (Integer tableNumber : tableNumbers) {
            ShopTableStatus shopTable = ShopTableStatusDAO.getInstance().get(tableNumber);
            String userId = null;
            String userName = null;
            if (currentUser != null) {
                userId = currentUser.getId();
                userName = currentUser.getFirstName();
            }
            shopTable.setTableTicket(GlobalIdGenerator.generateGlobalId(), null, userId, userName);
            if (shopTable == null) continue;
            tableStatusList.add(shopTable);
        }
        if (tableStatusList != null) {
            ShopTableDAO.getInstance().bookedTables(tableStatusList);
        }
        return SUCCESS;
    }

    private String releaseTables(List<Integer> tableNumbers) {
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return "";
        }
        if (tableNumbers != null) {
            // empty if block
        }
        return SUCCESS;
    }

    public PosResponse saveOrUpdateTickets(List<Ticket> tickets, boolean printReceipt, boolean sentToKitchen) {
        return this.saveOrUpdateTickets(tickets, printReceipt, sentToKitchen, "");
    }

    public PosResponse saveOrUpdateTickets(List<Ticket> tickets, boolean printReceipt, boolean sentToKitchen, String terminalKey) {
        PosResponse response = new PosResponse();
        if (tickets == null || tickets.isEmpty()) {
            response.setResponseCode(0);
            response.setMsg("empty data");
            return response;
        }
        ArrayList<Ticket> printableTickets = new ArrayList<Ticket>();
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, CashDrawer> drawerMap = new HashMap<String, CashDrawer>();
        for (Ticket ticket : tickets) {
            this.saveOrUpdateTicket(printableTickets, ids, drawerMap, ticket);
            if (drawerMap.size() <= 0) continue;
            for (CashDrawer cashDrawer : drawerMap.values()) {
                if (cashDrawer.isOpen()) continue;
                CashDrawerReportService service = new CashDrawerReportService(cashDrawer);
                service.populateReport();
                CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer);
            }
        }
        Terminal requestedTerminal = null;
        if (printReceipt) {
            requestedTerminal = TerminalDAO.getInstance().getByTerminalKey(terminalKey);
            this.doPrintTicketsReceipt(printableTickets, requestedTerminal);
        }
        if (sentToKitchen) {
            this.doSentTicketsToKitchen(printableTickets, requestedTerminal);
        }
        response.setResponseCode(1);
        response.setMsg("saved");
        response.setData(((Object)ids).toString());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateTicket(List<Ticket> printableTickets, List<String> ids, Map<String, CashDrawer> drawerMap, Ticket ticket) {
        ticket.getDiscounts();
        Ticket existingTicket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        Session session = null;
        Transaction tx = null;
        try {
            Customer customer;
            boolean newTicket;
            session = TicketDAO.getInstance().createNewSession();
            tx = session.beginTransaction();
            boolean closed = ticket.isClosed();
            boolean bl = newTicket = existingTicket == null;
            if (newTicket) {
                existingTicket = ticket;
            } else {
                this.clearExistingTicket(existingTicket, session);
                long version = existingTicket.getVersion();
                int tokenNo = existingTicket.getTokenNo();
                try {
                    PropertyUtils.copyProperties((Object)existingTicket, (Object)ticket);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                existingTicket.setVersion(version);
                existingTicket.setTokenNo(tokenNo);
            }
            List<TicketItem> ticketItems = existingTicket.getTicketItems();
            for (TicketItem ticketItem : ticketItems) {
                ticketItem.setId(null);
                ticketItem.getDiscounts();
                ticketItem.getTaxes();
                if (ticketItem.getTicketItemModifiers() != null) {
                    for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                        ticketItemModifier.setId(null);
                        ticketItemModifier.setTicketItem(ticketItem);
                    }
                }
                ticketItem.setTicket(existingTicket);
            }
            if (ticket.getCustomer() != null && (customer = CustomerDAO.getInstance().get(ticket.getCustomerId())) == null) {
                session.save((Object)ticket.getCustomer());
            }
            Set<PosTransaction> posTransactions = ticket.getTransactions();
            HashSet<PosTransaction> newTransactions = new HashSet<PosTransaction>();
            if (posTransactions != null && posTransactions.size() > 0) {
                for (PosTransaction transaction : posTransactions) {
                    PosTransaction posTransaction = null;
                    PaymentType paymentType = transaction.getPaymentType();
                    String paymentTypeString = transaction.getPaymentTypeString();
                    if (paymentTypeString == null || paymentTypeString.equals(PaymentType.CASH.getDisplayString())) {
                        posTransaction = new CashTransaction();
                        posTransaction.setPaymentType(PaymentType.CASH);
                    } else if (paymentTypeString.equals(PaymentType.CREDIT_CARD.getDisplayString())) {
                        posTransaction = new CreditCardTransaction();
                        posTransaction.setPaymentType(PaymentType.CREDIT_CARD);
                    }
                    posTransaction.setPaymentType(paymentType);
                    posTransaction.setId(null);
                    posTransaction.setTicket(existingTicket);
                    posTransaction.setTerminalId(transaction.getTerminalId());
                    posTransaction.setUserId(transaction.getUserId());
                    posTransaction.setTransactionType(TransactionType.CREDIT.name());
                    String cashDrawerId = transaction.getCashDrawerId();
                    if (StringUtils.isNotEmpty((String)cashDrawerId)) {
                        CashDrawer existingCashDrawer = drawerMap.get(cashDrawerId);
                        if (existingCashDrawer == null && (existingCashDrawer = CashDrawerDAO.getInstance().get(cashDrawerId, session)) != null) {
                            drawerMap.put(existingCashDrawer.getId(), existingCashDrawer);
                        }
                        if (existingCashDrawer == null) {
                            this.createNewCashDrawer(session, transaction.getCashDrawer(), posTransaction);
                        }
                    }
                    posTransaction.setCashDrawerId(cashDrawerId);
                    posTransaction.setTransactionTime(new Date());
                    posTransaction.setCardExpMonth(transaction.getCardExpMonth());
                    posTransaction.setCardHolderName(transaction.getCardHolderName());
                    posTransaction.setCardAuthCode(transaction.getCardAuthCode());
                    posTransaction.setCardMerchantGateway(transaction.getCardMerchantGateway());
                    posTransaction.setCardNumber(transaction.getCardNumber());
                    posTransaction.setCardTrack(transaction.getCardTrack());
                    posTransaction.setCardTransactionId(transaction.getCardTransactionId());
                    posTransaction.setCardReader(transaction.getCardReader());
                    posTransaction.setCardType(transaction.getCardType());
                    posTransaction.setAmount(transaction.getAmount());
                    posTransaction.setTenderAmount(transaction.getTenderAmount());
                    posTransaction.setStoreSessionId(StoreUtil.getCurrentStoreSession().getId());
                    newTransactions.add(posTransaction);
                }
                existingTicket.setTransactions(newTransactions);
            } else {
                existingTicket.setTransactions(null);
            }
            existingTicket.setClosed(closed);
            existingTicket.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(existingTicket, session);
            printableTickets.add(existingTicket);
            ids.add(ticket.getId());
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            PosLog.error(this.getClass(), e);
        }
        finally {
            TicketDAO.getInstance().closeSession(session);
        }
        this.publishUpdatedTickets(printableTickets);
    }

    private void publishUpdatedTickets(final List<Ticket> printableTickets) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NotificationServiceUtils.pulishTickets(printableTickets);
            }
        }).start();
    }

    private void createNewCashDrawer(Session session, CashDrawer cashDrawer, PosTransaction posTransaction) {
        if (cashDrawer != null) {
            cashDrawer.setStoreOperationData(StoreUtil.getCurrentStoreSession());
            session.save((Object)cashDrawer);
        }
        Integer terminalId = posTransaction.getTerminalId();
        Terminal terminal = TerminalDAO.getInstance().get(terminalId, session);
        if (terminal != null && cashDrawer != null) {
            terminal.setAssignedUser(cashDrawer.getAssignedUser());
            terminal.setCurrentCashDrawer(cashDrawer);
            session.saveOrUpdate((Object)terminal);
        }
    }

    private PosResponse saveOrUpdateShopTableStatusList(List<ShopTableStatus> tableStatusList) {
        PosResponse response = new PosResponse();
        if (tableStatusList == null || tableStatusList.isEmpty()) {
            response.setResponseCode(0);
            response.setMsg("empty data");
            return response;
        }
        for (ShopTableStatus tableStatus : tableStatusList) {
            ShopTableStatus existingTableStatus = ShopTableStatusDAO.getInstance().get(tableStatus.getId());
            if (existingTableStatus == null) continue;
            try {
                long version = existingTableStatus.getVersion();
                PropertyUtils.copyProperties((Object)existingTableStatus, (Object)tableStatus);
                existingTableStatus.setVersion(version);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
            ShopTableStatusDAO.getInstance().saveOrUpdate(existingTableStatus);
        }
        response.setResponseCode(1);
        response.setMsg("saved");
        return response;
    }

    private void doPrintTicketsReceipt(List<Ticket> tickets, Terminal requestedTerminal) {
        if (tickets == null || tickets.isEmpty()) {
            return;
        }
        for (Ticket ticket : tickets) {
            try {
                ReceiptPrintService.printTicket(ticket, requestedTerminal);
            }
            catch (Exception exception) {}
        }
    }

    private void doSentTicketsToKitchen(List<Ticket> tickets, Terminal terminal) {
        if (tickets == null || tickets.isEmpty()) {
            return;
        }
        for (Ticket ticket : tickets) {
            OrderType orderType = ticket.getOrderType();
            if (orderType == null || !orderType.isShouldPrintToKitchen().booleanValue() || !ticket.needsKitchenPrint()) continue;
            try {
                ReceiptPrintService.printToKitchen(ticket);
            }
            catch (Exception exception) {}
        }
    }

    private void clearExistingTicket(Ticket existingTicket, Session session) {
        for (TicketItem ticketItem : existingTicket.getTicketItems()) {
            session.delete((Object)ticketItem);
        }
        if (existingTicket.getTransactions() != null) {
            for (PosTransaction transaction : existingTicket.getTransactions()) {
                session.delete((Object)transaction);
            }
        }
    }
}

