/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.DefaultCustomerListView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.EmailSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;

public abstract class EmailSendAction
extends PosAction {
    private Ticket a;

    public EmailSendAction() {
        super("EMAIL");
    }

    public abstract Ticket getTicket();

    @Override
    public void execute() {
        try {
            this.a = this.getTicket();
            if (this.a == null) {
                return;
            }
            Customer customer = this.a(this.a);
            if (customer == null) {
                return;
            }
            EmailSelectionDialog emailSelectionDialog = new EmailSelectionDialog(Messages.getString("EmailSendAction.0"), customer.getEmail(), customer.getEmail2()){

                @Override
                public boolean doSendEmail(String string) {
                    try {
                        MailService.sendTicket(string, EmailSendAction.this.a);
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EmailSendAction.1") + string + "\"");
                        return true;
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                        return false;
                    }
                }
            };
            emailSelectionDialog.pack();
            emailSelectionDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private Customer a(Ticket ticket) throws Exception {
        Customer customer = null;
        String string = ticket.getCustomerId();
        if (string == null) {
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("EmailSendAction.3"), Messages.getString("EmailSendAction.4"));
            if (n != 0) {
                return null;
            }
            CustomerSelectorDialog customerSelectorDialog = new CustomerSelectorDialog(new DefaultCustomerListView());
            customerSelectorDialog.setCreateNewTicket(false);
            customerSelectorDialog.updateView(true);
            customerSelectorDialog.openUndecoratedFullScreen();
            if (customerSelectorDialog.isCanceled()) {
                return null;
            }
            customer = customerSelectorDialog.getSelectedCustomer();
            if (customer != null) {
                ticket.setCustomer(customer);
                TicketDAO.getInstance().saveOrUpdate(ticket);
            }
        } else {
            customer = CustomerDAO.getInstance().get(string);
        }
        return customer;
    }
}

