/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.SeatSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import java.util.ArrayList;
import java.util.List;

public class SeatSelectionAction
extends PosAction {
    private PosButton a;

    public SeatSelectionAction() {
        super("SEAT");
    }

    public void setSource(PosButton posButton) {
        this.a = posButton;
    }

    @Override
    public void execute() {
        this.doAddSeatNumber();
    }

    protected void doAddSeatNumber() {
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        SeatSelectionDialog seatSelectionDialog = new SeatSelectionDialog(ticket, this.getSeatNumbers(ticket));
        seatSelectionDialog.setTitle(Messages.getString("OrderView.12"));
        seatSelectionDialog.pack();
        seatSelectionDialog.open();
        if (seatSelectionDialog.isCanceled()) {
            return;
        }
        int n = seatSelectionDialog.getSeatNumber();
        if (n == -1) {
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("OrderView.13"));
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
        }
        this.a.setText(Messages.getString("OrderView.14") + n);
        this.a.putClientProperty("SEAT_NO", n);
        this.a(n, ticket);
    }

    private void a(Integer n, Ticket ticket) {
        TicketItem ticketItem = new TicketItem();
        if (n == 0) {
            ticketItem.setName(Messages.getString("OrderView.16"));
        } else {
            ticketItem.setName(Messages.getString("OrderView.17") + n);
        }
        ticketItem.setShouldPrintToKitchen(true);
        ticketItem.setTreatAsSeat(true);
        ticketItem.setSeatNumber(n);
        ticketItem.setTicket(ticket);
        OrderView.getInstance().getTicketView().addTicketItem(ticketItem);
    }

    public Object getLastSeat(Ticket ticket) {
        Integer n = 0;
        List<TicketItem> list = ticket.getTicketItems();
        if (list != null && !list.isEmpty()) {
            TicketItem ticketItem = list.get(list.size() - 1);
            n = ticketItem.getSeatNumber();
        }
        return n;
    }

    public Object getSelectedSeatNumber() {
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        Object object = this.a.getClientProperty("SEAT_NO");
        if (object == null) {
            return 0;
        }
        Integer n = (Integer)object;
        boolean bl = false;
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            int n2;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (n2 = ticketItem.getSeatNumber().intValue()) != n) continue;
            bl = ticketItem.isPrintedToKitchen();
        }
        if (bl) {
            this.a(n, ticket);
        }
        return n;
    }

    protected List<Integer> getSeatNumbers(Ticket ticket) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue() || arrayList.contains(ticketItem.getSeatNumber())) continue;
            arrayList.add(ticketItem.getSeatNumber());
        }
        return arrayList;
    }

    public boolean updateSeatNumber(TicketItem ticketItem) {
        Ticket ticket = ticketItem.getTicket();
        SeatSelectionDialog seatSelectionDialog = new SeatSelectionDialog(ticket.getTableNumbers(), this.getSeatNumbers(ticket));
        seatSelectionDialog.setTitle(Messages.getString("TicketView.16"));
        seatSelectionDialog.pack();
        seatSelectionDialog.open();
        if (seatSelectionDialog.isCanceled()) {
            return false;
        }
        int n = seatSelectionDialog.getSeatNumber();
        if (n == -1) {
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("TicketView.17"));
            numberSelectionDialog2.setValue(ticketItem.getSeatNumber().intValue());
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return false;
            }
            n = (int)numberSelectionDialog2.getValue();
        }
        ticketItem.setName(Messages.getString("TicketView.18") + n);
        ticketItem.setSeatNumber(n);
        this.a(ticketItem);
        return true;
    }

    private void a(TicketItem ticketItem) {
        boolean bl = false;
        for (TicketItem ticketItem2 : ticketItem.getTicket().getTicketItems()) {
            if (ticketItem2 == ticketItem) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (ticketItem2.isTreatAsSeat().booleanValue()) break;
            ticketItem2.setSeatNumber(ticketItem.getSeatNumber());
        }
    }

    public void clearSelectedSeat() {
        this.a.putClientProperty("SEAT_NO", null);
    }
}

