/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.SendToKitchenOptionSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class SendToKitchenAction
extends PosAction {
    public SendToKitchenAction() {
        super("SEND");
    }

    public SendToKitchenAction(DataChangeListener dataChangeListener) {
        super("SEND", dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            Object object = this.getSelectedObject();
            if (object == null) {
                return;
            }
            Ticket ticket = null;
            ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), "The order type does not support printing to kitchen");
                return;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            PosPrinters posPrinters = DataProvider.get().getPrinters();
            if (posPrinters.getKitchenPrinters().size() == 0 && posPrinters.getStickerPrinters().size() == 0 && !posPrinters.isPrintToKds()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), "No kitchen printer is configured.");
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            SendToKitchenOptionSelectionDialog sendToKitchenOptionSelectionDialog = new SendToKitchenOptionSelectionDialog(ticket);
            sendToKitchenOptionSelectionDialog.pack();
            sendToKitchenOptionSelectionDialog.open();
            if (sendToKitchenOptionSelectionDialog.isCanceled()) {
                return;
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }
}

