/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.ExcelImportViewDialog;
import com.floreantpos.util.POSUtil;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ImportFromExcelAction
extends PosAction {
    private String a = null;

    public ImportFromExcelAction() {
        super(Messages.getString("ImportMenusFromExcel"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() {
        this.a();
    }

    private void a() {
        block9: {
            try {
                JFileChooser jFileChooser = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                jFileChooser.setDialogTitle(POSConstants.TITLE_OROPOS.toUpperCase());
                int n = jFileChooser.showOpenDialog(POSUtil.getFocusedWindow());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    this.a = file.getAbsolutePath();
                    ExcelImportViewDialog excelImportViewDialog = new ExcelImportViewDialog(this.a);
                    excelImportViewDialog.setDefaultCloseOperation(2);
                    if (excelImportViewDialog.getItemsList() == null) {
                        return;
                    }
                    excelImportViewDialog.openFullScreen();
                    if (excelImportViewDialog.isCanceled()) {
                        return;
                    }
                    List<Object> list = excelImportViewDialog.getItemsList();
                    if (list != null) {
                        Session session = MenuItemDAO.getInstance().createNewSession();
                        Transaction transaction = session.beginTransaction();
                        for (Object object : list) {
                            if (object instanceof MenuItem) {
                                MenuItemDAO.getInstance().saveOrUpdate((MenuItem)object, session);
                                continue;
                            }
                            if (!(object instanceof MenuModifier)) continue;
                            MenuModifierDAO.getInstance().saveOrUpdate((MenuModifier)object, session);
                        }
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImportedSuccessFully"));
                        transaction.commit();
                        if (session != null) {
                            session.close();
                        }
                        break block9;
                    }
                    POSMessageDialog.showError(Messages.getString("DataImortedFailed"));
                    return;
                }
                return;
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            }
        }
    }
}

