/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.SalesExceptionReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class SalesExceptionReportAction
extends AbstractAction {
    public SalesExceptionReportAction() {
        super(POSConstants.SALES_EXCEPTION_REPORT);
    }

    public SalesExceptionReportAction(String string) {
        super(string);
    }

    public SalesExceptionReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            SalesExceptionReportView salesExceptionReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.SALES_EXCEPTION_REPORT);
            if (n == -1) {
                salesExceptionReportView = new SalesExceptionReportView();
                jTabbedPane.addTab(POSConstants.SALES_EXCEPTION_REPORT, salesExceptionReportView);
            } else {
                salesExceptionReportView = (SalesExceptionReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(salesExceptionReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

