/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.TracTipsReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class TracTipsReportAction
extends AbstractAction {
    public TracTipsReportAction() {
        super(POSConstants.TRACK_TIPS_REPORT);
    }

    public TracTipsReportAction(String string) {
        super(string);
    }

    public TracTipsReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            TracTipsReportView tracTipsReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.TRACK_TIPS_REPORT);
            if (n == -1) {
                tracTipsReportView = new TracTipsReportView();
                jTabbedPane.addTab(POSConstants.TRACK_TIPS_REPORT, tracTipsReportView);
            } else {
                tracTipsReportView = (TracTipsReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(tracTipsReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

