/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class DrawerPullReportExplorer
extends TransparentPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JButton d = new JButton(POSConstants.EDIT_ACTUAL_AMOUNT);
    private JButton e = new JButton(Messages.getString("DrawerPullReportExplorer.0"));
    private static SimpleDateFormat f = new SimpleDateFormat("dd MMM, yyyy hh:mm a");
    private TableColumnModelExt g;
    private JXTable h = new JXTable((TableModel)new DrawerPullExplorerTableModel(null));

    public DrawerPullReportExplorer() {
        super(new BorderLayout());
        this.add(new JScrollPane((Component)this.h));
        this.h.getSelectionModel().setSelectionMode(0);
        this.h.setRowHeight(PosUIManager.getSize(30));
        this.h.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.h.setAutoResizeMode(0);
        this.h.setColumnControlVisible(true);
        this.resizeColumnWidth((JTable)this.h);
        this.b();
        this.e();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        jPanel.add((Component)this.a, "wrap");
        jPanel.add((Component)new JLabel(POSConstants.TO), "grow");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.d);
        jPanel2.add(this.e);
        this.add((Component)jPanel2, "South");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DrawerPullReportExplorer.this.h.getSelectedRow();
                if (n < 0) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, Messages.getString("DrawerPullReportExplorer.1"));
                    return;
                }
                DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)DrawerPullReportExplorer.this.h.getModel();
                CashDrawer cashDrawer = (CashDrawer)drawerPullExplorerTableModel.getRowData(n);
                PosPrintService.printDrawerPullReport(cashDrawer);
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DrawerPullReportExplorer.this.c();
                    DrawerPullReportExplorer.this.resizeColumnWidth((JTable)DrawerPullReportExplorer.this.h);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = DrawerPullReportExplorer.this.h.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.SELECT_DRAWER_PULL_TO_EDIT);
                        return;
                    }
                    String string = JOptionPane.showInputDialog(DrawerPullReportExplorer.this, (Object)(POSConstants.ENTER_ACTUAL_AMOUNT + ":"));
                    if (string == null) {
                        return;
                    }
                    double d = 0.0;
                    try {
                        d = Double.parseDouble(string);
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.INVALID_AMOUNT);
                        return;
                    }
                    DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)DrawerPullReportExplorer.this.h.getModel();
                    CashDrawer cashDrawer = (CashDrawer)drawerPullExplorerTableModel.getRowData(n);
                    cashDrawer.setCashToDeposit(d);
                    CashDrawerDAO cashDrawerDAO = new CashDrawerDAO();
                    cashDrawerDAO.saveOrUpdate(cashDrawer);
                    drawerPullExplorerTableModel.updateItem(n);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(DrawerPullReportExplorer.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void b() {
        String string = TerminalConfig.getDrawerPullReportHiddenColumns();
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.h.getColumnModel();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("\\*");
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = Integer.parseInt(stringArray[i]);
            tableColumnModelExt.getColumnExt(n - i).setVisible(false);
        }
    }

    private void c() {
        try {
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            List<CashDrawer> list = new CashDrawerDAO().findReports(date, date2);
            DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)this.h.getModel();
            drawerPullExplorerTableModel.setRows(list);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n;
            int n2 = this.b(jTable, i);
            if (n2 > (n = this.a(jTable, i))) {
                tableColumnModel.getColumn(i).setPreferredWidth(n2);
                continue;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
    }

    private int a(JTable jTable, int n) {
        int n2 = 50;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, n);
        n2 = Math.max(n2, component.getPreferredSize().width);
        return n2 + 20;
    }

    private int b(JTable jTable, int n) {
        int n2 = 50;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n);
            Component component = jTable.prepareRenderer(tableCellRenderer, i, n);
            n2 = Math.max(component.getPreferredSize().width + 1, n2);
        }
        return n2 + 20;
    }

    private void d() {
        List list = this.g.getColumns(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableColumn tableColumn : list) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            if (tableColumnExt.isVisible()) continue;
            arrayList.add(tableColumnExt.getModelIndex());
        }
        this.a(arrayList);
    }

    private void a(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(iterator.next());
            string = string + string2;
            if (!iterator.hasNext()) continue;
            string = string + "*";
        }
        TerminalConfig.setDrawerPullReportHiddenColumns(string);
    }

    private void e() {
        this.g = (TableColumnModelExt)this.h.getColumnModel();
        this.g.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                DrawerPullReportExplorer.this.d();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                DrawerPullReportExplorer.this.d();
            }
        });
    }

    class DrawerPullExplorerTableModel
    extends ListTableModel {
        String[] a = new String[]{POSConstants.ID, POSConstants.TIME, Messages.getString("DrawerPullReportExplorer.2"), POSConstants.DRAWER_PULL_AMOUNT, Messages.getString("DrawerPullReportExplorer.3"), Messages.getString("DrawerPullReportExplorer.4"), Messages.getString("DrawerPullReportExplorer.5"), Messages.getString("DrawerPullReportExplorer.6"), Messages.getString("DrawerPullReportExplorer.7"), Messages.getString("DrawerPullReportExplorer.8"), Messages.getString("DrawerPullReportExplorer.9"), Messages.getString("DrawerPullReportExplorer.10"), Messages.getString("DrawerPullReportExplorer.11"), Messages.getString("DrawerPullReportExplorer.12"), Messages.getString("DrawerPullReportExplorer.13"), Messages.getString("DrawerPullReportExplorer.14"), Messages.getString("DrawerPullReportExplorer.15"), Messages.getString("DrawerPullReportExplorer.16"), Messages.getString("DrawerPullReportExplorer.17"), Messages.getString("DrawerPullReportExplorer.18"), Messages.getString("DrawerPullReportExplorer.19"), Messages.getString("DrawerPullReportExplorer.20"), Messages.getString("DrawerPullReportExplorer.21"), Messages.getString("DrawerPullReportExplorer.22"), Messages.getString("DrawerPullReportExplorer.23"), Messages.getString("DrawerPullReportExplorer.24"), Messages.getString("DrawerPullReportExplorer.25"), Messages.getString("DrawerPullReportExplorer.26"), Messages.getString("DrawerPullReportExplorer.27"), Messages.getString("DrawerPullReportExplorer.28"), Messages.getString("DrawerPullReportExplorer.29"), Messages.getString("DrawerPullReportExplorer.30"), Messages.getString("DrawerPullReportExplorer.31"), POSConstants.ACTUAL_AMOUNT, Messages.getString("DrawerPullReportExplorer.32"), Messages.getString("DrawerPullReportExplorer.33"), Messages.getString("DrawerPullReportExplorer.34"), Messages.getString("DrawerPullReportExplorer.35"), Messages.getString("DrawerPullReportExplorer.36"), Messages.getString("DrawerPullReportExplorer.37"), Messages.getString("DrawerPullReportExplorer.38"), Messages.getString("DrawerPullReportExplorer.39"), Messages.getString("DrawerPullReportExplorer.40"), Messages.getString("DrawerPullReportExplorer.41"), Messages.getString("DrawerPullReportExplorer.42")};

        DrawerPullExplorerTableModel(List<CashDrawer> list) {
            this.setRows(list);
            this.setColumnNames(this.a);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CashDrawer cashDrawer = (CashDrawer)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return cashDrawer.getId().toString();
                }
                case 1: {
                    return f.format(cashDrawer.getReportTime());
                }
                case 2: {
                    return cashDrawer.getTicketCount();
                }
                case 3: {
                    return cashDrawer.getDrawerAccountable();
                }
                case 4: {
                    return cashDrawer.getAssignedUser().getId();
                }
                case 5: {
                    return cashDrawer.getTerminal().getId();
                }
                case 6: {
                    return cashDrawer.getBeginCash();
                }
                case 7: {
                    return cashDrawer.getNetSales();
                }
                case 8: {
                    return cashDrawer.getSalesTax();
                }
                case 9: {
                    return cashDrawer.getCashTax();
                }
                case 10: {
                    return cashDrawer.getTotalRevenue();
                }
                case 11: {
                    return cashDrawer.getGrossReceipts();
                }
                case 12: {
                    return cashDrawer.getGiftCertReturnCount();
                }
                case 13: {
                    return cashDrawer.getGiftCertReturnAmount();
                }
                case 14: {
                    return cashDrawer.getGiftCertChangeAmount();
                }
                case 15: {
                    return cashDrawer.getCashReceiptNumber();
                }
                case 16: {
                    return cashDrawer.getCashReceiptAmount();
                }
                case 17: {
                    return cashDrawer.getCreditCardReceiptNumber();
                }
                case 18: {
                    return cashDrawer.getCreditCardReceiptAmount();
                }
                case 19: {
                    return cashDrawer.getDebitCardReceiptNumber();
                }
                case 20: {
                    return cashDrawer.getDebitCardReceiptAmount();
                }
                case 21: {
                    return cashDrawer.getRefundReceiptCount();
                }
                case 22: {
                    return cashDrawer.getRefundAmount();
                }
                case 23: {
                    return cashDrawer.getReceiptDifferential();
                }
                case 24: {
                    return cashDrawer.getCashBack();
                }
                case 25: {
                    return cashDrawer.getCashTips();
                }
                case 26: {
                    return cashDrawer.getChargedTips();
                }
                case 27: {
                    return cashDrawer.getTipsPaid();
                }
                case 28: {
                    return cashDrawer.getTipsDifferential();
                }
                case 29: {
                    return cashDrawer.getPayOutNumber();
                }
                case 30: {
                    return cashDrawer.getPayOutAmount();
                }
                case 31: {
                    return cashDrawer.getDrawerBleedNumber();
                }
                case 32: {
                    return cashDrawer.getDrawerBleedAmount();
                }
                case 33: {
                    return cashDrawer.getCashToDeposit();
                }
                case 34: {
                    return cashDrawer.getVariance();
                }
                case 35: {
                    return cashDrawer.getTotalVoidWst();
                }
                case 36: {
                    return cashDrawer.getTotalVoid();
                }
                case 37: {
                    return cashDrawer.getTotalDiscountCount();
                }
                case 38: {
                    return cashDrawer.getTotalDiscountAmount();
                }
                case 39: {
                    return cashDrawer.getTotalDiscountSales();
                }
                case 40: {
                    return cashDrawer.getTotalDiscountGuest();
                }
                case 41: {
                    return cashDrawer.getTotalDiscountPartySize();
                }
                case 42: {
                    return cashDrawer.getTotalDiscountCheckSize();
                }
                case 43: {
                    return cashDrawer.getTotalDiscountPercentage();
                }
                case 44: {
                    return cashDrawer.getTotalDiscountRatio();
                }
            }
            return null;
        }
    }
}

