/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.menuitem.variant.VariantForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class MenuItemExplorer
extends TransparentPanel
implements ExplorerView {
    private MenuItemExplorerTable a;
    private BeanTableModel<MenuItem> b;
    private JComboBox c;
    private JTextField d;
    private JCheckBox e;
    private JButton f;
    private JButton g;
    private JButton h;
    private JButton i;
    private JLabel j;
    private JComboBox k;
    private boolean l;
    private JPanel m;
    private JPanel n;

    public MenuItemExplorer() {
        this(false);
    }

    public MenuItemExplorer(boolean bl) {
        this.l = bl;
        this.a();
    }

    private void a() {
        this.b = new BeanTableModel(MenuItem.class, 20);
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME.toUpperCase(), "translatedName");
        this.b.addColumn("BARCODE", "barcode");
        this.b.addColumn("COMBO", MenuItem.PROP_COMBO_ITEM);
        this.b.addColumn("HAS MODIFIER", MenuItem.PROP_HAS_MODIFIERS);
        this.b.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.b.addColumn(Messages.getString("MenuItemExplorer.14"), "availableUnit");
        this.b.addColumn(Messages.getString("MenuItemExplorer.26"), "unitOnHand");
        this.b.addColumn(POSConstants.VISIBLE.toUpperCase(), "visible");
        this.b.addColumn("TAX GROUP", "taxGroup");
        this.b.addColumn(Messages.getString("MenuItemExplorer.21"), "sortOrder", BeanTableModel.EditMode.EDITABLE);
        this.b.addColumn(Messages.getString("MenuItemExplorer.23"), "buttonColor");
        this.b.addColumn(Messages.getString("MenuItemExplorer.25"), "textColor");
        this.b.addColumn(POSConstants.IMAGE.toUpperCase(), "image");
        int n = PosUIManager.getSize(16);
        this.f = new JButton();
        this.f.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_PREVIOUS, (float)n));
        this.h = new JButton();
        this.h.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.i = new JButton();
        this.i.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.g = new JButton();
        this.g.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_NEXT, (float)n));
        this.j = new JLabel();
        this.a = new MenuItemExplorerTable(this.b);
        this.a.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.a.setSelectionMode(0);
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        IntegerTextField integerTextField = new IntegerTextField();
        integerTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(integerTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(8), defaultCellEditor);
        this.a.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuItemExplorer.this.g();
                }
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(MenuItemExplorer.this.b.getPreviousRowIndex());
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(MenuItemExplorer.this.b.getNextRowIndex());
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(0);
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = MenuItemExplorer.this.b.getNumRows() / MenuItemExplorer.this.b.getPageSize();
                MenuItemExplorer.this.a(n * MenuItemExplorer.this.b.getPageSize());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)((Object)this.a)));
        this.m = this.d();
        this.add((Component)this.m, "South");
        this.n = this.b();
        this.add((Component)this.n, "North");
        this.resizeColumnWidth((JTable)((Object)this.a));
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        try {
            Serializable serializable2;
            jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
            JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.4"));
            this.c = new JComboBox();
            this.c.addItem(Messages.getString("MenuItemExplorer.5"));
            List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
            for (Serializable serializable2 : list) {
                this.c.addItem(serializable2);
            }
            this.c.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MenuItemExplorer.this.a(itemEvent);
                }
            });
            JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.0"));
            serializable2 = new JLabel(Messages.getString("MenuItemExplorer.1"));
            this.k = new JComboBox();
            this.k.addItem(Messages.getString("MenuItemExplorer.5"));
            this.d = new JTextField(15);
            this.e = new JCheckBox(Messages.getString("MenuItemExplorer.13"));
            JButton jButton = new JButton(Messages.getString("MenuItemExplorer.3"));
            jPanel.add((Component)jLabel2, "align label");
            jPanel.add(this.d);
            jPanel.add(jLabel);
            jPanel.add(this.c);
            jPanel.add((Component)serializable2);
            jPanel.add(this.k);
            jPanel.add(this.e);
            jPanel.add(jButton);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("MenuItemExplorer.30"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MenuItemExplorer.this.c();
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (MenuItemExplorer.this.d.getText().length() > 2) {
                        MenuItemExplorer.this.c();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        MenuItemExplorer.this.c();
                    }
                }
            };
            this.d.addKeyListener(keyListener);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    public void setMenuItems(List<MenuItem> list) {
        this.b.removeAll();
        this.m.setVisible(false);
        this.n.setVisible(false);
        this.b.addRows(list);
    }

    private void c() {
        this.a(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Integer n) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object object = this.c.getSelectedItem();
            String string = this.d.getText();
            Boolean bl = !this.e.isSelected();
            MenuGroup menuGroup = null;
            MenuCategory menuCategory = null;
            Object object2 = this.k.getSelectedItem();
            if (object2 instanceof MenuGroup) {
                menuGroup = (MenuGroup)object2;
            }
            if (object instanceof MenuCategory) {
                menuCategory = (MenuCategory)object;
            }
            if (n != null) {
                this.b.setCurrentRowIndex(n);
            }
            MenuItemDAO.getInstance().loadMenuItems(this.b, bl, menuGroup, string, menuCategory, this.l, false);
            int n2 = this.b.getCurrentRowIndex() + 1;
            int n3 = this.b.getNextRowIndex();
            int n4 = this.b.getNumRows();
            if (n3 > n4) {
                n3 = n4;
            }
            this.j.setText(String.format("Showing %s to %s of %s", n2, n3, n4));
            this.f.setEnabled(this.b.hasPrevious());
            this.h.setEnabled(this.b.hasPrevious());
            this.i.setEnabled(this.b.hasNext());
            this.g.setEnabled(this.b.hasNext());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private JPanel d() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton2.setText(Messages.getString("MenuItemExplorer.17"));
        jButton.setText(Messages.getString("MenuItemExplorer.18"));
        jButton3.setText(Messages.getString("MenuItemExplorer.19"));
        JButton jButton4 = new JButton("UPDATE STOCK AMOUNT");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.h();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.g();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.i();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.j();
            }
        });
        JButton jButton5 = new JButton("DUPLICATE");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuItemExplorer.this.k();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel transparentPanel = new TransparentPanel();
        if (!this.l) {
            transparentPanel.add(jButton2);
        }
        transparentPanel.add(jButton);
        transparentPanel.add(jButton4);
        if (!this.l) {
            transparentPanel.add(jButton3);
            transparentPanel.add(jButton5);
        }
        this.a(transparentPanel);
        jPanel.add((Component)transparentPanel, "");
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        jPanel2.add(this.j);
        jPanel2.add(this.f);
        jPanel2.add(this.h);
        jPanel2.add(this.i);
        jPanel2.add(this.g);
        jPanel.add((Component)jPanel2, "grow");
        return jPanel;
    }

    private void a(JPanel jPanel) {
        JButton jButton = new JButton("IN");
        JButton jButton2 = new JButton("OUT");
        JButton jButton3 = new JButton("TRANSFER");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(InventoryTransactionType.IN);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(InventoryTransactionType.OUT, false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(InventoryTransactionType.UNCHANGED, true);
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
    }

    private boolean a(InventoryTransactionType inventoryTransactionType, boolean bl) {
        MenuItem menuItem = this.e();
        if (menuItem == null) {
            POSMessageDialog.showError(this, "Please select a row first");
            return false;
        }
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        if (bl) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 500));
        beanEditorDialog.open();
        return !beanEditorDialog.isCanceled();
    }

    private boolean a(InventoryTransactionType inventoryTransactionType) {
        Serializable serializable;
        MenuItem menuItem = this.e();
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        InventoryStockInForm inventoryStockInForm = null;
        if (menuItem == null) {
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            serializable = menuItem.getUnit();
            if (serializable == null) {
                POSMessageDialog.showError(this, "No unit is set for the item. Please set item unit first.");
                return false;
            }
            Double d = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(d);
            Double d2 = menuItem.getCost();
            inventoryTransaction.setUnitCost(d2);
            inventoryTransaction.setTotal(d * d2);
            inventoryTransaction.setUnit(menuItem.getUnit().getCode());
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        }
        serializable = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)inventoryStockInForm);
        ((BeanEditorDialog)serializable).openWithScale(830, 630);
        if (((BeanEditorDialog)serializable).isCanceled()) {
            return false;
        }
        this.c();
        return true;
    }

    private MenuItem e() {
        int n = this.a.getSelectedRow();
        MenuItem menuItem = null;
        if (n >= 0) {
            n = this.a.convertRowIndexToModel(n);
            menuItem = this.b.getRow(n);
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        return menuItem;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.f().get(i));
        }
    }

    private List f() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(180);
        arrayList.add(90);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(80);
        arrayList.add(80);
        arrayList.add(50);
        arrayList.add(140);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(200);
        return arrayList;
    }

    private void g() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuItem menuItem = this.b.getRow(n);
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (menuItem == null) {
                throw new PosException("The item is in invalid state. It cannot be edited");
            }
            if (this.l) {
                VariantForm variantForm = new VariantForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)variantForm);
                this.a(variantForm, beanEditorDialog);
                beanEditorDialog.openWithScale(1000, 700);
                if (!beanEditorDialog.isCanceled()) {
                    this.b.setRow(n, menuItem);
                    this.b.fireTableRowsUpdated(n, n);
                }
            } else {
                MenuItemForm menuItemForm = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), menuItemForm, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (!beanEditorDialog.isCanceled()) {
                    this.b.setRow(n, menuItem);
                    this.b.fireTableRowsUpdated(n, n);
                }
            }
        }
        catch (PosException posException) {
            BOMessageDialog.showError(this, posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    private void a(final VariantForm variantForm, final BeanEditorDialog beanEditorDialog) {
        PosButton posButton = new PosButton("SAVE");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!variantForm.save()) {
                    return;
                }
                beanEditorDialog.dispose();
            }
        });
        PosButton posButton2 = (PosButton)beanEditorDialog.getButtonPanel().getComponent(0);
        posButton2.setText("<html><center>SAVE &<br> CLOSE</center></html>");
        PosButton posButton3 = (PosButton)beanEditorDialog.getButtonPanel().getComponent(1);
        posButton3.setText("CLOSE");
        beanEditorDialog.getButtonPanel().add((Component)posButton, 0);
    }

    private void h() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, "Please select a row to update stock amount");
                return;
            }
            MenuItem menuItem = this.b.getRow(n);
            String string = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.8"), menuItem.getAvailableUnit());
            if (string == null || string.equals("")) {
                return;
            }
            double d = Double.parseDouble(string);
            if (d < 0.0) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.10"));
                return;
            }
            menuItem.setAvailableUnit(d);
            MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(menuItem.getStockStatus());
            this.a.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemExplorer.11"));
            return;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, exception);
            return;
        }
    }

    private void i() {
        try {
            Serializable serializable;
            MenuItem menuItem = new MenuItem();
            Object object = this.c.getSelectedItem();
            if (object instanceof OrderType) {
                serializable = new ArrayList<OrderType>();
                serializable.add((OrderType)object);
                menuItem.setOrderTypeList((List)((Object)serializable));
            }
            serializable = new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable, true);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem2 = (MenuItem)((BeanEditor)serializable).getBean();
            this.b.addRow(menuItem2);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void j() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItem menuItem = this.b.getRow(n);
            MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
            menuItemDAO.refresh(menuItem);
            menuItemDAO.releaseParentAndDelete(menuItem);
            this.b.removeRow(n);
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This menu item is in use and cannot be deleted.");
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void initData() {
        this.c();
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup menuGroup : list) {
            this.k.addItem(menuGroup);
        }
    }

    private void a(ItemEvent itemEvent) {
        try {
            Object object = itemEvent.getItem();
            this.k.removeAllItems();
            this.k.addItem(Messages.getString("MenuItemExplorer.5"));
            if (object instanceof MenuCategory) {
                MenuCategory menuCategory = (MenuCategory)object;
                List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
                for (MenuGroup menuGroup : list) {
                    this.k.addItem(menuGroup);
                }
            } else {
                List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
                for (MenuGroup menuGroup : list) {
                    this.k.addItem(menuGroup);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void k() throws Exception {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, "Please select a row to make duplicate");
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        MenuItem menuItem = this.b.getRow(n);
        MenuItemDAO.getInstance().initialize(menuItem);
        MenuItem menuItem2 = menuItem.clone();
        MenuItemForm menuItemForm = new MenuItemForm(menuItem2);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
        beanEditorDialog.openWithScale(1000, 700);
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuItem menuItem3 = (MenuItem)menuItemForm.getBean();
        this.b.addRow(menuItem3);
        this.a.getSelectionModel().addSelectionInterval(this.b.getRowCount() - 1, this.b.getRowCount() - 1);
        this.a.scrollRowToVisible(this.b.getRowCount() - 1);
    }

    private class MenuItemExplorerTable
    extends JXTable {
        public MenuItemExplorerTable(TableModel tableModel) {
            super(tableModel);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            super.changeSelection(n, n2, bl, bl2);
            MenuItemExplorer.this.a.editCellAt(n, n2);
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)MenuItemExplorer.this.a.getCellEditor(n, n2);
            if (defaultCellEditor.getComponent() instanceof IntegerTextField) {
                IntegerTextField integerTextField = (IntegerTextField)defaultCellEditor.getComponent();
                integerTextField.requestFocus();
                integerTextField.selectAll();
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            MenuItem menuItem = (MenuItem)MenuItemExplorer.this.b.getRow(n);
            Integer n3 = 0;
            if (object != null && object instanceof Integer) {
                n3 = (Integer)object;
            }
            super.setValueAt((Object)n3, n, n2);
            if (n2 == 10) {
                menuItem.setSortOrder(n3);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
        }
    }
}

