/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.OrderTypeForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class OrderTypeExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<OrderType> b = new BeanTableModel(OrderType.class);

    public OrderTypeExplorer() {
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn(Messages.getString("OrderTypeExplorer.0"), "showTableSelection");
        this.b.addColumn(Messages.getString("OrderTypeExplorer.2"), "showGuestSelection");
        this.b.addColumn(POSConstants.PRINT_TO_KITCHEN, "shouldPrintToKitchen");
        this.b.addColumn(POSConstants.ENABLED.toUpperCase(), "enabled");
        this.b.addColumn(Messages.getString("OrderTypeExplorer.4"), "preAuthCreditCard");
        this.b.addRows(OrderTypeDAO.getInstance().findAll());
        this.a = new JXTable(this.b);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    OrderTypeExplorer.this.b();
                }
            }
        });
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.a();
    }

    private void a() {
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OrderTypeForm orderTypeForm = new OrderTypeForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)orderTypeForm);
                    beanEditorDialog.openWithScale(800, 600);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    OrderType orderType = (OrderType)orderTypeForm.getBean();
                    OrderTypeExplorer.this.b.addRow(orderType);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderTypeExplorer.this.b();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = OrderTypeExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = OrderTypeExplorer.this.a.convertRowIndexToModel(n);
                    OrderType orderType = (OrderType)OrderTypeExplorer.this.b.getRow(n);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    OrderTypeDAO orderTypeDAO = new OrderTypeDAO();
                    orderTypeDAO.delete(orderType);
                    POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("TerminalConfigurationView.40"));
                    OrderTypeExplorer.this.b.removeRow(n);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void b() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            OrderType orderType = this.b.getRow(n);
            OrderTypeForm orderTypeForm = new OrderTypeForm(orderType);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)orderTypeForm);
            beanEditorDialog.openWithScale(800, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, throwable);
        }
    }
}

