/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Address;
import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class OutletEntryForm
extends BeanEditor<Outlet> {
    private Outlet a;
    private FixedLengthTextField b;
    private JTextField c;
    private JTextArea d;
    private CheckBoxList e = new CheckBoxList();

    public OutletEntryForm(Outlet outlet) {
        this.a = outlet;
        this.initComponents();
        this.initData();
        this.setBean(outlet);
    }

    public void initData() {
        List<Department> list = DepartmentDAO.getInstance().findAll();
        if (list == null) {
            return;
        }
        this.e.setModel(list);
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("wrap 2,fillx", "[][grow]", ""));
        JLabel jLabel = new JLabel("Name");
        this.b = new FixedLengthTextField();
        this.b.setLength(20);
        this.c = new JTextField();
        this.d = new JTextArea(5, 5);
        jPanel.add((Component)jLabel, "alignx trailing");
        jPanel.add((Component)this.b, "growx");
        JLabel jLabel2 = new JLabel("Address");
        jPanel.add((Component)jLabel2, "alignx trailing");
        jPanel.add((Component)this.c, "growx");
        JLabel jLabel3 = new JLabel("Description");
        jPanel.add((Component)jLabel3, "alignx trailing");
        this.d.setLineWrap(true);
        jPanel.add((Component)new JScrollPane(this.d), "growx,h 100!");
        this.e.setEnabled(true);
        TitledBorder titledBorder = new TitledBorder("Departmeents");
        JScrollPane jScrollPane = new JScrollPane(this.e);
        jScrollPane.setBorder(titledBorder);
        jPanel.add((Component)jScrollPane, "skip 1, h 200px");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Outlet outlet = (Outlet)this.getBean();
            OutletDAO outletDAO = new OutletDAO();
            outletDAO.saveOrUpdate(outlet);
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Outlet outlet = (Outlet)this.getBean();
        this.b.setText(outlet.getName());
        if (outlet.getAddress() != null) {
            this.c.setText(outlet.getAddress().getAddressLine());
        }
        this.d.setText(outlet.getDescription());
        this.e.selectItems(outlet.getDepartments());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Outlet outlet = (Outlet)this.getBean();
        String string = this.b.getText();
        String string2 = this.c.getText();
        String string3 = this.d.getText();
        Address address = new Address();
        address.setAddressLine(string2);
        if (string == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Please enter name");
            return false;
        }
        this.a.setName(string);
        this.a.setAddress(address);
        this.a.setDescription(string3);
        this.a.setDepartments(this.e.getCheckedValues());
        AddressDAO.getInstance().saveOrUpdate(address);
        return true;
    }

    @Override
    public String getDisplayText() {
        Outlet outlet = (Outlet)this.getBean();
        if (outlet.getId() == null) {
            return "Add New Outlet";
        }
        return "Edit Outlet";
    }
}

