/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.actions.TerminalConfigurationAction;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class TerminalExplorer
extends TransparentPanel {
    private static final long a = 1L;
    private JXTable b;
    private BeanTableModel<Terminal> c;

    public TerminalExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new BeanTableModel(Terminal.class);
        this.c.addColumn(Messages.getString("TerminalExplorer.0"), "id");
        this.c.addColumn(Messages.getString("TerminalExplorer.2"), "name");
        this.c.addColumn(Messages.getString("TerminalExplorer.4"), "department");
        this.c.addColumn(Messages.getString("TerminalExplorer.12"), "location");
        this.c.addColumn(Messages.getString("TerminalExplorer.10"), "hasCashDrawer");
        this.c.addColumn(Messages.getString("TerminalExplorer.1"), Terminal.PROP_IS_AUTO_LOG_OFF_ENABLED);
        this.c.addColumn(Messages.getString("TerminalExplorer.18"), "defaultPassLength");
        this.c.addColumn(Messages.getString("TerminalExplorer.5"), "active");
        this.c.addRows(TerminalDAO.getInstance().findAll());
        this.b = new JXTable(this.c);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TerminalExplorer.this.c();
                }
            }
        });
        this.b.getColumn(0).setCellRenderer(new IconRenderer());
        this.add(new JScrollPane((Component)this.b));
        this.add((Component)this.a(), "South");
        this.add((Component)this.b(), "North");
    }

    private TransparentPanel a() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalExplorer.this.c();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = TerminalExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = TerminalExplorer.this.b.convertRowIndexToModel(n);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    Terminal terminal = (Terminal)TerminalExplorer.this.c.getRow(n);
                    TerminalDAO terminalDAO = new TerminalDAO();
                    terminalDAO.delete(terminal);
                    TerminalExplorer.this.c.removeRow(n);
                }
                catch (ConstraintViolationException constraintViolationException) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This menu item is in use and cannot be deleted.");
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        return transparentPanel;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    private void c() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            Terminal terminal = this.c.getRow(n);
            terminal = TerminalDAO.getInstance().initialize(terminal);
            this.c.setRow(n, terminal);
            TerminalConfigurationAction terminalConfigurationAction = new TerminalConfigurationAction(terminal);
            terminalConfigurationAction.actionPerformed(null);
            this.b.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Terminal terminal = Application.getInstance().getTerminal();
            Terminal terminal2 = (Terminal)TerminalExplorer.this.c.getRow(n);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            if (terminal.equals(terminal2)) {
                jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                return jLabel;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

