/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.UserForm;
import com.floreantpos.ui.model.UserRoleForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class UserExplorer
extends TransparentPanel {
    private JXTreeTable a = new JXTreeTable();
    private UserTreeTableModel b;
    private JButton c;
    private JButton d;
    private JButton e;
    private JButton f;
    private JLabel g;
    private JTextField h;

    public UserExplorer() {
        this.a.setRootVisible(false);
        this.a.setShowGrid(true, true);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setLeafIcon(null);
        this.a.setOpenIcon(null);
        this.a.setClosedIcon(null);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.e = new JButton("<<< Previous");
        this.f = new JButton("Next >>>");
        this.g = new JLabel();
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = UserExplorer.this.a.getSelectedRow();
                if (n < 0) {
                    return;
                }
                TreePath treePath = UserExplorer.this.a.getPathForRow(n);
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                User user = (User)defaultMutableTreeTableNode.getUserObject();
                if (user == null) {
                    return;
                }
                UserExplorer.this.c.setEnabled(user.isRoot());
                UserExplorer.this.d.setEnabled(user.isRoot());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.a(), "North");
        this.b();
        this.a.expandAll();
        this.a.collapseAll();
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = UserExplorer.this.a.columnAtPoint(mouseEvent.getPoint());
                if (mouseEvent.getClickCount() == 2 && n == 0) {
                    UserExplorer.this.a.expandPath(UserExplorer.this.a.getPathForRow(UserExplorer.this.a.getSelectedRow()));
                } else if (mouseEvent.getClickCount() == 2 && n != 0) {
                    UserExplorer.this.c();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.a), "Center");
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UserForm userForm = new UserForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userForm);
                    beanEditorDialog.openWithScale(800, 600);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    User user = (User)userForm.getBean();
                    MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)UserExplorer.this.b.getRoot();
                    UserExplorer.this.b.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)user), mutableTreeTableNode, mutableTreeTableNode.getChildCount());
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.d = new JButton(POSConstants.COPY);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = UserExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Please select a row to copy");
                        return;
                    }
                    TreePath treePath = UserExplorer.this.a.getPathForRow(n);
                    DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    User user = (User)defaultMutableTreeTableNode.getUserObject();
                    if (!user.isRoot().booleanValue()) {
                        return;
                    }
                    User user2 = new User();
                    user2.setId(user.getId());
                    user2.setType(user.getType());
                    user2.setFirstName(user.getFirstName());
                    user2.setLastName(user.getLastName());
                    user2.setPassword(user.getPassword());
                    user2.setSsn(user.getSsn());
                    UserForm userForm = new UserForm();
                    userForm.setEditMode(false);
                    userForm.setBean(user2);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userForm);
                    beanEditorDialog.openWithScale(800, 600);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    User user3 = (User)userForm.getBean();
                    MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)UserExplorer.this.b.getRoot();
                    UserExplorer.this.b.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)user3), mutableTreeTableNode, mutableTreeTableNode.getChildCount());
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.c();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UserExplorer.this.a.getSelectedRow();
                if (n < 0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                    return;
                }
                TreePath treePath = UserExplorer.this.a.getPathForRow(n);
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                User user = (User)defaultMutableTreeTableNode.getUserObject();
                if (user == null) {
                    return;
                }
                try {
                    if (ConfirmDeleteDialog.showMessage(UserExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        UserDAO.getInstance().delete(user);
                        MutableTreeTableNode mutableTreeTableNode = UserExplorer.this.a((MutableTreeTableNode)UserExplorer.this.b.getRoot(), user.getId());
                        if (mutableTreeTableNode.getParent() != null) {
                            UserExplorer.this.b.removeNodeFromParent(mutableTreeTableNode);
                        }
                    }
                }
                catch (ConstraintViolationException constraintViolationException) {
                    String string = POSConstants.USER + " " + user.getFirstName() + " " + user.getLastName() + " (" + user.getType() + ") " + POSConstants.ERROR_MESSAGE;
                    BOMessageDialog.showError(string, constraintViolationException);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.c = new JButton("Add Role");
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.d();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.b.setCurrentRowIndex(UserExplorer.this.b.getPreviousRowIndex());
                UserExplorer.this.b();
                UserExplorer.this.a.expandAll();
                UserExplorer.this.a.collapseAll();
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.b.setCurrentRowIndex(UserExplorer.this.b.getNextRowIndex());
                UserExplorer.this.b();
                UserExplorer.this.a.expandAll();
                UserExplorer.this.a.collapseAll();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill", "[right][]"));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add((Component)jButton, "split 5");
        transparentPanel.add(this.d);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(this.c);
        jPanel.add((Component)transparentPanel, "");
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        jPanel2.add(this.g);
        jPanel2.add(this.e);
        jPanel2.add(this.f);
        jPanel.add((Component)jPanel2, "grow");
        this.add((Component)jPanel, "South");
    }

    private JPanel a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        JLabel jLabel = new JLabel("Id / Name:");
        this.h = new JTextField(20);
        JButton jButton = new JButton("Search");
        JButton jButton2 = new JButton("Clear");
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.e();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.e();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserExplorer.this.h.setText("");
            }
        });
        jPanel.add(jLabel);
        jPanel.add((Component)this.h, "grow");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private MutableTreeTableNode a(MutableTreeTableNode mutableTreeTableNode, String string) {
        User user = (User)mutableTreeTableNode.getUserObject();
        if (string.equals(user.getId())) {
            return mutableTreeTableNode;
        }
        Enumeration enumeration = mutableTreeTableNode.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeTableNode mutableTreeTableNode2 = (MutableTreeTableNode)enumeration.nextElement();
            MutableTreeTableNode mutableTreeTableNode3 = this.a(mutableTreeTableNode2, string);
            if (mutableTreeTableNode3 == null) continue;
            return mutableTreeTableNode3;
        }
        return null;
    }

    private void b() {
        int n;
        User user = new User();
        user.setId("0");
        user.setFirstName("Root");
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)user);
        defaultMutableTreeTableNode.setUserObject((Object)user);
        if (this.b == null) {
            this.b = new UserTreeTableModel(defaultMutableTreeTableNode);
            this.a.setTreeTableModel((TreeTableModel)this.b);
        } else {
            this.b.setRoot((TreeTableNode)defaultMutableTreeTableNode);
        }
        String string = this.h.getText();
        this.b.setNumRows(UserDAO.getInstance().rowCount(string));
        List<User> list = UserDAO.getInstance().loadUsers(this.b, string);
        for (User user2 : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)user2);
            List<User> list2 = user2.getLinkedUser();
            for (User user3 : list2) {
                if (user3.isRoot().booleanValue()) continue;
                DefaultMutableTreeTableNode defaultMutableTreeTableNode3 = new DefaultMutableTreeTableNode((Object)user3);
                defaultMutableTreeTableNode2.add((MutableTreeTableNode)defaultMutableTreeTableNode3);
            }
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
        int n2 = this.b.getCurrentRowIndex() + 1;
        int n3 = this.b.getNextRowIndex();
        if (n3 > (n = this.b.getNumRows())) {
            n3 = n;
        }
        this.g.setText(String.format("Showing %s to %s of %s", n2, n3, n));
        this.e.setEnabled(this.b.hasPrevious());
        this.f.setEnabled(this.b.hasNext());
    }

    private void c() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            User user = (User)defaultMutableTreeTableNode.getUserObject();
            if (!user.isRoot().booleanValue()) {
                UserRoleForm userRoleForm = new UserRoleForm(user);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userRoleForm);
                beanEditorDialog.openWithScale(800, 600);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            } else {
                UserForm userForm = new UserForm();
                userForm.setEditMode(true);
                userForm.setBean(user);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userForm);
                beanEditorDialog.openWithScale(800, 600);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, "Please select a row to add new role");
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            User user = (User)defaultMutableTreeTableNode.getUserObject();
            User user2 = new User();
            user2.setParentUser(user);
            UserRoleForm userRoleForm = new UserRoleForm(user2);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userRoleForm);
            beanEditorDialog.openWithScale(800, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            User user3 = user2.getParentUser();
            MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)this.b.getRoot();
            if (user3 != null) {
                MutableTreeTableNode mutableTreeTableNode2 = this.a(mutableTreeTableNode, user3.getId());
                if (mutableTreeTableNode2 != null) {
                    this.b.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)user2), mutableTreeTableNode2, mutableTreeTableNode2.getChildCount());
                }
            } else {
                MutableTreeTableNode mutableTreeTableNode3 = this.a(mutableTreeTableNode, "0");
                if (mutableTreeTableNode3 != null) {
                    this.b.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)user2), mutableTreeTableNode3, mutableTreeTableNode3.getChildCount());
                }
            }
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        this.b.setCurrentRowIndex(0);
        this.b();
        this.a.expandAll();
        this.a.collapseAll();
    }

    class BooleanRenderer
    extends JCheckBox
    implements UIResource,
    TableCellRenderer {
        private final Border b = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.b);
            }
            return this;
        }
    }

    class UserTreeTableModel
    extends DefaultTreeTableModel
    implements PaginationSupport {
        private final String[] b;
        private int c;
        private int d;
        private int e;

        public UserTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
            super((TreeTableNode)defaultMutableTreeTableNode);
            this.b = new String[]{POSConstants.ID, "Image", POSConstants.FIRST_NAME, POSConstants.LAST_NAME, POSConstants.TYPE, "Active", "Has Staff Bank", "Auto Start Staff Bank", "Can receive tips", "Driver"};
            this.e = 50;
        }

        public void setRoot(TreeTableNode treeTableNode) {
            super.setRoot(treeTableNode);
        }

        public int getColumnCount() {
            return this.b.length;
        }

        public String getColumnName(int n) {
            return this.b[n];
        }

        public boolean isCellEditable(Object object, int n) {
            return false;
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof DefaultMutableTreeTableNode) {
                User user = (User)((DefaultMutableTreeTableNode)object).getUserObject();
                if (user == null) {
                    return "";
                }
                boolean bl = user.isRoot() == false;
                switch (n) {
                    case 0: {
                        return bl ? "" : String.valueOf(user.getId());
                    }
                    case 1: {
                        return bl ? "" : user.getImage();
                    }
                    case 2: {
                        return bl ? "" : user.getFirstName();
                    }
                    case 3: {
                        return bl ? "" : user.getLastName();
                    }
                    case 4: {
                        return user.getType();
                    }
                    case 5: {
                        return user.isActive();
                    }
                    case 6: {
                        return user.isStaffBank();
                    }
                    case 7: {
                        return user.isAutoStartStaffBank();
                    }
                    case 8: {
                        return user.isAllowReceiveTips();
                    }
                    case 9: {
                        return user.isDriver();
                    }
                }
            }
            return null;
        }

        @Override
        public int getNumRows() {
            return this.c;
        }

        @Override
        public void setNumRows(int n) {
            this.c = n;
        }

        @Override
        public int getCurrentRowIndex() {
            return this.d;
        }

        @Override
        public void setCurrentRowIndex(int n) {
            this.d = n;
        }

        @Override
        public int getPageSize() {
            return this.e;
        }

        @Override
        public void setPageSize(int n) {
            this.e = n;
        }

        @Override
        public boolean hasNext() {
            return this.d + this.e < this.c;
        }

        @Override
        public boolean hasPrevious() {
            return this.d > 0;
        }

        @Override
        public int getNextRowIndex() {
            if (this.c == 0) {
                return 0;
            }
            return this.getCurrentRowIndex() + this.getPageSize();
        }

        @Override
        public int getPreviousRowIndex() {
            int n = this.getCurrentRowIndex() - this.getPageSize();
            if (n < 0) {
                n = 0;
            }
            return n;
        }

        @Override
        public void setRows(List list) {
        }
    }
}

