/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.ui.model.MultipleCustomerSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class CustomerSelectionDialog
extends POSDialog
implements ActionListener {
    private MultipleCustomerSelectionView a;
    private List<Customer> b;
    private boolean c;
    private TitlePanel d;
    private static CustomerSelectionDialog e;

    public CustomerSelectionDialog(JDialog jDialog, List<Customer> list) {
        super(jDialog, "", true);
        this.b = list;
        this.a();
    }

    public CustomerSelectionDialog(List<Customer> list) {
        super(POSUtil.getFocusedWindow(), "");
        this.b = list;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(Messages.getString("CustomerSelectionDialog.1"));
        this.d = new TitlePanel();
        this.d.setTitle(Messages.getString("CustomerSelectionDialog.4"));
        this.add((Component)this.d, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.a = new MultipleCustomerSelectionView(this.b);
        jPanel.add((Component)this.a, "grow,span,wrap");
        PosButton posButton = new PosButton("SELECT");
        posButton.setActionCommand(POSConstants.OK);
        posButton.setBackground(Color.GREEN);
        posButton.setFocusable(false);
        posButton.addActionListener(this);
        PosButton posButton2 = new PosButton(POSConstants.CANCEL);
        posButton2.setFocusable(false);
        posButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton posButton3 = new PosButton();
        PosButton posButton4 = new PosButton();
        posButton4.setText(POSConstants.ADD.toUpperCase());
        posButton3.setText(POSConstants.EDIT.toUpperCase());
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerSelectionDialog.this.d();
            }
        });
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = true;
                    CustomerForm customerForm = new CustomerForm(bl);
                    customerForm.enableCustomerFields(true);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog(customerForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    Customer customer = (Customer)customerForm.getBean();
                    CustomerSelectionDialog.this.a.getModel().addRow(customer);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jPanel2.add(posButton4);
        jPanel2.add(posButton3);
        jPanel2.add(posButton);
        jPanel2.add(posButton2);
        this.add((Component)jPanel2, "South");
        this.add(jPanel);
    }

    public void setSingleSelectionEnable(boolean bl) {
        this.c = bl;
        if (bl) {
            this.d.setTitle(Messages.getString("CustomerSelectionDialog.9"));
        }
        this.a.setSingleSelectionEnable(bl);
    }

    public void setSelectedGroup(CustomerGroup customerGroup) {
        this.a.setSelectedGroup(customerGroup);
    }

    private void b() {
        if (this.c) {
            Customer customer = this.getSelectedRowData();
            if (customer == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerSelectionDialog.10"));
                return;
            }
        } else {
            List<Customer> list = this.a.getSelectedCustomerList();
            if (list == null || list.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerSelectionDialog.11"));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(string)) {
            this.c();
        } else if (POSConstants.OK.equalsIgnoreCase(string)) {
            this.b();
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            Customer customer = this.a.getModel().getRow(n);
            CustomerForm customerForm = new CustomerForm();
            customerForm.enableCustomerFields(true);
            customerForm.setBean(customer);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(customerForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public List<Customer> getSelectedCustomerList() {
        return this.a.getSelectedCustomerList();
    }

    public Customer getSelectedRowData() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.a.getModel().getRow(n);
    }

    public static CustomerSelectionDialog getInstance(List<Customer> list, boolean bl) {
        if (e == null) {
            e = new CustomerSelectionDialog(list);
            e.setSingleSelectionEnable(bl);
        }
        return e;
    }
}

