/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ImagePanel;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public class CustMonitorConfigurationDialog
extends POSDialog
implements ActionListener {
    private JRadioButton a;
    private JRadioButton b;
    private JRadioButton c;
    private JTextField d;
    private Store e;
    private ButtonGroup f;
    private JPanel g;
    private PaginatedTableModel h;
    private JButton i;
    private JButton j;
    private ImageResource k;

    public CustMonitorConfigurationDialog() {
        this.setTitle(AppProperties.getAppName());
        this.h = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return null;
            }
        };
        this.h.setRows(new ArrayList());
        this.h.setPageSize(10);
        this.h.setNumRows(SlideShowImageDAO.getInstance().rowCount());
        this.a();
        this.e();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Customer monitor configuration:");
        this.add((Component)titlePanel, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add(jTabbedPane);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.add((Component)jPanel, "South");
        PosButton posButton = new PosButton("Save");
        PosButton posButton2 = new PosButton("Close");
        posButton.addActionListener(actionEvent -> this.d());
        posButton2.addActionListener(actionEvent -> {
            this.setCanceled(true);
            this.dispose();
        });
        jPanel.add(posButton);
        jPanel.add(posButton2);
        jTabbedPane.addTab("General", this.c());
        jTabbedPane.addTab("Image", this.b());
    }

    private JPanel b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.g = new JPanel();
        this.g = new JPanel(new WrapLayout());
        this.g.setBorder(BorderFactory.createLineBorder(Color.gray));
        JScrollPane jScrollPane = new JScrollPane(this.g, 20, 30);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx"));
        PosButton posButton = new PosButton("Add");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustMonitorConfigurationDialog.this.f();
            }
        });
        PosButton posButton2 = new PosButton("Remove");
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustMonitorConfigurationDialog.this.doRemoveSlideImage();
            }
        });
        this.i = new JButton("<<<");
        this.j = new JButton(">>>");
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustMonitorConfigurationDialog.this.h.setCurrentRowIndex(CustMonitorConfigurationDialog.this.h.getNextRowIndex());
                CustMonitorConfigurationDialog.this.a(true);
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustMonitorConfigurationDialog.this.h.setCurrentRowIndex(CustMonitorConfigurationDialog.this.h.getPreviousRowIndex());
                CustMonitorConfigurationDialog.this.a(true);
            }
        });
        this.i.setEnabled(false);
        jPanel2.add((Component)posButton, "split 2");
        jPanel2.add(posButton2);
        jPanel2.add((Component)this.i, "right, split 2");
        jPanel2.add(this.j);
        jPanel.add(jScrollPane);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void doRemoveSlideImage() {
        if (this.k == null) {
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to delete this item?", "Delete");
        if (n != 0) {
            return;
        }
        try {
            SlideShowImageDAO slideShowImageDAO;
            SlideShowImage slideShowImage;
            if (this.k.getId() != null && (slideShowImage = (slideShowImageDAO = SlideShowImageDAO.getInstance()).findByImageId(this.k.getId())) != null) {
                slideShowImageDAO.delete(slideShowImage);
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Image successfully deleted!");
            this.h.deleteItem(this.k);
            this.a(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", "[][]", ""));
        this.f = new ButtonGroup();
        this.a = new JRadioButton("Show item image");
        this.b = new JRadioButton("Show slide show");
        this.c = new JRadioButton("Show item image and slide show");
        this.f.add(this.a);
        this.f.add(this.b);
        this.f.add(this.c);
        JLabel jLabel = new JLabel("Slide duration:");
        this.d = new JTextField();
        jPanel.add((Component)this.a, "wrap");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)jLabel, "split 3");
        jPanel.add((Component)this.d, "grow");
        jPanel.add(new JLabel("sec"));
        return jPanel;
    }

    private void d() {
        try {
            int n = 0;
            if (this.a.isSelected()) {
                n = 0;
            } else if (this.b.isSelected()) {
                n = 1;
            } else if (this.c.isSelected()) {
                n = 2;
            }
            String string = this.d.getText();
            this.e.addProperty("customer.monitor.display.option", String.valueOf(n));
            this.e.addProperty("customer.monitor.slide.duration", string);
            StoreDAO.getInstance().saveOrUpdate(this.e);
            List<ImageResource> list = this.h.getRows();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ImageResource imageResource = (ImageResource)iterator.next();
                    SlideShowImage slideShowImage = SlideShowImageDAO.getInstance().findByImageId(imageResource.getId());
                    if (slideShowImage == null) continue;
                    iterator.remove();
                }
                SlideShowImageDAO.getInstance().saveAll(list);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() {
        this.e = DataProvider.get().getStore();
        int n = this.e.getCustomerMonitorDisplayOption();
        switch (n) {
            case 0: {
                this.a.setSelected(true);
                break;
            }
            case 1: {
                this.b.setSelected(true);
                break;
            }
            case 2: {
                this.c.setSelected(true);
                break;
            }
        }
        int n2 = this.e.getCustomerMonitorDisplaySlideDuration();
        this.d.setText("" + n2);
        this.a(true);
    }

    private void f() {
        try {
            ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
            imageGalleryDialog.setTitle("Image Gallery");
            imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
            imageGalleryDialog.setResizable(false);
            imageGalleryDialog.open();
            if (imageGalleryDialog.isCanceled()) {
                return;
            }
            ImageResource imageResource = imageGalleryDialog.getImageResource();
            this.h.addItem(imageResource);
            this.a(false);
        }
        catch (PosException posException) {
            JOptionPane.showMessageDialog(null, posException.getMessage(), "Error", 0);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            JOptionPane.showMessageDialog(null, "Unexpected error", "Error", 0);
        }
    }

    private void a(boolean bl) {
        this.g.removeAll();
        this.g.revalidate();
        this.g.repaint();
        if (bl) {
            SlideShowImageDAO.getInstance().getImages(this.h);
        }
        List list = this.h.getRows();
        ButtonGroup buttonGroup = new ButtonGroup();
        if (list != null) {
            for (ImageResource imageResource : list) {
                ImagePanel imagePanel = new ImagePanel(this, imageResource, buttonGroup);
                this.g.add((Component)imagePanel, "aligny, top");
            }
        }
        this.i.setEnabled(this.h.hasPrevious());
        this.j.setEnabled(this.h.hasNext());
        this.g.revalidate();
        this.g.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        if (jToggleButton.isSelected()) {
            this.k = (ImageResource)jToggleButton.getClientProperty("selected");
        }
    }
}

