/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.util.LicenseValidationUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.InvalidPluginDialog;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFloreantPlugin
implements FloreantPlugin,
LicenseSelectionListener {
    private OroLicense a;

    @Override
    public boolean requireLicense() {
        return true;
    }

    @Override
    public void initLicense() {
        String string = this.getProductName() + ".license.pin";
        try {
            this.a = LicenseUtil.loadAndValidate((String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            if (this.a.isDemoLicense()) {
                boolean bl = LicenseValidationUtil.doCheckPinNumber(this.a, string, true);
                this.a.setPinVarified(bl);
            }
        }
        catch (InvalidLicenseException invalidLicenseException) {
            LogFactory.getLog(this.getClass()).error((Object)invalidLicenseException);
            InvalidPluginDialog.show((LicenseSelectionListener)this, (Component)Application.getPosWindow(), (String)invalidLicenseException.getMessage(), (String)"Plugin error!", (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
        }
    }

    @Override
    public abstract String getId();

    public abstract String getProductName();

    public abstract String getProductVersion();

    public abstract Component getParent();

    public void licenseFileSelected(File file) throws Exception {
        try {
            OroLicense oroLicense = LicenseUtil.loadAndValidate((File)file, (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            LicenseUtil.copyLicenseFile((File)file, (String)this.getProductName());
            this.setLicense(oroLicense);
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
            throw exception;
        }
    }

    @Override
    public boolean hasValidLicense() {
        if (this.a != null) {
            if (this.a.isDemoLicense()) {
                return this.a.isValid() && this.a.isPinVarified();
            }
            return this.a.isValid();
        }
        return false;
    }

    public OroLicense getLicense() {
        return this.a;
    }

    public void setLicense(OroLicense oroLicense) {
        this.a = oroLicense;
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog jDialog) {
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public List<ConfigurationSubEditor> getSubEditors() {
        return null;
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    public void restartPOS(boolean bl) {
    }
}

