/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.mailservices;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.AESencrp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;

public class MailService {
    public static void checkEmailConfiguration() throws Exception {
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        String string = terminal.getSmtpHost();
        String string2 = terminal.getSmtpSender();
        String string3 = terminal.getSmtpPassword();
        String string4 = null;
        if (!StringUtils.isEmpty((String)string3)) {
            string4 = AESencrp.decrypt(string3);
        }
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException("SMTP Host not found! Please set configuration!");
        }
        if (StringUtils.isEmpty((String)string2)) {
            throw new PosException("Sender email not found! Please set configuration!");
        }
        if (StringUtils.isEmpty((String)string4)) {
            throw new PosException("Password not found! Please set configuration!");
        }
    }

    public static void sendTicket(String string, Ticket ticket) throws Exception {
        if (!MailService.isValidEmail(string)) {
            throw new PosException("Invalid email address");
        }
        MailService.checkEmailConfiguration();
        byte[] byArray = ReceiptPrintService.createPDFStream(ticket);
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, "application/pdf");
        if (!MailService.sendMail(string, "Ticket Receipt", "Ticket Receipt", "TICKET_RECEIPT_" + ticket.getId() + ".pdf", byteArrayDataSource)) {
            throw new PosException("Email sending failed.");
        }
    }

    public static boolean isValidEmail(String string) {
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static boolean sendMail(String string, String string2, String string3, String string4, ByteArrayDataSource byteArrayDataSource) {
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            String string5 = terminal.getSmtpHost();
            Integer n = terminal.getSmtpPort();
            String string6 = terminal.getSmtpSender();
            String string7 = terminal.getSmtpPassword();
            if (string7 != null) {
                string7 = AESencrp.decrypt(string7);
            }
            return MailService.sendMail(string5, n, string6, string7, string, string2, string3, string4, byteArrayDataSource);
        }
        catch (Exception exception) {
            PosLog.error(MailService.class, exception);
            return false;
        }
    }

    public static boolean sendMail(String string, Integer n, final String string2, final String string3, String string4, String string5, String string6, String string7, final ByteArrayDataSource byteArrayDataSource) {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", string);
        properties.put("mail.smtp.socketFactory.port", String.valueOf(n));
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.port", String.valueOf(n));
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string2, string3);
            }
        });
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(string2));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string4));
            mimeMessage.setSubject(string5);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string6);
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            DataSource dataSource = new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return byteArrayDataSource.getOutputStream();
                }

                public String getName() {
                    return byteArrayDataSource.getName();
                }

                public InputStream getInputStream() throws IOException {
                    return byteArrayDataSource.getInputStream();
                }

                public String getContentType() {
                    return byteArrayDataSource.getContentType();
                }
            };
            MimeMultipart mimeMultipart = new MimeMultipart();
            if (byteArrayDataSource != null) {
                mimeBodyPart2.setDataHandler(new DataHandler(dataSource));
                mimeBodyPart2.setFileName(string7);
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            }
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            mimeMessage.setContent((Multipart)mimeMultipart);
            Transport.send((Message)mimeMessage);
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (MessagingException messagingException) {
            throw new RuntimeException(messagingException);
        }
    }

    public static void main(String[] stringArray) {
        MailService.sendMail("cto@orocube.net", "Test", "Test", "Test", null);
    }
}

