/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UpdateNotificationDialog;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateService;
import com.floreantpos.update.ZipUtil;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class UpdateManager
implements UpdateListener {
    public static final String SOFTWARE_NUMERIC_VERSION = "software.numeric.version";
    public static final String HAS_UPDATE = "has_update";
    public static final String FORCE_UPDATE = "force_update";
    private JFrame a;

    public JFrame getParentWindow() {
        return this.a;
    }

    public void setParentWindow(JFrame jFrame) {
        this.a = jFrame;
    }

    public void checkForUpdate() {
        String string = Application.getInstance().getUpdateServerURL();
        String string2 = VersionInfo.getAppName();
        String string3 = VersionInfo.getVersion();
        int n = VersionInfo.getNumericVersion();
        UpdateService.checkForUpdate((Component)this.a, (UpdateListener)this, (String)string, (String)string2, (String)string3, (int)n);
    }

    public boolean isUpdateAvailble() {
        String string = Application.getInstance().getUpdateServerURL();
        String string2 = VersionInfo.getAppName();
        String string3 = VersionInfo.getVersion();
        int n = VersionInfo.getNumericVersion();
        return UpdateService.isUpdateAvailable((Component)this.a, (UpdateListener)this, (String)string, (String)string2, (String)string3, (int)n);
    }

    public void checkHasRemainingUpdates() {
        if (!AppConfig.getBoolean(HAS_UPDATE, false)) {
            return;
        }
        if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
            try {
                OroMqttClient oroMqttClient = OroMqttClient.getInstance();
                oroMqttClient.initMqttClient();
                this.sendUpdateNotification("MESSAGE", "Software update", "Software will automatically restart for an update in 30sec.");
                PosLog.debug(this.getClass(), "mqtt client started");
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
            UpdateNotificationDialog.showUpdatePromptDialog("Update info");
        }
        this.runUpdateProcess();
        AppConfig.removeProperty(HAS_UPDATE);
        System.exit(0);
    }

    public void sendUpdateNotification(String string, String string2, String string3) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("action", (Object)string);
        jSONObject.put("content", (Object)string2);
        jSONObject.put("msg", (Object)string3);
        jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
        jSONObject.put("terminalAppNumericVersion", VersionInfo.getNumericVersion());
        OroMqttClient.getInstance().publishData("auto-update-service", jSONObject.toString());
    }

    public void runUpdateProcess() {
        UpdateManager.extractLatestUpdater();
        try {
            File file = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            String string = URLDecoder.decode(file.getPath(), "UTF-8");
            String string2 = string.replace(file.getName(), "auto-updater.jar");
            String string3 = VersionInfo.getAppName();
            System.out.println(string);
            System.out.println(string2);
            ProcessBuilder processBuilder = new ProcessBuilder("java", "-cp", string2, "com.floreantpos.update.UpdateServiceWindow", string, string3);
            processBuilder.start();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractLatestUpdater() {
        try {
            String string = VersionInfo.getAppName();
            string = string.replaceAll("\\W+", "_").toLowerCase();
            String string2 = System.getProperty("java.io.tmpdir") + "/" + string + "/" + string + ".zip";
            try (ZipFile zipFile = new ZipFile(string2);){
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string3;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string4 = zipEntry.getName();
                    if (!string4.startsWith("lib") || !string4.contains("auto-updater")) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    File file = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    if (!file.isFile()) {
                        return;
                    }
                    file = file.getParentFile();
                    String string5 = string3 = URLDecoder.decode(file.getPath(), "UTF-8");
                    PosLog.debug(UpdateManager.class, "decode parent path: " + string3);
                    PosLog.debug(UpdateManager.class, "auto updater destination: " + string5);
                    File file2 = new File(string5, "auto-updater.jar");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ZipUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                    try {
                        inputStream.close();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        PosLog.error(UpdateManager.class, iOException);
                    }
                    PosLog.debug(UpdateManager.class, "Success");
                    break;
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(UpdateManager.class, exception);
        }
    }

    public void publishIfNewUpdateAvailable() {
        boolean bl = AppConfig.getBoolean(FORCE_UPDATE, false);
        if (bl) {
            AppConfig.removeProperty(FORCE_UPDATE);
            AppConfig.removeProperty("last_app_version");
            return;
        }
        AppConfig.removeProperty(FORCE_UPDATE);
        int n = AppConfig.getInt("last_app_version", VersionInfo.getNumericVersion());
        if (VersionInfo.getNumericVersion() > n) {
            Store store = StoreDAO.getRestaurant();
            store.setSoftwareVersion(VersionInfo.getVersion());
            store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
            this.sendUpdateNotification("UPDATE", "Software has been updated", "");
            AppConfig.removeProperty(HAS_UPDATE);
            AppConfig.removeProperty("last_app_version");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    POSMessageDialog.showMessage(UpdateManager.this.a, "Software has been update to version " + VersionInfo.getVersion());
                }
            });
        }
    }

    public void downloadComplete() {
        try {
            AppConfig.put(HAS_UPDATE, true);
            AppConfig.putInt("last_app_version", VersionInfo.getNumericVersion());
            final POSDialog pOSDialog = new POSDialog((Frame)this.a, true);
            PosButton posButton = new PosButton("Restart now");
            posButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    pOSDialog.dispose();
                }
            });
            JLabel jLabel = new JLabel("Download complete. System will restart in 5 sec.");
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(jLabel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(posButton);
            pOSDialog.add(jPanel);
            pOSDialog.add((Component)jPanel2, "South");
            pOSDialog.setSize(PosUIManager.getSize(400, 150));
            pOSDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    Timer timer = new Timer(5000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            pOSDialog.dispose();
                        }
                    });
                    timer.start();
                }
            });
            pOSDialog.open();
            Main.restart();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this.a, exception.getMessage(), exception);
        }
    }

    public void updateComplete() {
    }

    public void updateCanceled() {
        Store store = StoreDAO.getRestaurant();
        int n = POSUtil.parseInteger(store.getProperty(SOFTWARE_NUMERIC_VERSION, String.valueOf(VersionInfo.getNumericVersion())));
        if (VersionInfo.getNumericVersion() < n) {
            System.exit(0);
        }
    }

    public void startDownload() {
        String string = VersionInfo.getAppName().replaceAll("\\W+", "_").toLowerCase();
        UpdateService.startDownload((Component)Application.getPosWindow(), (UpdateListener)new UpdateListener(){

            public void updateComplete() {
            }

            public void downloadComplete() {
                try {
                    AppConfig.put(UpdateManager.HAS_UPDATE, true);
                    AppConfig.put(UpdateManager.FORCE_UPDATE, true);
                    AppConfig.putInt("last_app_version", VersionInfo.getNumericVersion());
                    Main.restart();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }

            public void updateCanceled() {
            }
        }, (String)Application.getInstance().getUpdateServerURL(), (String)string);
    }

    public void subscribeToUpdateService(OroMqttClient oroMqttClient, String string) throws Exception {
        oroMqttClient.subscribe(string + "auto-update-service", 0, new IMqttMessageListener(){

            public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
                PosLog.debug(this.getClass(), "Update message received");
                String string2 = new String(mqttMessage.getPayload());
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.getString("terminalKey");
                PosLog.debug(this.getClass(), "Update notification from terminal " + string3);
                if (string3.equals(TerminalUtil.getSystemUID())) {
                    return;
                }
                Action action = Action.valueOf(jSONObject.getString("action"));
                Object object = jSONObject.get("content");
                Object object2 = jSONObject.get("msg");
                Toolkit.getDefaultToolkit().beep();
                switch (action) {
                    case MESSAGE: {
                        PosLog.debug(this.getClass(), "going to show that software will be updated");
                        UpdateNotificationDialog.showMessage(object.toString(), object2.toString(), false);
                        break;
                    }
                    case UPDATE: {
                        if (String.valueOf(VersionInfo.getNumericVersion()).equals(StoreDAO.getRestaurant().getSoftwareVersion())) {
                            return;
                        }
                        UpdateNotificationDialog updateNotificationDialog = UpdateNotificationDialog.getInstance(object.toString(), object2.toString(), true);
                        updateNotificationDialog.setUpdateButtonVisible(false);
                        updateNotificationDialog.startUpdating();
                    }
                }
            }
        });
    }

    public void checkVersionCompatibility(Integer n, String string, Integer n2) {
        try {
            boolean bl;
            Integer n3 = VersionInfo.getNumericVersion();
            Integer n4 = 170;
            boolean bl2 = bl = n2 != null && n2 > n3;
            if (bl || n != null && n > n4) {
                String string2 = "Some other terminal is running updated version of the software.\nTo continue, you must update to version %s or later.\nDo you want to update now?.";
                string2 = String.format(string2, string);
                String string3 = null;
                string3 = TerminalConfig.isShowDbConfigureButton() ? POSMessageDialog.showOptionDialog(Application.getPosWindow(), string2, "Update required", "Yes", "Use different database", "No") : POSMessageDialog.showOptionDialog(Application.getPosWindow(), string2, "Update required", "Yes", "No");
                if (string3 == null || string3.equals("No")) {
                    POSMessageDialog.showError(Application.getPosWindow(), "System will now shutdown.");
                    System.exit(1);
                } else if (string3.equals("Yes")) {
                    this.startDownload();
                } else {
                    DatabaseConfigurationDialog databaseConfigurationDialog = DatabaseConfigurationDialog.show(Application.getPosWindow());
                    if (databaseConfigurationDialog.isCanceled()) {
                        POSMessageDialog.showError(Application.getPosWindow(), "System will now shutdown.");
                        System.exit(1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performDatabaseUpgrade() throws Exception {
        String string;
        boolean bl;
        Database database = AppConfig.getDefaultDatabase();
        String string2 = AppConfig.getConnectString();
        String string3 = AppConfig.getDatabaseUser();
        String string4 = AppConfig.getDatabasePassword();
        String string5 = database.getHibernateConnectionDriverClass();
        Map<String, String> map = DatabaseUtil.getStoreProperties(string2, string5, string3, string4);
        String string6 = map.get("software.version");
        Integer n = null;
        Integer n2 = null;
        try {
            n = Integer.parseInt(map.get("database.version"));
            n2 = Integer.parseInt(map.get(SOFTWARE_NUMERIC_VERSION));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkVersionCompatibility(n, string6, n2);
        if (!DatabaseUtil.isDbUpdateNeeded(n)) {
            return;
        }
        String string7 = Messages.getString("DB_UPGRADE_REQUIRED");
        String string8 = Messages.getString("ALERT");
        int n3 = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string7, string8);
        if (n3 != 0) {
            return;
        }
        string7 = Messages.getString("DB_UPGRADE_ALERT_MESSAGE");
        n3 = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string7, string8);
        if (n3 != 0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SHUTDOWN_MESSAGE"));
            System.exit(1);
        }
        if (bl = DatabaseUtil.updateDatabase(string2, string = database.getHibernateDialect(), string5, string3, string4)) {
            JOptionPane.showMessageDialog(Application.getPosWindow(), Messages.getString("DB_UPGRADE_SUCCESS"));
            Main.restart();
        } else {
            JOptionPane.showMessageDialog(Application.getPosWindow(), Messages.getString("DatabaseConfigurationDialog.3"));
        }
    }

    static enum Action {
        MESSAGE,
        UPDATE;

    }
}

