/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseBookingInfo;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;

public class BookingInfo
extends BaseBookingInfo {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_CANCEL = "cancel";
    public static final String STATUS_CLOSE = "close";
    public static final String STATUS_NO_APR = "no appear";
    public static final String STATUS_SEAT = "seat";
    public static final String STATUS_DELAY = "delay";
    public static final String STATUS_OPEN = "open";
    public static final String STATUS_CONFIRM = "confirm";
    private String customerInfo;
    private String bookedTableNumbers;
    private Customer customer;
    private User user;

    public BookingInfo() {
    }

    public BookingInfo(String string) {
        super(string);
    }

    @Override
    public String toString() {
        return this.getId().toString();
    }

    public void setUser(User user) {
        this.setUserId(user == null ? null : user.getId());
        this.user = user;
    }

    public User getUser() {
        String string = this.getUserId();
        if (string == null) {
            return null;
        }
        if (this.user != null && string.equals(this.user.getId())) {
            return this.user;
        }
        return DataProvider.get().getUserById(string);
    }

    public void setCustomer(Customer customer) {
        if (customer == null) {
            this.setCustomerId(null);
        } else {
            this.setCustomerId(customer.getId());
        }
        this.customer = customer;
    }

    public Customer getCustomer() {
        String string = this.getCustomerId();
        if (string == null) {
            return null;
        }
        if (this.customer != null && string.equals(this.customer.getId())) {
            return this.customer;
        }
        return DataProvider.get().getCustomer(string);
    }

    public String getCustomerInfo() {
        Customer customer = this.getCustomer();
        if (customer == null) {
            return this.customerInfo;
        }
        if (!customer.getFirstName().equals("")) {
            this.customerInfo = customer.getFirstName();
            return this.customerInfo;
        }
        if (!customer.getMobileNo().equals("")) {
            this.customerInfo = customer.getMobileNo();
            return this.customerInfo;
        }
        if (!customer.getLoyaltyNo().equals("")) {
            this.customerInfo = customer.getLoyaltyNo();
            return this.customerInfo;
        }
        return this.customerInfo;
    }

    public void setCustomerInfo(String string) {
        this.customerInfo = string;
    }

    public String getBookedTableNumbers() {
        if (this.bookedTableNumbers != null) {
            return this.bookedTableNumbers;
        }
        List<ShopTable> list = this.getTables();
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string = "";
        Iterator<ShopTable> iterator = list.iterator();
        while (iterator.hasNext()) {
            ShopTable shopTable = iterator.next();
            string = string + shopTable.getTableNumber();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string;
    }

    public void setBookedTableNumbers(String string) {
        this.bookedTableNumbers = string;
    }

    public BookingInfo clone(BookingInfo bookingInfo) {
        return (BookingInfo)SerializationUtils.clone((Serializable)bookingInfo);
    }
}

