/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseImageResource;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.ImageIcon;

public class ImageResource
extends BaseImageResource {
    private static final long serialVersionUID = 1L;
    private Image image;

    public ImageResource() {
    }

    public ImageResource(String string) {
        super(string);
    }

    public IMAGE_CATEGORY getImageCategory() {
        return IMAGE_CATEGORY.fromInt(super.getImageCategoryNum());
    }

    public void setImageCategory(IMAGE_CATEGORY iMAGE_CATEGORY) {
        super.setImageCategoryNum(iMAGE_CATEGORY.getType());
    }

    @Override
    public void setImageData(Blob blob) {
        super.setImageData(blob);
        if (blob != null) {
            try {
                int n = (int)blob.length();
                this.image = new ImageIcon(blob.getBytes(1L, n)).getImage();
            }
            catch (SQLException sQLException) {
                PosLog.error(this.getClass(), sQLException);
            }
        }
    }

    public ImageIcon getScaledImage(int n, int n2) {
        Image image = null;
        if (this.image != null) {
            image = this.image.getScaledInstance(n, n2, 4);
            return new ImageIcon(image);
        }
        return null;
    }

    public Image getImage() {
        return this.image;
    }

    public ImageIcon getAsIcon() {
        if (this.image == null) {
            return null;
        }
        return new ImageIcon(this.image.getScaledInstance(80, 80, 1));
    }

    public static enum IMAGE_CATEGORY {
        UNLISTED(0),
        FLOORPLAN(1),
        PRODUCTS(2),
        PEOPLE(3),
        DELETED(4);

        private int type;

        private IMAGE_CATEGORY(int n2) {
            this.type = n2;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public static IMAGE_CATEGORY fromInt(int n) {
            IMAGE_CATEGORY[] iMAGE_CATEGORYArray;
            for (IMAGE_CATEGORY iMAGE_CATEGORY : iMAGE_CATEGORYArray = IMAGE_CATEGORY.values()) {
                if (iMAGE_CATEGORY.type != n) continue;
                return iMAGE_CATEGORY;
            }
            return UNLISTED;
        }
    }
}

