/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.Department;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.base.BaseMenuCategory;
import java.awt.Color;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "menuGroups", "discounts", "orderTypes", "departments", "terminalTypes", "menuShifts"})
@XmlRootElement(name="menu-category")
public class MenuCategory
extends BaseMenuCategory {
    private static final long serialVersionUID = 1L;
    private Color buttonColor;
    private Color textColor;

    public MenuCategory() {
    }

    public MenuCategory(String string) {
        super(string);
    }

    public MenuCategory(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null || this.getButtonColorCode() == 0) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null || this.getTextColorCode() == 0) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    @Override
    @XmlTransient
    public Set<Department> getDepartments() {
        return super.getDepartments();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public String getUniqueId() {
        return ("menu_category_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }
}

