/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.base.BaseMenuItemModifierPageItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import java.awt.Color;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"menuModifier"})
public class MenuItemModifierPageItem
extends BaseMenuItemModifierPageItem {
    private static final long serialVersionUID = 1L;
    private transient ImageIcon image;
    private transient Color buttonColor;
    private transient Color textColor;
    private final String randomId = UUID.randomUUID().toString();

    public MenuItemModifierPageItem() {
    }

    public MenuItemModifierPageItem(String string) {
        super(string);
    }

    public MenuItemModifierPageItem(Integer n, Integer n2) {
        super.setCol(n);
        super.setRow(n2);
    }

    public MenuItemModifierPageItem(Integer n, Integer n2, MenuModifier menuModifier, MenuItemModifierPage menuItemModifierPage) {
        super.setCol(n);
        super.setRow(n2);
        this.setMenuModifier(menuModifier);
        this.setParentPage(menuItemModifierPage);
    }

    public void setParentPage(MenuItemModifierPage menuItemModifierPage) {
        if (menuItemModifierPage != null) {
            this.setParentPageId(menuItemModifierPage.getId());
        } else {
            this.setParentPageId(null);
        }
    }

    public MenuModifier getMenuModifier() {
        if (StringUtils.isNotEmpty((String)this.getMenuModifierId())) {
            return MenuModifierDAO.getInstance().get(this.getMenuModifierId());
        }
        return null;
    }

    public void setMenuModifier(MenuModifier menuModifier) {
        if (menuModifier != null) {
            this.setMenuModifierId(menuModifier.getId());
            this.setMenuModifierName(menuModifier.getDisplayName());
            this.setButtonColorCode(menuModifier.getButtonColor());
            this.setTextColorCode(menuModifier.getTextColor());
            this.setImageId(menuModifier.getImageId());
            this.setShowImageOnly(menuModifier.isShowImageOnly());
        } else {
            this.setMenuModifierId(null);
        }
    }

    public void setImage(ImageIcon imageIcon) {
        this.image = imageIcon;
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId(), 80, 80);
    }

    public ImageIcon getImage(int n, int n2) {
        return IconFactory.getIconFromImageResource(this.getImageId(), n - 20, n2 - 20);
    }

    public ImageIcon getScaledImageIcon(int n, int n2) {
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(this.getImageId());
        if (imageResource != null) {
            this.image = new ImageIcon(imageResource.getImage().getScaledInstance(n, n2, 1));
        }
        return this.image;
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public String getRandomId() {
        return this.randomId;
    }
}

