/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="printers")
public class PosPrinters {
    private String receiptPrinter;
    private Printer defaultKitchenPrinter;
    private List<Printer> kitchenPrinters = new ArrayList<Printer>(1);
    private List<Printer> reportPrinters = new ArrayList<Printer>(1);
    private List<Printer> receiptPrinters = new ArrayList<Printer>(1);
    private List<Printer> stickerPrinters = new ArrayList<Printer>(1);
    private List<Printer> labelPrinters = new ArrayList<Printer>(1);
    private boolean printToKds;

    public String getReceiptPrinter() {
        return this.receiptPrinter;
    }

    public List<Printer> getKitchenPrinters() {
        return this.kitchenPrinters;
    }

    @Deprecated
    public Printer getDefaultKitchenPrinter() {
        if (this.getKitchenPrinters().size() > 0) {
            this.defaultKitchenPrinter = this.kitchenPrinters.get(0);
            for (Printer printer : this.kitchenPrinters) {
                if (!printer.isDefaultPrinter()) continue;
                this.defaultKitchenPrinter = printer;
                break;
            }
        }
        return this.defaultKitchenPrinter;
    }

    public static PosPrinters load() {
        return PosPrinters.load(Application.getInstance().getTerminal());
    }

    public static PosPrinters load(Terminal terminal) {
        PosPrinters posPrinters = new PosPrinters();
        try {
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            for (TerminalPrinters terminalPrinters : list) {
                int n = terminalPrinters.getVirtualPrinter().getType();
                if (n == 0) {
                    posPrinters.reportPrinters.add(new Printer(terminalPrinters.getVirtualPrinter(), terminalPrinters.getPrinterName()));
                    continue;
                }
                if (n == 5) {
                    posPrinters.labelPrinters.add(new Printer(terminalPrinters.getVirtualPrinter(), terminalPrinters.getPrinterName()));
                    continue;
                }
                if (n == 1) {
                    posPrinters.receiptPrinter = terminalPrinters.getPrinterName();
                    posPrinters.receiptPrinters.add(new Printer(terminalPrinters.getVirtualPrinter(), terminalPrinters.getPrinterName()));
                    continue;
                }
                if (n == 2) {
                    posPrinters.kitchenPrinters.add(new Printer(terminalPrinters.getVirtualPrinter(), terminalPrinters.getPrinterName()));
                    continue;
                }
                if (n == 6) {
                    posPrinters.stickerPrinters.add(new Printer(terminalPrinters.getVirtualPrinter(), terminalPrinters.getPrinterName()));
                    continue;
                }
                Printer printer = new Printer(terminalPrinters.getVirtualPrinter(), terminalPrinters.getPrinterName());
                arrayList.add(printer);
            }
            if (posPrinters.receiptPrinter == null) {
                posPrinters.receiptPrinter = PosPrinters.getDefaultPrinterName();
            }
            posPrinters.printToKds = Boolean.valueOf(terminal.getProperty("kds_enabled", "false"));
        }
        catch (Exception exception) {
            PosLog.error(PosPrinters.class, exception);
        }
        return posPrinters;
    }

    public static String getDefaultPrinterName() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null) {
            return printService.getName();
        }
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServiceArray.length > 0) {
            return printServiceArray[0].getName();
        }
        return null;
    }

    public boolean isPrintToKds() {
        return this.printToKds;
    }

    public List<Printer> getReportPrinters() {
        return this.reportPrinters;
    }

    public List<Printer> getReceiptPrinters() {
        return this.receiptPrinters;
    }

    public List<Printer> getStickerPrinters() {
        return this.stickerPrinters;
    }

    public List<Printer> getLabelPrinters() {
        return this.labelPrinters;
    }
}

