/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseShift;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIgnoreProperties(ignoreUnknown=true, value={"dayOfWeekAsString"})
@XmlRootElement(name="shift")
public class Shift
extends BaseShift {
    private static final long serialVersionUID = 1L;
    private Date startTime;
    private Date endTime;

    public Shift() {
    }

    public Shift(String string) {
        super(string);
    }

    public Shift(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Long getShiftLength() {
        Long l = super.getShiftLength();
        if (l == null) {
            return Math.abs(this.getStartTime().getTime() - this.getEndTime().getTime());
        }
        return l;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(11, super.getStartHour());
            calendar.set(12, super.getStartMin());
            this.startTime = calendar.getTime();
        }
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            super.setStartHour(calendar.get(11));
            super.setStartMin(calendar.get(12));
        }
    }

    public Date getEndTime() {
        if (this.endTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(11, super.getEndHour());
            calendar.set(12, super.getEndMin());
            this.endTime = calendar.getTime();
        }
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            super.setEndHour(calendar.get(11));
            super.setEndMin(calendar.get(12));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Shift)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((Shift)object).getName());
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

