/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.util.GlobalIdGenerator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"typesAsString", "floor"})
public class ShopTable
extends BaseShopTable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_RECTANGLE = 0;
    public static final int TYPE_ROUNDED_RECTANGLE = 1;
    public static final int TYPE_ROUND = 2;
    public static final int TYPE_POLYGON = 3;
    public static final int TYPE_CUSTOM = 4;
    private String typesAsString;
    private Date ticketCreateTime;
    private boolean showStatus;
    private boolean reArrange;
    private int guestNumber;
    private boolean isTemporary;

    public TableStatus getTableStatus() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getTableStatus();
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.setTableStatusNum(tableStatus.getValue());
    }

    private void setTableStatusNum(int n) {
        ShopTableStatus shopTableStatus = this.getStatus();
        shopTableStatus.setTableStatusNum(n);
    }

    public ShopTable() {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer n) {
        super(n);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer n, String string) {
        super(n, string);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer n, Integer n2) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setX(n);
        this.setY(n2);
    }

    public ShopTable(ShopFloor shopFloor, Integer n, Integer n2, Integer n3) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setCapacity(4);
        this.setId(n3);
        this.setFloorId(shopFloor.getId());
        this.setX(n);
        this.setY(n2);
    }

    public Integer getTableNumber() {
        return this.getId();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTableNumber());
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean bl) {
        this.isTemporary = bl;
    }

    public String getTypesAsString() {
        List<ShopTableType> list = this.getTypes();
        String string = "";
        if (list == null || list.size() == 0) {
            return "";
        }
        boolean bl = false;
        for (ShopTableType shopTableType : list) {
            if (bl) {
                string = string + ", ";
            }
            string = string + shopTableType.getName();
            bl = true;
        }
        return string;
    }

    public void setTypesAsString(String string) {
        this.typesAsString = string;
    }

    public String getTicketId() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        List<String> list = shopTableStatus.getListOfTicketNumbers();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public String getUserId() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getUserId();
    }

    public String getUserName() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getUserName();
    }

    public String getTicketShortId() {
        ShopTableStatus shopTableStatus = this.getStatus();
        if (shopTableStatus == null) {
            return null;
        }
        return shopTableStatus.getTokenNo();
    }

    public ShopTableStatus getStatus() {
        ShopTableStatus shopTableStatus = super.getShopTableStatus();
        if (shopTableStatus != null) {
            return shopTableStatus;
        }
        return this.saveAndGetNewStatus();
    }

    public ShopTableStatus saveAndGetNewStatus() {
        ShopTableStatus shopTableStatus = new ShopTableStatus();
        Integer n = this.getId();
        shopTableStatus.setId(n);
        shopTableStatus.setTableStatus(TableStatus.Available);
        if (n != null) {
            ShopTableStatusDAO.getInstance().save(shopTableStatus);
        }
        this.setShopTableStatus(shopTableStatus);
        return shopTableStatus;
    }

    public Date getTicketCreateTime() {
        return this.ticketCreateTime;
    }

    public void setTicketCreateTime(Date date) {
        this.ticketCreateTime = date;
    }

    public boolean isShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(boolean bl) {
        this.showStatus = bl;
    }

    public boolean isReArrange() {
        return this.reArrange;
    }

    public void setReArrange(boolean bl) {
        this.reArrange = bl;
    }

    public int getGuestNumber() {
        return this.guestNumber;
    }

    public void setGuestNumber(int n) {
        this.guestNumber = n;
    }

    @XmlTransient
    public ShopFloor getFloor() {
        if (StringUtils.isNotEmpty((String)this.getFloorId())) {
            return ShopFloorDAO.getInstance().get(this.getFloorId());
        }
        return null;
    }

    public void setFloor(ShopFloor shopFloor) {
        String string = null;
        if (shopFloor != null) {
            string = shopFloor.getId();
        }
        super.setFloorId(string);
    }

    @XmlTransient
    public SalesArea getSalesArea() {
        if (StringUtils.isNotEmpty((String)this.getSalesAreaId())) {
            return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
        }
        return null;
    }

    public void setSalesArea(SalesArea salesArea) {
        String string = null;
        if (salesArea != null) {
            string = salesArea.getId();
        }
        super.setSalesAreaId(string);
    }
}

