/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public class TicketItemModifier
extends BaseTicketItemModifier
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_MODIFIER = 1;
    public static final int EXTRA_MODIFIER = 3;
    public static final int CRUST = 5;
    public static final int SEPERATOR = 6;
    public static final String TRANSIENT_PROP_TICKET_ITEM_QUANTITY = "ticketItemQuantity";
    public MenuModifier menuModifier;
    private boolean selected;
    private int tableRowNum;
    private double ticketItemQuantity;
    private List<TicketItemTax> taxes;

    public TicketItemModifier() {
    }

    public TicketItemModifier(String string) {
        super(string);
    }

    public TicketItemModifier(TicketItem ticketItem, String string, double d, double d2) {
        this.setTicketItem(ticketItem);
        this.setName(string);
        this.setUnitPrice(d);
        this.setItemQuantity(d2);
    }

    public TicketItemModifier(String string, TicketItem ticketItem, String string2, double d, double d2, TicketItemTax ticketItemTax) {
        this.setId(string);
        this.setTicketItem(ticketItem);
        this.setName(string2);
        this.setUnitPrice(d);
        this.setItemQuantity(d2);
        this.addTotaxes(ticketItemTax);
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    public void calculatePrice() {
        if (this.isInfoOnly().booleanValue()) {
            return;
        }
        BigDecimal bigDecimal = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal bigDecimal2 = NumberUtil.round(this.calculateSubTotal(bigDecimal));
        BigDecimal bigDecimal3 = NumberUtil.round(this.calculateDiscount(bigDecimal2));
        BigDecimal bigDecimal4 = NumberUtil.round(this.calculateTax(bigDecimal2, bigDecimal3));
        BigDecimal bigDecimal5 = BigDecimal.ZERO;
        BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal(0.0);
        TicketItem ticketItem = this.getTicketItem();
        if (ticketItem != null) {
            bigDecimal5 = ticketItem.calculateServiceCharge(bigDecimal2);
            if (ticketItem.isTaxOnServiceCharge().booleanValue()) {
                bigDecimal4 = NumberUtil.round(this.calculateTax(bigDecimal2.add(bigDecimal5), bigDecimal3));
            }
        }
        bigDecimal6 = this.isTaxIncluded() != false ? bigDecimal2.subtract(bigDecimal3) : bigDecimal2.subtract(bigDecimal3).add(bigDecimal4);
        bigDecimal6 = NumberUtil.round(bigDecimal6.add(bigDecimal5));
        this.setSubTotalAmount(bigDecimal2.doubleValue());
        this.setDiscountAmount(bigDecimal3.doubleValue());
        this.setTaxAmount(bigDecimal4.doubleValue());
        this.setServiceCharge(bigDecimal5.doubleValue());
        this.setTotalAmount(bigDecimal6.doubleValue());
        this.setAdjustedUnitPrice(this.getUnitPrice());
        this.setAdjustedDiscount(bigDecimal3.doubleValue());
        this.setAdjustedSubtotal(this.getSubTotalAmount());
        this.setAdjustedTax(this.getTaxAmount());
        this.setAdjustedTotal(this.getTotalAmount());
    }

    public void calculateAdjustedPrice() {
        Ticket ticket = this.getTicketItem().getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal bigDecimal = NumberUtil.convertToBigDecimal(this.getSubTotalAmount());
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(this.getDiscountAmount());
        BigDecimal bigDecimal3 = NumberUtil.round(bigDecimal.subtract(bigDecimal2));
        BigDecimal bigDecimal4 = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount()));
        BigDecimal bigDecimal5 = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems()));
        BigDecimal bigDecimal6 = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount()));
        BigDecimal bigDecimal7 = NumberUtil.round(bigDecimal5.subtract(bigDecimal6));
        BigDecimal bigDecimal8 = NumberUtil.round(bigDecimal7.subtract(bigDecimal4));
        BigDecimal bigDecimal9 = NumberUtil.round(bigDecimal3.multiply(bigDecimal8).divide(bigDecimal7, 4, RoundingMode.HALF_UP));
        BigDecimal bigDecimal10 = NumberUtil.round(bigDecimal.subtract(bigDecimal9));
        BigDecimal bigDecimal11 = NumberUtil.round(this.calculateTax(bigDecimal9, new BigDecimal("0")));
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal(0.0);
        bigDecimal12 = this.isTaxIncluded() != false ? bigDecimal9 : NumberUtil.round(bigDecimal9.add(bigDecimal11));
        bigDecimal12 = bigDecimal12.add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
        this.setAdjustedUnitPrice(bigDecimal9.divide(NumberUtil.convertToBigDecimal(this.getItemQuantity()), 4, RoundingMode.HALF_UP).doubleValue());
        this.setAdjustedDiscount(bigDecimal10.doubleValue());
        this.setAdjustedSubtotal(bigDecimal9.doubleValue());
        this.setAdjustedTax(bigDecimal11.doubleValue());
        this.setAdjustedTotal(bigDecimal12.doubleValue());
    }

    public double calculateDiscount(double d) {
        double d2 = 0.0;
        List<TicketItemDiscount> list = this.getTicketItem().getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    d2 += ticketItemDiscount.calculateDiscount(d);
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double d3 = ticketItemDiscount.getValue() * 100.0 / this.getTicketItem().getSubtotalAmount();
                TicketItemDiscount ticketItemDiscount2 = new TicketItemDiscount();
                ticketItemDiscount2.setType(1);
                ticketItemDiscount2.setValue(d3);
                ticketItemDiscount2.setTicketItem(this.getTicketItem());
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                d2 += ticketItemDiscount2.calculateDiscount(d);
            }
        }
        if (d2 > Math.abs(d)) {
            return d;
        }
        return d2;
    }

    public BigDecimal calculateDiscount(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> list = this.getTicketItem().getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    bigDecimal2 = bigDecimal2.add(ticketItemDiscount.calculateDiscount(bigDecimal));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double d = ticketItemDiscount.getValue() * 100.0 / this.getTicketItem().getSubtotalAmount();
                TicketItemDiscount ticketItemDiscount2 = new TicketItemDiscount();
                ticketItemDiscount2.setType(1);
                ticketItemDiscount2.setValue(d);
                ticketItemDiscount2.setTicketItem(this.getTicketItem());
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                bigDecimal2 = bigDecimal2.add(ticketItemDiscount2.calculateDiscount(bigDecimal));
            }
        }
        if (bigDecimal2.compareTo(bigDecimal.abs()) > 0) {
            return bigDecimal;
        }
        return NumberUtil.round(bigDecimal2);
    }

    public void merge(TicketItemModifier ticketItemModifier) {
        this.setItemQuantity(this.getItemQuantity() + ticketItemModifier.getItemQuantity());
    }

    private BigDecimal calculateTax(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Ticket ticket = this.getTicketItem().getTicket();
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal("0");
        bigDecimal = bigDecimal.subtract(bigDecimal2);
        List<TicketItemTax> list = this.getTaxes();
        if (list != null) {
            if (this.isTaxIncluded().booleanValue()) {
                BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(0.0);
                for (TicketItemTax ticketItemTax : list) {
                    bigDecimal4 = bigDecimal4.add(NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP));
                }
                if (bigDecimal4.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                    return bigDecimal3;
                }
                BigDecimal bigDecimal5 = bigDecimal4.add(NumberUtil.convertToBigDecimal(1.0));
                double d = bigDecimal.doubleValue() / bigDecimal5.doubleValue();
                for (TicketItemTax ticketItemTax : list) {
                    bigDecimal4 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP);
                    BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal(d).multiply(bigDecimal4);
                    ticketItemTax.setTaxAmount(bigDecimal6.doubleValue());
                    bigDecimal3 = bigDecimal3.add(bigDecimal6);
                }
            } else {
                for (TicketItemTax ticketItemTax : list) {
                    BigDecimal bigDecimal7 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP);
                    if (bigDecimal7.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                        return bigDecimal3;
                    }
                    BigDecimal bigDecimal8 = bigDecimal.multiply(bigDecimal7);
                    ticketItemTax.setTaxAmount(bigDecimal8.doubleValue());
                    bigDecimal3 = bigDecimal3.add(bigDecimal8);
                }
            }
        }
        this.buildTaxes();
        return NumberUtil.round(bigDecimal3);
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemTax ticketItemTax : list) {
            d += ticketItemTax.getRate().doubleValue();
        }
        return d;
    }

    private BigDecimal calculateSubTotal(BigDecimal bigDecimal) {
        Double d = this.getItemQuantity();
        if (this.getTicketItem() != null) {
            d = d * Math.abs(this.getTicketItem().getQuantity());
        }
        return bigDecimal.multiply(NumberUtil.convertToBigDecimal(d));
    }

    @Override
    public String getNameDisplay() {
        return this.getItemQuantityDisplay() + " " + this.getNameDisplay(false);
    }

    public String getNameDisplay(boolean bl) {
        Store store;
        boolean bl2;
        if (this.isInfoOnly().booleanValue()) {
            return this.getName().trim();
        }
        double d = Math.abs(this.getItemQuantity());
        String string = "";
        if (d > 1.0) {
            string = NumberUtil.trimDecilamIfNotNeeded(d) + "x ";
        }
        String string2 = d > 1.0 ? string + this.getName() : this.getName().trim();
        if (this.getModifierType() == 1 && !bl) {
            string2 = string2 + "*";
        }
        boolean bl3 = bl2 = (store = Application.getInstance().getStore()).getProperty("showModifierPrice") == null ? false : Boolean.valueOf(store.getProperty("showModifierPrice"));
        if (bl2 && this.getUnitPrice() > 0.0 && !bl) {
            string2 = string + this.getName() + " @" + NumberUtil.formatNumber(this.getUnitPrice());
        }
        if (bl) {
            return string2;
        }
        return " -- " + string2;
    }

    @Override
    public Double getUnitPriceDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getUnitPrice();
    }

    @Override
    public String getItemQuantityDisplay() {
        return "";
    }

    @Override
    public Double getTaxAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getTaxAmount();
    }

    @Override
    public Double getTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getTotalAmount();
    }

    @Override
    public Double getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return this.getSubTotalAmount();
    }

    @Override
    public String getItemCode() {
        return "";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public Double getItemQuantity() {
        Double d = super.getItemQuantity();
        if (d == 0.0) {
            d = (double)super.getItemCount();
        }
        return d;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    @Override
    public Double getSubTotalAmountDisplay() {
        return null;
    }

    @XmlTransient
    public MenuModifier getMenuModifier() {
        return this.menuModifier;
    }

    public void setMenuModifier(MenuModifier menuModifier) {
        this.menuModifier = menuModifier;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public void setTaxes(List<TicketItemTax> list) {
        this.taxes = list;
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String string = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax ticketItemTax = new TicketItemTax();
                    ticketItemTax.setName(jsonObject.getString(TicketItemTax.PROP_NAME));
                    ticketItemTax.setRate(POSUtil.parseDouble("" + jsonObject.get((Object)TicketItemTax.PROP_RATE)));
                    ticketItemTax.setTaxAmount(POSUtil.parseDouble("" + jsonObject.get((Object)TicketItemTax.PROP_TAX_AMOUNT)));
                    this.taxes.add(ticketItemTax);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax ticketItemTax) {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes = this.getTaxes();
        this.taxes.add(ticketItemTax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jSONArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jSONArray.toString());
    }

    public void setTicketItemQuantity(double d) {
        this.ticketItemQuantity = d;
    }

    public double getTicketItemQuantity() {
        if (this.getTicketItem() != null) {
            return this.getTicketItem().getQuantity();
        }
        return this.ticketItemQuantity;
    }
}

