/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Address;
import com.floreantpos.model.dao.BaseAddressDAO;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AddressDAO
extends BaseAddressDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address findAddressById(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Address.PROP_ID, (Object)string));
            Object object = criteria.uniqueResult();
            if (object != null) {
                Address address = (Address)object;
                return address;
            }
            Address address = null;
            return address;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateAddressList(List<Address> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Address address : list) {
                if (address.getId() == null) {
                    this.save(address, session);
                    continue;
                }
                Address address2 = this.get(address.getId());
                if (address2 != null) {
                    String string = address2.getId();
                    long l = address2.getVersion();
                    PropertyUtils.copyProperties((Object)address2, (Object)address);
                    address2.setId(string);
                    address2.setVersion(l);
                    this.update(address2, session);
                    continue;
                }
                address.setVersion(0L);
                this.save(address, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

