/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BaseBookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BookingInfoDAO
extends BaseBookingInfoDAO {
    @Override
    protected void saveOrUpdate(Object object) {
        BookingInfo bookingInfo = (BookingInfo)object;
        bookingInfo.setLastUpdateTime(new Date());
        super.saveOrUpdate(object);
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "2");
    }

    @Override
    protected Serializable save(Object object) {
        BookingInfo bookingInfo = (BookingInfo)object;
        bookingInfo.setLastUpdateTime(new Date());
        Serializable serializable = super.save(object);
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "2");
        return serializable;
    }

    @Override
    public void update(BookingInfo bookingInfo) throws HibernateException {
        bookingInfo.setLastUpdateTime(new Date());
        super.update(bookingInfo);
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "2");
    }

    @Override
    public void saveOrUpdate(BookingInfo bookingInfo, Session session) throws HibernateException {
        bookingInfo.setLastUpdateTime(new Date());
        super.saveOrUpdate(bookingInfo, session);
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "2");
    }

    @Override
    public void update(BookingInfo bookingInfo, Session session) throws HibernateException {
        bookingInfo.setLastUpdateTime(new Date());
        super.update(bookingInfo, session);
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "2");
    }

    @Override
    protected Serializable save(Object object, Session session) {
        BookingInfo bookingInfo = (BookingInfo)object;
        bookingInfo.setLastUpdateTime(new Date());
        Serializable serializable = super.save(object, session);
        OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "2");
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getBookedTables(Date date, Date date2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)date), (Criterion)Restrictions.le((String)BookingInfo.PROP_TO_DATE, (Object)date2)));
            List list = criteria.list();
            if (list != null) {
                List list2 = list;
                return list2;
            }
            List<BookingInfo> list3 = null;
            return list3;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getAllOpenBooking() {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ne((String)BookingInfo.PROP_STATUS, (Object)"close"));
            List list2 = list = criteria.list();
            return list2;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void setUrgentBookingInfoInTables(Set<ShopTable> set, Session session) {
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_CLOSED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            calendar.add(12, 30);
            Date date2 = calendar.getTime();
            criteria.add(Restrictions.between((String)BookingInfo.PROP_FROM_DATE, (Object)date, (Object)date2));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTable serializable2 : set) {
                arrayList.add(serializable2.getId());
            }
            criteria.createAlias("tables", "tableIds");
            criteria.add(Restrictions.in((String)("tableIds." + ShopTable.PROP_ID), arrayList));
            List list = criteria.list();
            if (list.isEmpty()) {
                return;
            }
            ArrayList<ShopTable> arrayList2 = new ArrayList<ShopTable>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BookingInfo bookingInfo = (BookingInfo)iterator.next();
                List<ShopTable> list2 = bookingInfo.getTables();
                Collection collection = CollectionUtils.intersection(set, list2);
                for (ShopTable shopTable : collection) {
                    TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
                    if (!tableStatus.equals((Object)TableStatus.Available)) continue;
                    shopTable.setCurrentBookingId(bookingInfo.getId());
                    shopTable.setTableStatus(TableStatus.Booked);
                    if (bookingInfo.getCustomer() != null) {
                        shopTable.setCustomerName(bookingInfo.getCustomer().getName());
                    }
                    arrayList2.add(shopTable);
                }
            }
            if (!arrayList2.isEmpty()) {
                ShopTableDAO.getInstance().updateTableList(arrayList2, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getClass(), exception);
        }
    }

    public void setBookingStatus(BookingInfo bookingInfo, String string, List<ShopTableStatus> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            bookingInfo.setStatus(string);
            this.saveOrUpdate(bookingInfo);
            if (string.equals("seat") || string.equals("delay")) {
                ShopTableDAO.getInstance().bookedTables(list);
            }
            if (string.equals("cancel") || string.equals("no appear") || string.equals("close")) {
                ShopTableDAO.getInstance().freeTables(list);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(BookingInfo.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BookingInfo> getTodaysBooking() {
        return this.getTodaysBooking(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getTodaysBooking(String string) {
        try (Session session = null;){
            List list;
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setLenient(false);
            calendar2.setTime(new Date());
            calendar2.set(11, 23);
            calendar2.set(12, 59);
            calendar2.set(13, 59);
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            if (string == null) {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)calendar.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)calendar2.getTime()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)calendar.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)calendar2.getTime())).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)string));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getAllBookedTablesByDate(Date date, Date date2) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.gt((String)BookingInfo.PROP_TO_DATE, (Object)date), (Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)date2))).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            List list = criteria.list();
            ArrayList<ShopTable> arrayList = new ArrayList<ShopTable>();
            for (BookingInfo bookingInfo : list) {
                for (ShopTable shopTable : bookingInfo.getTables()) {
                    arrayList.add(shopTable);
                }
            }
            ArrayList<ShopTable> arrayList2 = arrayList;
            return arrayList2;
        }
        return null;
    }

    public List<BookingInfo> getAllBookingInfoByDate(Date date, Date date2) {
        return this.getAllBookingInfoByDate(date, date2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingInfo> getAllBookingInfoByDate(Date date, Date date2, String string) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            if (string == null) {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)date)).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)date2));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)date)).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)date2)).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)string));
            }
            List list = criteria.list();
            if (list != null) {
                List list2 = list;
                return list2;
            }
            List<BookingInfo> list3 = null;
            return list3;
        }
        return null;
    }
}

