/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.swing.PaginatedTableModel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ImageResourceDAO
extends BaseImageResourceDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginatedTableModel paginatedTableModel, ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            if (iMAGE_CATEGORY != null) {
                criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)iMAGE_CATEGORY.getType()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)ImageResource.PROP_DESCRIPTION, (String)string, (MatchMode)MatchMode.START));
            }
            if (iMAGE_CATEGORY != ImageResource.IMAGE_CATEGORY.DELETED) {
                criteria.add((Criterion)Restrictions.ne((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.DELETED.getType()));
            }
            int n = paginatedTableModel.getCurrentRowIndex();
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list = criteria.list();
            paginatedTableModel.setRows(list);
        }
        catch (Exception exception) {
            paginatedTableModel.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getDefaultFloorImage(InputStream inputStream) throws Exception {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType()));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_DESCRIPTION, (Object)"default_floor_image"));
            List list = criteria.list();
            if (list.size() > 0) {
                ImageResource imageResource = (ImageResource)list.get(0);
                return imageResource;
            }
            if (inputStream != null) {
                ImageResource imageResource = new ImageResource();
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                imageResource.setImageData(new SerialBlob(byArray));
                imageResource.setDescription("default_floor_image");
                imageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.save(imageResource);
                ImageResource imageResource2 = imageResource;
                return imageResource2;
            }
        }
        finally {
            this.closeSession(session);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource findById(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_ID, (Object)string));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                ImageResource imageResource = null;
                return imageResource;
            }
            ImageResource imageResource = (ImageResource)list.get(0);
            return imageResource;
        }
        catch (Exception exception) {
            ImageResource imageResource = null;
            return imageResource;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdate(List<ImageResource> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ImageResource imageResource : list) {
                session.saveOrUpdate((Object)imageResource);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ImageResourceDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

