/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseInventoryLocation;
import com.floreantpos.model.dao.BaseInventoryStockDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryStockDAO
extends BaseInventoryStockDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryStock initialize(InventoryStock inventoryStock) {
        if (inventoryStock == null || inventoryStock.getId() == null) {
            return inventoryStock;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryStock);
            InventoryStock inventoryStock2 = inventoryStock;
            return inventoryStock2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<InventoryStock> getInventoryStock(String string, Object object) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object2;
            Object object3;
            session = this.getSession();
            criteria = session.createCriteria(InventoryStock.class);
            if (StringUtils.isNotEmpty((String)string)) {
                object3 = Restrictions.disjunction();
                object3.add(Restrictions.ilike((String)InventoryStock.PROP_ITEM_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                object3.add(Restrictions.ilike((String)InventoryStock.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                object3.add(Restrictions.ilike((String)InventoryStock.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object3);
            }
            object3 = criteria.list();
            if (object instanceof InventoryLocation) {
                object2 = (InventoryLocation)object;
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)((BaseInventoryLocation)object2).getId()));
                object3 = criteria.list();
            }
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    InventoryStock inventoryStock = (InventoryStock)object2.next();
                    MenuItem menuItem = MenuItemDAO.getInstance().get(inventoryStock.getMenuItemId());
                    if (menuItem == null || menuItem.isInventoryItem().booleanValue()) continue;
                    object2.remove();
                }
            }
            return object3;
        }
        catch (Exception exception) {
            return criteria.list();
        }
    }

    public void addNewStock(InventoryStock inventoryStock, InventoryTransaction inventoryTransaction, MenuItem menuItem) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)inventoryStock);
            session.saveOrUpdate((Object)inventoryTransaction);
            session.saveOrUpdate((Object)menuItem);
            transaction.commit();
        }
    }

    public InventoryStock getInventoryStock(MenuItem menuItem, InventoryLocation inventoryLocation, String string) {
        if (inventoryLocation == null) {
            return this.getInventoryStock(menuItem, (String)null, string);
        }
        return this.getInventoryStock(menuItem, inventoryLocation.getId(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryStock getInventoryStock(MenuItem menuItem, String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            InventoryStock inventoryStock = this.getInventoryStock(menuItem, string, string2, session);
            return inventoryStock;
        }
        catch (Exception exception) {
            PosLog.error(InventoryStockDAO.class, exception.getMessage(), exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public InventoryStock getInventoryStock(MenuItem menuItem, String string, String string2, Session session) {
        List list;
        Criteria criteria = session.createCriteria(InventoryStock.class);
        if (menuItem != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        }
        if (string != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)string));
        }
        if (string2 != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_UNIT, (Object)string2));
        }
        if ((list = criteria.list()) != null && list.size() > 0) {
            return (InventoryStock)list.get(0);
        }
        return null;
    }

    public List<InventoryStock> getInventoryStocks(MenuItem menuItem) {
        return this.getInventoryStocks(menuItem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStock> getInventoryStocks(MenuItem menuItem, InventoryLocation inventoryLocation) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryStock.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
            if (inventoryLocation != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)inventoryLocation.getId()));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public void addTransfer(InventoryTransaction inventoryTransaction, InventoryTransaction inventoryTransaction2, InventoryStock inventoryStock, InventoryStock inventoryStock2, MenuItem menuItem) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)inventoryStock);
            session.saveOrUpdate((Object)inventoryStock2);
            session.saveOrUpdate((Object)inventoryTransaction);
            session.saveOrUpdate((Object)inventoryTransaction2);
            session.saveOrUpdate((Object)menuItem);
            transaction.commit();
        }
    }

    public List<InventoryStock> getInventoryOnhandReprotData(String string, InventoryLocation inventoryLocation) {
        Session session = null;
        Criteria criteria = null;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        session = this.getSession();
        criteria = session.createCriteria(InventoryStock.class);
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_ITEM_NAME));
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)InventoryStock.PROP_ITEM_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)InventoryStock.PROP_SKU, (Object)string)));
        }
        if (inventoryLocation != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)inventoryLocation.getId()));
        }
        List list = criteria.list();
        for (InventoryStock inventoryStock : list) {
            String string2 = inventoryStock.getMenuItemId();
            String string3 = inventoryStock.getLocationId();
            Double d = (Double)hashMap2.get(string2);
            String string4 = (String)hashMap.get(string3);
            if (d == null) {
                d = this.getMenuItemCost(string2, session);
            }
            if (string4 == null) {
                string4 = this.getLocationName(string3, session);
            }
            inventoryStock.setMenuItemCost(d);
            inventoryStock.setLocationName(string4);
        }
        return list;
    }

    private String getLocationName(String string, Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ID, (Object)string));
        criteria.setProjection((Projection)Projections.property((String)InventoryLocation.PROP_NAME));
        Object object = criteria.uniqueResult();
        if (object instanceof String) {
            return ((String)object).toString();
        }
        return null;
    }

    private Double getMenuItemCost(String string, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)string));
        criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_COST));
        Object object = criteria.uniqueResult();
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStock> findStocksForStockCountMultiItemSelection(MenuGroup menuGroup, InventoryVendor inventoryVendor, InventoryLocation inventoryLocation) {
        Criteria criteria;
        Session session;
        block9: {
            List<InventoryStock> list;
            session = null;
            criteria = null;
            try {
                if (inventoryLocation != null) break block9;
                list = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list;
        }
        session = this.createNewSession();
        List list = null;
        if (inventoryVendor != null) {
            criteria = session.createCriteria(InventoryVendorItems.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
            criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
            criteria.setProjection((Projection)Projections.property((String)"item.id"));
            list = criteria.list();
        }
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
        criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
        }
        if (list != null && !list.isEmpty()) {
            criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)list));
        }
        criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_ID));
        if (list == null) {
            list = criteria.list();
        } else {
            list.retainAll(criteria.list());
        }
        criteria = session.createCriteria(InventoryStock.class);
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_ITEM_NAME));
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_UNIT));
        criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)inventoryLocation.getId()));
        if (list != null && !list.isEmpty()) {
            criteria.add(Restrictions.in((String)InventoryStock.PROP_MENU_ITEM_ID, (Collection)list));
        }
        List list2 = criteria.list();
        this.closeSession(session);
        return list2;
    }
}

