/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.dao.BaseMenuItemDAO;
import com.floreantpos.model.dao.ComboItemDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.Transformers;

public class MenuItemDAO
extends BaseMenuItemDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        ((MenuItem)object).setLastUpdateTime(StoreDAO.getServerTimestamp());
        Serializable serializable = super.save(object, session);
        this.updateDependentModels((MenuItem)object, session);
        return serializable;
    }

    @Override
    protected void update(Object object, Session session) {
        ((MenuItem)object).setLastUpdateTime(StoreDAO.getServerTimestamp());
        super.update(object, session);
        this.updateDependentModels((MenuItem)object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        ((MenuItem)object).setLastUpdateTime(StoreDAO.getServerTimestamp());
        super.saveOrUpdate(object, session);
        this.updateDependentModels((MenuItem)object, session);
    }

    private void updateDependentModels(MenuItem menuItem, Session session) {
        this.saveInventoryStockStatus(menuItem, session);
        MenuPageItemDAO menuPageItemDAO = MenuPageItemDAO.getInstance();
        List<MenuPageItem> list = menuPageItemDAO.getPageItemFor(menuItem, session);
        if (list != null) {
            for (MenuPageItem object2 : list) {
                object2.setMenuItem(menuItem);
                menuPageItemDAO.saveOrUpdate(object2, session);
            }
        }
        List<ComboItem> list2 = ComboItemDAO.getInstance().getByMenuItem(menuItem.getId(), session);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ComboItem comboItem = (ComboItem)iterator.next();
            comboItem.setMenuItem(menuItem);
            ComboItemDAO.getInstance().update(comboItem, session);
        }
        this.updateDependentStockModel(menuItem, session);
    }

    private void updateDependentStockModel(MenuItem menuItem, Session session) throws HibernateException {
        String string = "update InventoryStock set %s=:itemName, %s=:sku, %s=:barCode where %s=:menuItemId";
        string = String.format(string, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_BARCODE, InventoryStock.PROP_MENU_ITEM_ID);
        Query query = session.createQuery(string);
        query.setParameter("itemName", (Object)menuItem.getName());
        query.setParameter("sku", (Object)menuItem.getSku());
        query.setParameter("barCode", (Object)menuItem.getBarcode());
        query.setParameter("menuItemId", (Object)menuItem.getId());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<MenuItem> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuItem menuItem : list) {
                menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
                session.merge((Object)menuItem);
            }
            transaction.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    private void saveInventoryStockStatus(MenuItem menuItem, Session session) {
        if (!menuItem.isInventoryItem().booleanValue()) {
            return;
        }
        MenuItemInventoryStatus menuItemInventoryStatus = menuItem.getStockStatus();
        if (menuItemInventoryStatus == null) {
            menuItemInventoryStatus = new MenuItemInventoryStatus();
            menuItem.setStockStatus(menuItemInventoryStatus);
        }
        if (menuItemInventoryStatus.getId() == null) {
            menuItemInventoryStatus.setId(menuItem.getId());
            MenuItemInventoryStatusDAO.getInstance().save(menuItemInventoryStatus, session);
        }
    }

    @Override
    public void saveOrUpdate(MenuItem menuItem) throws HibernateException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
            if (menuItem.getId() == null) {
                this.save(menuItem, session);
            } else {
                this.update(menuItem, session);
            }
            if (!menuItem.isInventoryItem().booleanValue()) {
                transaction.commit();
                return;
            }
            MenuItemInventoryStatus menuItemInventoryStatus = menuItem.getStockStatus();
            if (menuItemInventoryStatus == null) {
                menuItemInventoryStatus = new MenuItemInventoryStatus();
                menuItemInventoryStatus.setId(menuItem.getId());
                menuItem.setStockStatus(menuItemInventoryStatus);
                MenuItemInventoryStatusDAO.getInstance().save(menuItemInventoryStatus, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeUnits(MenuItem menuItem) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            if (!Hibernate.isInitialized(menuItem.getStockUnits())) {
                Hibernate.initialize(menuItem.getStockUnits());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(String string, BeanTableModel<MenuItem> beanTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            beanTableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public int rowCount(Boolean bl, MenuGroup menuGroup, String string, Object object, boolean bl2) {
        return this.rowCount(bl, menuGroup, string, object, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean bl, MenuGroup menuGroup, String string, Object object, boolean bl2, Boolean bl3) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (bl3 != null && bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl3));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(object, session, criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean bl, MenuGroup menuGroup, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem loadInitialized(String string) throws HibernateException {
        MenuItem menuItem = super.get(string);
        this.initialize(menuItem);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getInitialized(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            MenuItem menuItem = this.get(string, session);
            this.initialize(menuItem, session);
            MenuItem menuItem2 = menuItem;
            return menuItem2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(MenuItem menuItem) {
        if (menuItem == null || menuItem.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            this.initialize(menuItem, session);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeVariants(MenuItem menuItem) {
        if (menuItem == null || menuItem.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.update((Object)menuItem);
            Hibernate.initialize(menuItem.getVariants());
            Hibernate.initialize(menuItem.getAttributes());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(MenuItem menuItem, Session session) {
        Object object;
        Object object2;
        Hibernate.initialize(menuItem.getStockUnits());
        Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
        Hibernate.initialize(menuItem.getPizzaPriceList());
        Hibernate.initialize(menuItem.getDiscounts());
        Hibernate.initialize(menuItem.getComboGroups());
        Hibernate.initialize(menuItem.getComboItems());
        Hibernate.initialize(menuItem.getVariants());
        List<MenuItem> list = menuItem.getVariants();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (MenuItem)object2.next();
                Hibernate.initialize(((BaseMenuItem)object).getAttributes());
            }
        }
        if ((object2 = menuItem.getMenuItemModiferSpecs()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)object.next();
                Hibernate.initialize(menuItemModifierSpec.getDefaultModifierList());
                Hibernate.initialize(menuItemModifierSpec.getModifierPages());
            }
        }
    }

    public List<MenuItem> findByParent(Terminal terminal, MenuGroup menuGroup, boolean bl) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuItem> getVariants(MenuItem menuItem) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuItem != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PARENT_MENU_ITEM_ID, (Object)menuItem.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object object) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            this.addOrderTypeFilter(object, session, criteria);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, MenuGroup menuGroup, Object object, boolean bl, PaginatedListModel paginatedListModel, boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!bl2) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            this.addOrderTypeFilter(object, session, criteria);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItemModifierSpec> findModifierGroups(MenuItem menuItem) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)menuItem.getId()));
            MenuItem menuItem2 = (MenuItem)criteria.uniqueResult();
            Hibernate.initialize(menuItem2.getMenuItemModiferSpecs());
            List<MenuItemModifierSpec> list = menuItem2.getMenuItemModiferSpecs();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String string, MenuGroup menuGroup, Object object, String string2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (string2.equals("InventoryItem")) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            }
            this.addOrderTypeFilter(object, session, criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems(String string, MenuGroup menuGroup, Object object) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(object, session, criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseParent(List<MenuItem> list) {
    }

    public void releaseParentAndDelete(MenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            String string = "delete from MENUITEM_DISCOUNT where MENUITEM_ID='%s'";
            string = String.format(string, menuItem.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            String string2 = "delete from MENU_PAGE_ITEM where MENU_ITEM_ID='%s'";
            string2 = String.format(string2, menuItem.getId());
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            String string3 = "delete from RECIPE_TABLE where MENU_ITEM_ID='%s'";
            string3 = String.format(string3, menuItem.getId());
            SQLQuery sQLQuery3 = session.createSQLQuery(string3);
            sQLQuery3.executeUpdate();
            session.delete((Object)menuItem);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem getMenuItemByBarcodeOrSKU(String string) {
        MenuItem menuItem = this.getMenuItemByBarcode(string);
        if (menuItem == null) {
            menuItem = this.getMenuItemBySKU(string);
        }
        return menuItem;
    }

    public MenuItem getMenuItemByBarcode(String string) {
        return this.getMenuItemByBarcode(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcode(String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl));
            }
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_BARCODE, (Object)string));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)list.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemBySKU(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_SKU, (Object)string));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)list.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItem> getMenuItemByName(String string) {
        return this.getMenuItemByName(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemByName(String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItem> getMenuItemsByName(MenuGroup menuGroup, String string) {
        return this.getMenuItemsByName(menuGroup, string, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(MenuGroup menuGroup, String string, boolean bl, boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if ((list = criteria.list()) == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(MenuCategory menuCategory, String string, boolean bl, boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            if (!bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if ((list = criteria.list()) == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItem> getMenuItemsByName(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String string, boolean bl) {
        return this.getMenuItemsByName(orderType, menuCategory, menuGroup, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String string, boolean bl, boolean bl2) {
        MenuCategory menuCategory22;
        if (menuGroup != null) {
            return this.getMenuItemsByName(menuGroup, string, bl, bl2);
        }
        if (menuCategory != null) {
            return this.getMenuItemsByName(menuCategory, string, bl, bl2);
        }
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MenuCategory menuCategory22 : list) {
            arrayList.add(menuCategory22.getId());
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        Session session = null;
        menuCategory22 = null;
        try {
            session = this.createNewSession();
            menuCategory22 = session.createCriteria(MenuItem.class);
            if (bl) {
                menuCategory22.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!bl2) {
                menuCategory22.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            menuCategory22.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            menuCategory22.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, arrayList));
            List list2 = menuCategory22.list();
            if (list2 == null || list2.isEmpty()) {
                List<MenuItem> list3 = null;
                return list3;
            }
            List list4 = list2;
            return list4;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String string, String string2, String string3, ReportGroup reportGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotEmpty((String)string3)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string3));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string2, (MatchMode)MatchMode.START));
            }
            if (reportGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_REPORT_GROUP_ID, (Object)reportGroup.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findMenuItemsForStockCount(String string, MenuGroup menuGroup, InventoryVendor inventoryVendor, InventoryLocation inventoryLocation) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            List list = null;
            if (inventoryVendor != null) {
                criteria = session.createCriteria(InventoryVendorItems.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
                criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
                criteria.setProjection((Projection)Projections.property((String)"item.id"));
                list = criteria.list();
            }
            if (inventoryLocation != null) {
                criteria = session.createCriteria(InventoryStock.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)inventoryLocation.getId()));
                criteria.setProjection((Projection)Projections.property((String)InventoryStock.PROP_MENU_ITEM_ID));
                if (list == null) {
                    list = criteria.list();
                } else {
                    list.retainAll(criteria.list());
                }
            }
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.START))));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)list));
            }
            criteria.setMaxResults(200);
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)false), (Criterion)Restrictions.isNull((String)MenuItem.PROP_PIZZA_TYPE)));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getInventortItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem getReplenishedMenuItem(Integer n, Session session) {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)n));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        Double d = 0.0;
        if (menuItem != null) {
            d = menuItem.getReorderLevel();
        }
        if (d == 0.0) {
            return null;
        }
        criteria = session.createCriteria(MenuItemInventoryStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemInventoryStatus.PROP_ID, (Object)n));
        criteria.add((Criterion)Restrictions.lt((String)MenuItemInventoryStatus.PROP_AVAILABLE_UNIT, (Object)d));
        MenuItemInventoryStatus menuItemInventoryStatus = (MenuItemInventoryStatus)criteria.uniqueResult();
        if (menuItemInventoryStatus == null) {
            return null;
        }
        menuItem.setStockStatus(menuItemInventoryStatus);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getReOrderedMenuItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "item");
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    private DetachedCriteria getDetachedCriteriaForStockStatus(String string) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(MenuItemInventoryStatus.class, (String)"status").setProjection((Projection)Projections.property((String)MenuItemInventoryStatus.PROP_ID)).add((Criterion)Restrictions.eqProperty((String)MenuItemInventoryStatus.PROP_ID, (String)string)).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND)), (Criterion)Restrictions.leProperty((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND), (String)("item." + MenuItem.PROP_REORDER_LEVEL))));
        return detachedCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowReOrderedItemCount(MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.setProjection(Projections.rowCount());
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReorderedMenuItems(PaginationSupport paginationSupport, MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String string, String string2, String string3, MenuGroup menuGroup, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, string, string2, string3, menuGroup);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, string, string2, string3, menuGroup);
            if (pagination != null) {
                object = (Number)criteria.uniqueResult();
                pagination.setNumRows(((Number)object).intValue());
            }
            object = list;
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, String string, String string2, String string3, MenuGroup menuGroup) {
        if (StringUtils.isNotEmpty((String)string3)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string3));
        }
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string2, (MatchMode)MatchMode.ANYWHERE));
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
        }
    }

    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl) {
        this.loadMenuItems(paginationSupport, bl, null, null, null, false);
    }

    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, MenuCategory menuCategory, boolean bl2) {
        this.loadMenuItems(paginationSupport, bl, menuGroup, string, menuCategory, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem() {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem(String string, MenuGroup menuGroup, MenuCategory menuCategory) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_MENU_GROUP_ID));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, MenuCategory menuCategory, boolean bl2, Boolean bl3) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (bl3 != null && bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl3));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                object.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                object.add(Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                object.add(Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object);
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            object = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(((Number)object).intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void addOrderTypeFilter(Object object, Session session, Criteria criteria) {
        if (object instanceof OrderType) {
            OrderType orderType = (OrderType)object;
            Criteria criteria2 = session.createCriteria(MenuCategory.class);
            criteria2.createAlias("orderTypes", "ot");
            criteria2.add(Restrictions.in((String)("ot." + OrderType.PROP_ID), Arrays.asList(orderType.getId())));
            List list = criteria2.list();
            if (list != null && !list.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MenuCategory menuCategory : list) {
                    arrayList.add(menuCategory.getId());
                }
                criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, arrayList));
            }
        }
    }

    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, Boolean bl2, Boolean bl3, Boolean bl4) {
        this.findByBarcodeOrName(paginationSupport, bl, menuGroup, string, bl2, bl3, bl4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, Boolean bl2, Boolean bl3, Boolean bl4, String ... stringArray) {
        Session session = null;
        Criteria criteria = null;
        try {
            Criterion criterion;
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                criterion = Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                String[] stringArray2 = Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                Disjunction disjunction = Restrictions.or((Criterion[])new Criterion[]{object, criterion, stringArray2});
                criteria.add((Criterion)disjunction);
            }
            if (bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (bl3 != null && bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl3));
            }
            if (!bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)bl2));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (bl4.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl4));
            }
            criteria.setProjection(Projections.rowCount());
            object = (Number)criteria.uniqueResult();
            if (object != null) {
                paginationSupport.setNumRows(((Number)object).intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (stringArray != null && stringArray.length > 0) {
                criterion = Projections.projectionList();
                for (String string2 : stringArray) {
                    criterion.add((Projection)Projections.property((String)string2), string2);
                }
                criteria.setProjection((Projection)criterion);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem findByName(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list.size() == 0) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)list.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem findByBarcode(String string, Session session) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string.trim()));
        List list = criteria.list();
        if (list.size() > 0) {
            return (MenuItem)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(BeanTableModel beanTableModel, Boolean bl, MenuGroup menuGroup, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            String string2;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)(string2 = beanTableModel.getSortBy()))) {
                criteria.addOrder(beanTableModel.isAscOrder() ? Order.asc((String)string2) : Order.desc((String)string2));
            } else {
                criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
                criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            List list = criteria.list();
            beanTableModel.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport paginationSupport, MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(PaginationSupport paginationSupport, MenuGroup menuGroup, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.START), Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.START)}));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllInventoryItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateStockQuantity(String string, double d, boolean bl, boolean bl2, Session session) {
        MenuItemInventoryStatus menuItemInventoryStatus = MenuItemInventoryStatusDAO.getInstance().get(string, session);
        if (menuItemInventoryStatus == null) {
            menuItemInventoryStatus = new MenuItemInventoryStatus();
            menuItemInventoryStatus.setId(string);
        }
        if (bl) {
            menuItemInventoryStatus.setAvailableUnit(menuItemInventoryStatus.getAvailableUnit() + d);
        }
        if (bl2) {
            menuItemInventoryStatus.setUnitOnHand(menuItemInventoryStatus.getUnitOnHand() + d);
        }
        MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(menuItemInventoryStatus, session);
    }

    public void updateStockQuantity(String string, double d, double d2, boolean bl, boolean bl2, Session session) {
        String string2 = null;
        string2 = bl && bl2 ? String.format("update MenuItem set availableUnit = (availableUnit + %s),unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", d, d, d2, string) : (bl2 ? String.format("update MenuItem set unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", d, d2, string) : String.format("update MenuItem set availableUnit = (availableUnit + %s),cost = %s where id = '%s'", d, d2, string));
        session.createQuery(string2).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsMenuItem(MenuGroup menuGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateLastPurchaseCost(String string, double d, boolean bl, Session session) {
        String string2 = null;
        double d2 = InventoryTransactionDAO.getInstance().findItemAvgCost(string, session);
        double d3 = bl ? d : d2;
        d3 = NumberUtil.roundToTwoDigit(d3);
        string2 = String.format("update MenuItem set lastPurchasedCost = %s,avgCost=%s, cost = %s where id = '%s'", d, d2, d3, string);
        session.createQuery(string2).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastPurchaseCost(PurchaseOrder purchaseOrder, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : list) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                double d = menuItem.getBaseUnitQuantity(purchaseOrderItem.getItemUnitName());
                double d2 = NumberUtil.roundToTwoDigit(purchaseOrderItem.getUnitPrice() / d);
                this.updateLastPurchaseCost(menuItem.getId(), d2, bl, session);
            }
            session.saveOrUpdate((Object)purchaseOrder);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemWithFields(String string, String ... stringArray) throws Exception {
        Session session = null;
        try {
            session = this.createNewSession();
            MenuItem menuItem = this.getMenuItemWithFields(session, string, stringArray);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem getMenuItemWithFields(Session session, String string, String ... stringArray) throws Exception {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)string));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)MenuItem.PROP_ID), MenuItem.PROP_ID);
        for (String string2 : stringArray) {
            projectionList.add((Projection)Projections.property((String)string2), string2);
        }
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        if (menuItem != null) {
            Hibernate.initialize(menuItem.getStockUnits());
        }
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport paginationSupport, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)false));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuItems(List<MenuItem> list, Session session) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            for (MenuItem menuItem : list) {
                this.saveOrUpdateMenuItem(session, menuItem);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    private void saveOrUpdateMenuItem(Session session, MenuItem menuItem) throws Exception {
        MenuItem menuItem2 = this.get(menuItem.getId());
        if (menuItem2 != null) {
            String string = menuItem2.getId();
            long l = menuItem2.getVersion();
            PropertyUtils.copyProperties((Object)menuItem2, (Object)menuItem);
            menuItem2.setId(string);
            menuItem2.setVersion(l);
            this.update(menuItem2, session);
        } else {
            this.save(menuItem, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllUnSyncMenuItems() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuItem.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuItem.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateMenuItemSync(List<String> list, Boolean bl) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update MenuItem set %s=:synced where %s in" + string2;
            string3 = String.format(string3, MenuItem.PROP_CLOUD_SYNCED, MenuItem.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)bl);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string);
        }
    }
}

