/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseMenuModifierDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class MenuModifierDAO
extends BaseMenuModifierDAO {
    public void initialize(MenuModifier menuModifier) {
        if (menuModifier == null || menuModifier.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(menuModifier.getPizzaModifierPriceList()) && Hibernate.isInitialized(menuModifier.getMultiplierPriceList())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuModifier);
            Hibernate.initialize(menuModifier.getPizzaModifierPriceList());
            Hibernate.initialize(menuModifier.getMultiplierPriceList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> getModifierList(String string) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_TAG, (Object)string));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> getMenuModifiers(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(MenuModifier.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(String string, boolean bl, PaginatedListModel paginatedListModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(String string, boolean bl, boolean bl2, BeanTableModel<MenuModifier> beanTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            beanTableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuModifier> getComboModifiers() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuModifier.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_COMBO_MODIFIER, (Object)Boolean.TRUE));
            return criteria.list();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuModifier findName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuModifier menuModifier = (MenuModifier)list.get(0);
                return menuModifier;
            }
            MenuModifier menuModifier = null;
            return menuModifier;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> findAllUnSyncMenuModifier() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuModifier.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuModifier.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateMenuModifierSync(List<String> list, Boolean bl) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update MenuModifier set %s=:synced where %s in" + string2;
            string3 = String.format(string3, MenuModifier.PROP_CLOUD_SYNCED, MenuModifier.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)bl);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string);
        }
    }

    public void saveOrUpdateMenuModifiers(List<MenuModifier> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuModifier menuModifier : list) {
                MenuModifier menuModifier2 = this.get(menuModifier.getId());
                if (menuModifier2 != null) {
                    String string = menuModifier2.getId();
                    long l = menuModifier2.getVersion();
                    PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
                    menuModifier2.setId(string);
                    menuModifier2.setVersion(l);
                    this.update(menuModifier2);
                    continue;
                }
                this.save(menuModifier);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuModifier(PaginationSupport paginationSupport, String string, ModifierGroup modifierGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(string, modifierGroup, criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteria(string, modifierGroup, criteria);
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(String string, ModifierGroup modifierGroup, Criteria criteria) {
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (modifierGroup != null) {
            criteria.createAlias("modifierGroups", "groups");
            criteria.add((Criterion)Restrictions.eq((String)("groups." + ModifierGroup.PROP_ID), (Object)modifierGroup.getId()));
        }
    }
}

